/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.BlockMessageDigest;
import cryptix.util.core.Debug;
import java.io.PrintWriter;

public final class SHA1
extends BlockMessageDigest
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("SHA-1");
    private static final PrintWriter err = Debug.getOutput();
    private static final int HASH_LENGTH = 20;
    private static final int DATA_LENGTH = 64;
    private static String[] texts = new String[]{"abc", "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", ""};
    private static byte[][] hashs = new byte[][]{{-87, -103, 62, 54, 71, 6, -127, 106, -70, 62, 37, 113, 120, 80, -62, 108, -100, -48, -40, -99}, {-124, -104, 62, 68, 28, 59, -46, 110, -70, -82, 74, -95, -7, 81, 41, -27, -27, 70, 112, -15}, {-38, 57, -93, -18, 94, 107, 75, 13, 50, 85, -65, -17, -107, 96, 24, -112, -81, -40, 7, 9}};
    private int[] data;
    private int[] digest;
    private byte[] tmp;
    private int[] w;

    private static void debug(String string) {
        err.println("SHA-1: " + string);
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    protected int engineGetDataLength() {
        return 64;
    }

    private void java_init() {
        this.digest = new int[5];
        this.data = new int[16];
        this.tmp = new byte[64];
        this.w = new int[80];
    }

    public Object clone() {
        return new SHA1(this);
    }

    protected void engineReset() {
        super.engineReset();
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
    }

    protected void engineTransform(byte[] byArray) {
        this.java_transform(byArray);
    }

    private void java_transform(byte[] byArray) {
        SHA1.byte2int(byArray, 0, this.data, 0, 16);
        this.transform(this.data);
    }

    protected byte[] engineDigest(byte[] byArray, int n2) {
        byte[] byArray2 = this.java_digest(byArray, n2);
        this.engineReset();
        return byArray2;
    }

    private byte[] java_digest(byte[] byArray, int n2) {
        if (n2 != 0) {
            System.arraycopy(byArray, 0, this.tmp, 0, n2);
        }
        this.tmp[n2++] = -128;
        if (n2 > 56) {
            while (n2 < 64) {
                this.tmp[n2++] = 0;
            }
            SHA1.byte2int(this.tmp, 0, this.data, 0, 16);
            this.transform(this.data);
            n2 = 0;
        }
        while (n2 < 56) {
            this.tmp[n2++] = 0;
        }
        SHA1.byte2int(this.tmp, 0, this.data, 0, 14);
        long l2 = this.bitcount();
        this.data[14] = (int)(l2 >>> 32);
        this.data[15] = (int)l2;
        this.transform(this.data);
        byte[] byArray2 = new byte[20];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 5) {
            int n5 = this.digest[n4];
            byArray2[n3++] = (byte)(n5 >>> 24);
            byArray2[n3++] = (byte)(n5 >>> 16);
            byArray2[n3++] = (byte)(n5 >>> 8);
            byArray2[n3++] = (byte)n5;
            ++n4;
        }
        return byArray2;
    }

    private static int f1(int n2, int n3, int n4) {
        return (n4 ^ n2 & (n3 ^ n4)) + 1518500249;
    }

    private static int f2(int n2, int n3, int n4) {
        return (n2 ^ n3 ^ n4) + 1859775393;
    }

    private static int f3(int n2, int n3, int n4) {
        return (n2 & n3 | n4 & (n2 | n3)) + -1894007588;
    }

    private static int f4(int n2, int n3, int n4) {
        return (n2 ^ n3 ^ n4) + -899497514;
    }

    private void transform(int[] nArray) {
        int n2 = this.digest[0];
        int n3 = this.digest[1];
        int n4 = this.digest[2];
        int n5 = this.digest[3];
        int n6 = this.digest[4];
        if (debuglevel > 5) {
            SHA1.debug("A=" + n2 + " B=" + n3 + " C=" + n4 + " D=" + n5 + " E=" + n6);
        }
        int[] nArray2 = this.w;
        int n7 = 0;
        while (n7 < 16) {
            nArray2[n7] = nArray[n7];
            if (debuglevel > 8) {
                SHA1.debug("       " + n7 + "=" + nArray[n7]);
            }
            ++n7;
        }
        n7 = 16;
        while (n7 < 80) {
            int n8;
            nArray2[n7] = n8 = nArray2[n7 - 16] ^ nArray2[n7 - 14] ^ nArray2[n7 - 8] ^ nArray2[n7 - 3];
            nArray2[n7] = n8 << 1 | n8 >>> -1;
            ++n7;
        }
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[0];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[1];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n6, n2, n3) + nArray2[2];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n6, n2) + nArray2[3];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n6) + nArray2[4];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[5];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[6];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n6, n2, n3) + nArray2[7];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n6, n2) + nArray2[8];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n6) + nArray2[9];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[10];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[11];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n6, n2, n3) + nArray2[12];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n6, n2) + nArray2[13];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n6) + nArray2[14];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[15];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[16];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n6, n2, n3) + nArray2[17];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n6, n2) + nArray2[18];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n6) + nArray2[19];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[20];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[21];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n6, n2, n3) + nArray2[22];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n6, n2) + nArray2[23];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n6) + nArray2[24];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[25];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[26];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n6, n2, n3) + nArray2[27];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n6, n2) + nArray2[28];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n6) + nArray2[29];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[30];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[31];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n6, n2, n3) + nArray2[32];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n6, n2) + nArray2[33];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n6) + nArray2[34];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[35];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[36];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n6, n2, n3) + nArray2[37];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n6, n2) + nArray2[38];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n6) + nArray2[39];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[40];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[41];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n6, n2, n3) + nArray2[42];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n6, n2) + nArray2[43];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n6) + nArray2[44];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[45];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[46];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n6, n2, n3) + nArray2[47];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n6, n2) + nArray2[48];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n6) + nArray2[49];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[50];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[51];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n6, n2, n3) + nArray2[52];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n6, n2) + nArray2[53];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n6) + nArray2[54];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[55];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[56];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n6, n2, n3) + nArray2[57];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n6, n2) + nArray2[58];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n6) + nArray2[59];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[60];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[61];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n6, n2, n3) + nArray2[62];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n6, n2) + nArray2[63];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n6) + nArray2[64];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[65];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[66];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n6, n2, n3) + nArray2[67];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n6, n2) + nArray2[68];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n6) + nArray2[69];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[70];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[71];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n6, n2, n3) + nArray2[72];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n6, n2) + nArray2[73];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n6) + nArray2[74];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[75];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[76];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n6, n2, n3) + nArray2[77];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n6, n2) + nArray2[78];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n6) + nArray2[79];
        n4 = n4 << 30 | n4 >>> -30;
        this.digest[0] = this.digest[0] + n2;
        this.digest[1] = this.digest[1] + n3;
        this.digest[2] = this.digest[2] + n4;
        this.digest[3] = this.digest[3] + n5;
        this.digest[4] = this.digest[4] + n6;
        if (debuglevel > 5) {
            SHA1.debug("d1=" + this.digest[0] + " d1=" + this.digest[1] + " d2=" + this.digest[2] + " d3=" + this.digest[3] + " d4=" + this.digest[4]);
        }
    }

    private static void byte2int(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        while (n4-- > 0) {
            nArray[n3++] = byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            SHA1.self_test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static final void self_test() throws Exception {
        int n2 = hashs[0].length;
        int n3 = 0;
        while (n3 < texts.length) {
            SHA1 sHA1 = new SHA1();
            byte[] byArray = texts[n3].getBytes();
            int n4 = 0;
            while (n4 < texts[n3].length()) {
                sHA1.engineUpdate(byArray[n4]);
                ++n4;
            }
            if (SHA1.notEquals(sHA1.engineDigest(), hashs[n3])) {
                throw new Exception("hash #" + n3 + " failed");
            }
            ++n3;
        }
    }

    private static final boolean notEquals(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray2[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public SHA1() {
        super("SHA-1");
        this.java_init();
        this.reset();
    }

    private SHA1(SHA1 sHA1) {
        this();
        this.data = (int[])sHA1.data.clone();
        this.digest = (int[])sHA1.digest.clone();
        this.tmp = (byte[])sHA1.tmp.clone();
        this.w = (int[])sHA1.w.clone();
    }
}

