/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.elgamal;

import cryptix.CryptixException;
import cryptix.provider.elgamal.ElGamalAlgorithm;
import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Random;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public abstract class Any_ElGamal_PKCS1Signature
extends Signature {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("ElGamal", "Any_ElGamal_PKCS1Signature");
    private static final PrintWriter err = Debug.getOutput();
    private static final int MIN_BITLENGTH = 256;
    private static final int POSITIVE = 1;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger p;
    private BigInteger g;
    private BigInteger x;
    private BigInteger y;
    private int primeLen;
    private Random rng;
    private MessageDigest md;

    private static void debug(String string) {
        err.println("Any_ElGamal_PKCS1Signature: " + string);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("ElGamal: signing key does not implement java.security.interfaces.ElGamalPrivateKey");
        }
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)privateKey;
        BigInteger bigInteger = elGamalPrivateKey.getX();
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getX() == null");
        }
        this.initInternal(elGamalPrivateKey.getP(), elGamalPrivateKey.getG(), bigInteger, elGamalPrivateKey.getY());
        if (this.rng == null) {
            this.rng = new SecureRandom();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("ElGamal: verification key does not implement java.security.interfaces.ElGamalPublicKey");
        }
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)publicKey;
        this.initInternal(elGamalPublicKey.getP(), elGamalPublicKey.getG(), null, elGamalPublicKey.getY());
        if (this.rng == null) {
            this.rng = new SecureRandom();
        }
    }

    private void initInternal(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getP() == null");
        }
        if (bigInteger2 == null) {
            throw new InvalidKeyException("ElGamal: getG() == null");
        }
        if (bigInteger4 == null) {
            throw new InvalidKeyException("ElGamal: getY() == null");
        }
        if (bigInteger.bitLength() < 256) {
            throw new InvalidKeyException("ElGamal: getP().bitLength() < 256");
        }
        if (bigInteger.compareTo(ONE) <= 0) {
            throw new InvalidKeyException("ElGamal: getP() < 2");
        }
        this.p = bigInteger;
        this.g = bigInteger2;
        this.x = bigInteger3;
        this.y = bigInteger4;
        this.primeLen = (this.p.bitLength() + 7) / 8;
        this.md.reset();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.md.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for signing");
        }
        BigInteger bigInteger = this.makePKCS1();
        BigInteger[] bigIntegerArray = new BigInteger[2];
        ElGamalAlgorithm.sign(bigInteger, bigIntegerArray, this.p, this.g, this.x, this.rng);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BI.toStream(bigIntegerArray[0], byteArrayOutputStream);
            BI.toStream(bigIntegerArray[1], byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new SignatureException("BI.toStream() failed");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for verification");
        }
        BigInteger bigInteger3 = this.makePKCS1();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            bigInteger2 = BI.fromStream(byteArrayInputStream);
            bigInteger = BI.fromStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new SignatureException("BI.fromStream() failed");
        }
        return ElGamalAlgorithm.verify(bigInteger3, bigInteger2, bigInteger, this.p, this.g, this.y);
    }

    protected void engineSetParameter(String string, Object object) {
        if (string.equals("random")) {
            if (!(object instanceof Random)) {
                throw new InvalidParameterException("value must be an instance of java.util.Random");
            }
            this.rng = (Random)object;
            return;
        }
        throw new InvalidParameterException(string);
    }

    protected Object engineGetParameter(String string) {
        if (string.equals("random")) {
            return this.rng;
        }
        return null;
    }

    private BigInteger makePKCS1() {
        byte[] byArray = this.md.digest();
        int n2 = byArray.length;
        byte[] byArray2 = new byte[this.primeLen];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n3 = byArray3.length;
        int n4 = this.primeLen - 3 - n3 - n2;
        int n5 = 0;
        while (n5 < n4) {
            byArray2[2 + n5] = -1;
            ++n5;
        }
        System.arraycopy(byArray3, 0, byArray2, n4 + 3, n3);
        System.arraycopy(byArray, 0, byArray2, this.primeLen - n2, n2);
        if (debuglevel >= 4) {
            Any_ElGamal_PKCS1Signature.debug("PKCS#1 frame = " + Hex.dumpString(byArray2));
        }
        return new BigInteger(byArray2);
    }

    protected abstract byte[] getAlgorithmEncoding();

    protected Any_ElGamal_PKCS1Signature(String string) {
        super(string + "/ElGamal/PKCS#1");
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + string + " MessageDigest\n" + exception);
        }
    }
}

