/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class Square
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel;
    private static final PrintWriter err;
    private static NativeLink linkStatus;
    private static final byte[] SE;
    private static final byte[] SD;
    private static final int[] TE;
    private static final int[] TD;
    private static final int BLOCK_SIZE = 16;
    private static final int R = 8;
    private static final int ROOT = 501;
    private static final int[] OFFSET;
    private static final String[][] tests;
    private long native_cookie;
    private Object native_lock;
    private int[][] sKey = new int[9][4];

    private static void debug(String string) {
        err.println("Square: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(Square.getLibMajorVersion(), Square.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    Square.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                Square.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    Square.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 16;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key, true);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.makeKey(key, false);
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 16;
        n3 = n5 * 16;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += 16;
                    n4 += 16;
                    ++n6;
                }
            }
        } else if (bl) {
            int n7 = 0;
            while (n7 < n5) {
                this.square((byte[])object, n2, byArray, n4, TE, SE);
                n2 += 16;
                n4 += 16;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n5) {
                this.square((byte[])object, n2, byArray, n4, TD, SD);
                n2 += 16;
                n4 += 16;
                ++n8;
            }
        }
        return n3;
    }

    private void makeKey(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var5_7 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        Square.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        int n2 = 0;
        if (bl) {
            int n3 = 0;
            while (n3 < 4) {
                this.sKey[0][n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                ++n3;
            }
            n3 = 1;
            while (n3 < 9) {
                n2 = n3 - 1;
                this.sKey[n3][0] = this.sKey[n2][0] ^ Square.rot32L(this.sKey[n2][3], 8) ^ OFFSET[n2];
                this.sKey[n3][1] = this.sKey[n2][1] ^ this.sKey[n3][0];
                this.sKey[n3][2] = this.sKey[n2][2] ^ this.sKey[n3][1];
                this.sKey[n3][3] = this.sKey[n2][3] ^ this.sKey[n3][2];
                Square.transform(this.sKey[n2], this.sKey[n2]);
                ++n3;
            }
        } else {
            int[][] nArray = new int[9][4];
            int n4 = 0;
            while (n4 < 4) {
                nArray[0][n4] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                ++n4;
            }
            n4 = 1;
            while (n4 < 9) {
                n2 = n4 - 1;
                nArray[n4][0] = nArray[n2][0] ^ Square.rot32L(nArray[n2][3], 8) ^ OFFSET[n2];
                nArray[n4][1] = nArray[n2][1] ^ nArray[n4][0];
                nArray[n4][2] = nArray[n2][2] ^ nArray[n4][1];
                nArray[n4][3] = nArray[n2][3] ^ nArray[n4][2];
                ++n4;
            }
            n4 = 0;
            while (n4 < 8) {
                System.arraycopy(nArray[8 - n4], 0, this.sKey[n4], 0, 4);
                ++n4;
            }
            Square.transform(nArray[0], this.sKey[8]);
        }
    }

    private static void transform(int[] nArray, int[] nArray2) {
        int n2 = 0;
        while (n2 < 4) {
            int n3 = nArray[n2];
            int n4 = n3 >>> 8;
            int n5 = n3 >>> 16;
            int n6 = n3 >>> 24;
            int n7 = ((Square.mul(n6, 2) ^ Square.mul(n5, 3) ^ n4 ^ n3) & 0xFF) << 24;
            n7 ^= ((n6 ^ Square.mul(n5, 2) ^ Square.mul(n4, 3) ^ n3) & 0xFF) << 16;
            n7 ^= ((n6 ^ n5 ^ Square.mul(n4, 2) ^ Square.mul(n3, 3)) & 0xFF) << 8;
            nArray2[n2] = n7 ^= (Square.mul(n6, 3) ^ n5 ^ n4 ^ Square.mul(n3, 2)) & 0xFF;
            ++n2;
        }
    }

    private static int rot32L(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int rot32R(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private static final int mul(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        n2 &= 0xFF;
        n3 &= 0xFF;
        int n4 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                n4 ^= n2;
            }
            if ((n2 <<= 1) > 255) {
                n2 ^= 0x1F5;
            }
            n3 >>>= 1;
        }
        return n4 & 0xFF;
    }

    private void square(byte[] byArray, int n2, byte[] byArray2, int n3, int[] nArray, byte[] byArray3) {
        int n4 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n6 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n7 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        n4 ^= this.sKey[0][0];
        n5 ^= this.sKey[0][1];
        n6 ^= this.sKey[0][2];
        n7 ^= this.sKey[0][3];
        int n8 = 1;
        while (n8 < 8) {
            int n9 = nArray[n4 >>> 24 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 24 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 24 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 24 & 0xFF], 24) ^ this.sKey[n8][0];
            int n10 = nArray[n4 >>> 16 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 16 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 16 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 16 & 0xFF], 24) ^ this.sKey[n8][1];
            int n11 = nArray[n4 >>> 8 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 8 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 8 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 8 & 0xFF], 24) ^ this.sKey[n8][2];
            int n12 = nArray[n4 & 0xFF] ^ Square.rot32R(nArray[n5 & 0xFF], 8) ^ Square.rot32R(nArray[n6 & 0xFF], 16) ^ Square.rot32R(nArray[n7 & 0xFF], 24) ^ this.sKey[n8][3];
            n4 = n9;
            n5 = n10;
            n6 = n11;
            n7 = n12;
            ++n8;
        }
        n8 = 0;
        int n13 = 24;
        while (n8 < 4) {
            int n14 = (byArray3[n4 >>> n13 & 0xFF] & 0xFF) << 24 | (byArray3[n5 >>> n13 & 0xFF] & 0xFF) << 16 | (byArray3[n6 >>> n13 & 0xFF] & 0xFF) << 8 | byArray3[n7 >>> n13 & 0xFF] & 0xFF;
            byArray2[n3++] = (byte)((n14 ^= this.sKey[8][n8]) >>> 24 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 16 & 0xFF);
            byArray2[n3++] = (byte)(n14 >>> 8 & 0xFF);
            byArray2[n3++] = (byte)(n14 & 0xFF);
            ++n8;
            n13 -= 8;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            Square.self_test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void self_test() throws Exception {
        Cipher cipher = Cipher.getInstance("Square", "Cryptix");
        int n2 = 0;
        while (n2 < tests.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("Square", Hex.fromString(tests[n2][0]));
            byte[] byArray = Hex.fromString(tests[n2][1]);
            byte[] byArray2 = Hex.fromString(tests[n2][2]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual(byArray2, byArray3)) {
                System.out.println("     input: " + Hex.toString(byArray));
                System.out.println("  computed: " + Hex.toString(byArray3));
                System.out.println(" certified: " + Hex.toString(byArray2));
                throw new CryptixException("encrypt #" + n2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (!ArrayUtil.areEqual(byArray, byArray3)) {
                throw new CryptixException("decrypt #" + n2 + " failed");
            }
            ++n2;
        }
        if (debuglevel > 0) {
            Square.debug("Self-test OK");
        }
    }

    public Square() {
        super(false, false, "Cryptix");
        this.link();
    }

    static {
        int n2;
        debuglevel = Debug.getLevel("Square");
        err = Debug.getOutput();
        linkStatus = new NativeLink("Square", 2, 3);
        SE = new byte[256];
        SD = new byte[256];
        TE = new int[256];
        TD = new int[256];
        OFFSET = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        int n3 = 1;
        while (n3 < 256) {
            n2 = byArray[n3 - 1] << 1;
            if ((n2 & 0x100) != 0) {
                n2 ^= 0x1F5;
            }
            byArray[n3] = (byte)n2;
            byArray2[n2 & 0xFF] = (byte)n3;
            ++n3;
        }
        Square.SE[0] = 0;
        Square.SE[1] = 1;
        n3 = 2;
        while (n3 < 256) {
            Square.SE[n3] = byArray[255 - byArray2[n3] & 0xFF];
            ++n3;
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        n3 = 0;
        while (n3 < 256) {
            int n4 = 177;
            n2 = 0;
            while (n2 < 8) {
                int n5 = SE[n3] & nArray[n2] & 0xFF;
                n5 ^= n5 >>> 4;
                n5 ^= n5 >>> 2;
                n5 ^= n5 >>> 1;
                n4 ^= (n5 &= 1) << n2;
                ++n2;
            }
            Square.SE[n3] = (byte)n4;
            Square.SD[n4] = (byte)n3;
            ++n3;
        }
        Square.OFFSET[0] = 1;
        n3 = 1;
        while (n3 < 8) {
            Square.OFFSET[n3] = Square.mul(OFFSET[n3 - 1], 2);
            int n6 = n3 - 1;
            OFFSET[n6] = OFFSET[n6] << 24;
            ++n3;
        }
        OFFSET[7] = OFFSET[7] << 24;
        n3 = 0;
        while (n3 < 256) {
            int n7 = SE[n3] & 0xFF;
            int n8 = SD[n3] & 0xFF;
            Square.TE[n3] = SE[n3 & 3] == 0 ? 0 : Square.mul(n7, 2) << 24 | n7 << 16 | n7 << 8 | Square.mul(n7, 3);
            Square.TD[n3] = SD[n3 & 3] == 0 ? 0 : Square.mul(n8, 14) << 24 | Square.mul(n8, 9) << 16 | Square.mul(n8, 13) << 8 | Square.mul(n8, 11);
            ++n3;
        }
        tests = new String[][]{{"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F"}, {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F7C3491D94994E70F0EC2E7A5CCB5A14F"}};
    }
}

