/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.Security;
import xjava.security.Cipher;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.SymmetricCipher;

public final class SAFER
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("SAFER");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("SAFER", 2, 3);
    public static final int SK128_VARIANT = 0;
    public static final int SK64_VARIANT = 1;
    public static final int K128_VARIANT = 2;
    public static final int K64_VARIANT = 3;
    private static final int K64_DEFAULT_NOF_ROUNDS = 6;
    private static final int K128_DEFAULT_NOF_ROUNDS = 10;
    private static final int SK64_DEFAULT_NOF_ROUNDS = 8;
    private static final int SK128_DEFAULT_NOF_ROUNDS = 10;
    private static final int MAX_NOF_ROUNDS = 13;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 217;
    private static final int TAB_LEN = 256;
    private static final int[] EXP = new int[256];
    private static final int[] LOG = new int[256];
    private long native_cookie;
    private Object native_lock;
    private int[] sKey = new int[217];
    private int rounds = 10;
    private int variant = 0;

    private static void debug(String string) {
        err.println("SAFER: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(SAFER.getLibMajorVersion(), SAFER.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    SAFER.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                SAFER.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3, byte[] var4, int var5, boolean var6);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    SAFER.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 8;
        n3 = n5 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += 8;
                    n4 += 8;
                    ++n6;
                }
            }
        } else if (bl) {
            int n7 = 0;
            while (n7 < n5) {
                this.blockEncrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n5) {
                this.blockDecrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n8;
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("rounds")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("rounds.SAFER");
            this.setRounds((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("variant")) throw new NoSuchParameterException(string + ".SAFER");
            if (!(object instanceof String)) throw new InvalidParameterTypeException("variant.SAFER");
            this.setVariant((String)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("rounds")) {
            return new Integer(this.rounds);
        }
        if (string.equalsIgnoreCase("variant")) {
            return this.getVariant();
        }
        throw new NoSuchParameterException(string + ".SAFER");
    }

    public void setRounds(int n2) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Cipher not in UNINITIALIZED state");
        }
        if (n2 <= 0 || n2 > 13) {
            throw new InvalidParameterException();
        }
        this.rounds = n2;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void setVariant(String string) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Cipher not in UNINITIALIZED state");
        }
        if (string.equalsIgnoreCase("SK128") || string.equalsIgnoreCase("SK-128")) {
            this.variant = 0;
        } else if (string.equalsIgnoreCase("SK64") || string.equalsIgnoreCase("SK-64")) {
            this.variant = 1;
        } else if (string.equalsIgnoreCase("K128") || string.equalsIgnoreCase("K-128")) {
            this.variant = 2;
        } else if (string.equalsIgnoreCase("K64") || string.equalsIgnoreCase("K-64")) {
            this.variant = 3;
        } else {
            throw new InvalidParameterException();
        }
    }

    public String getVariant() {
        switch (this.variant) {
            case 0: {
                return "SK-128";
            }
            case 1: {
                return "SK-64";
            }
            case 2: {
                return "K-128";
            }
            case 3: {
                return "K-64";
            }
        }
        throw new InternalError("variant = " + this.variant);
    }

    private void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = 0;
        if (13 < (n4 = this.sKey[n5++])) {
            n4 = 13;
        }
        int n6 = byArray[n2++];
        int n7 = byArray[n2++];
        int n8 = byArray[n2++];
        int n9 = byArray[n2++];
        int n10 = byArray[n2++];
        int n11 = byArray[n2++];
        int n12 = byArray[n2++];
        int n13 = byArray[n2++];
        int n14 = 0;
        while (n14 < n4) {
            n6 ^= this.sKey[n5++];
            n7 += this.sKey[n5++];
            n8 += this.sKey[n5++];
            n9 ^= this.sKey[n5++];
            n10 ^= this.sKey[n5++];
            n11 += this.sKey[n5++];
            n12 += this.sKey[n5++];
            n13 ^= this.sKey[n5++];
            n6 = EXP[n6 & 0xFF] + this.sKey[n5++];
            n7 = LOG[n7 & 0xFF] ^ this.sKey[n5++];
            n8 = LOG[n8 & 0xFF] ^ this.sKey[n5++];
            n9 = EXP[n9 & 0xFF] + this.sKey[n5++];
            n10 = EXP[n10 & 0xFF] + this.sKey[n5++];
            n11 = LOG[n11 & 0xFF] ^ this.sKey[n5++];
            n12 = LOG[n12 & 0xFF] ^ this.sKey[n5++];
            n13 = EXP[n13 & 0xFF] + this.sKey[n5++];
            n7 += n6;
            n6 += n7;
            n9 += n8;
            n8 += n9;
            n11 += n10;
            n13 += n12;
            n12 += n13;
            n8 += n6;
            n6 += n8;
            n12 += (n10 += n11);
            n10 += n12;
            n9 += n7;
            n13 += n11;
            n11 += n13;
            n10 += n6;
            n6 += n10;
            n11 += (n7 += n9);
            n12 += n8;
            n13 += n9;
            int n15 = n7 += n11;
            n7 = n10;
            n10 = n8 += n12;
            n8 = n15;
            n15 = n9 += n13;
            n9 = n11;
            n11 = n12;
            n12 = n15;
            ++n14;
        }
        byArray2[n3++] = (byte)(n6 ^ this.sKey[n5++]);
        byArray2[n3++] = (byte)(n7 + this.sKey[n5++]);
        byArray2[n3++] = (byte)(n8 + this.sKey[n5++]);
        byArray2[n3++] = (byte)(n9 ^ this.sKey[n5++]);
        byArray2[n3++] = (byte)(n10 ^ this.sKey[n5++]);
        byArray2[n3++] = (byte)(n11 + this.sKey[n5++]);
        byArray2[n3++] = (byte)(n12 + this.sKey[n5++]);
        byArray2[n3++] = (byte)(n13 ^ this.sKey[n5++]);
    }

    private void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.sKey[0];
        if (13 < n4) {
            n4 = 13;
        }
        int n5 = byArray[n2++];
        int n6 = byArray[n2++];
        int n7 = byArray[n2++];
        int n8 = byArray[n2++];
        int n9 = byArray[n2++];
        int n10 = byArray[n2++];
        int n11 = byArray[n2++];
        int n12 = byArray[n2++];
        int n13 = 8 * (1 + 2 * n4);
        n12 ^= this.sKey[n13];
        n11 -= this.sKey[--n13];
        n10 -= this.sKey[--n13];
        n9 ^= this.sKey[--n13];
        n8 ^= this.sKey[--n13];
        n7 -= this.sKey[--n13];
        n6 -= this.sKey[--n13];
        n5 ^= this.sKey[--n13];
        int n14 = 0;
        while (n14 < n4) {
            int n15 = n9;
            n9 = n6;
            n6 = n7;
            n7 = n15;
            n15 = n10;
            n10 = n8;
            n8 = n11;
            n11 = n15;
            n5 -= n9;
            n9 -= n5;
            n6 -= n10;
            n10 -= n6;
            n7 -= n11;
            n11 -= n7;
            n8 -= n12;
            n12 -= n8;
            n5 -= n7;
            n7 -= n5;
            n9 -= n11;
            n11 -= n9;
            n6 -= n8;
            n8 -= n6;
            n10 -= n12;
            n12 -= n10;
            n5 -= n6;
            n6 -= n5;
            n7 -= n8;
            n8 -= n7;
            n9 -= n10;
            n10 -= n9;
            n11 -= n12;
            n12 -= n11;
            n12 -= this.sKey[--n13];
            n11 ^= this.sKey[--n13];
            n10 ^= this.sKey[--n13];
            n9 -= this.sKey[--n13];
            n8 -= this.sKey[--n13];
            n7 ^= this.sKey[--n13];
            n6 ^= this.sKey[--n13];
            n5 -= this.sKey[--n13];
            n12 = LOG[n12 & 0xFF] ^ this.sKey[--n13];
            n11 = EXP[n11 & 0xFF] - this.sKey[--n13];
            n10 = EXP[n10 & 0xFF] - this.sKey[--n13];
            n9 = LOG[n9 & 0xFF] ^ this.sKey[--n13];
            n8 = LOG[n8 & 0xFF] ^ this.sKey[--n13];
            n7 = EXP[n7 & 0xFF] - this.sKey[--n13];
            n6 = EXP[n6 & 0xFF] - this.sKey[--n13];
            n5 = LOG[n5 & 0xFF] ^ this.sKey[--n13];
            ++n14;
        }
        byArray2[n3++] = (byte)n5;
        byArray2[n3++] = (byte)n6;
        byArray2[n3++] = (byte)n7;
        byArray2[n3++] = (byte)n8;
        byArray2[n3++] = (byte)n9;
        byArray2[n3++] = (byte)n10;
        byArray2[n3++] = (byte)n11;
        byArray2[n3++] = (byte)n12;
    }

    private synchronized void makeKey(Key key) throws KeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Invalid SAFER key");
        }
        byte[] byArray2 = new byte[16];
        int n2 = byArray.length;
        int n3 = 16;
        int n4 = 0;
        while (n3 >= n2) {
            System.arraycopy(byArray, 0, byArray2, n4, n2);
            n3 -= n2;
            n4 += n2;
        }
        System.arraycopy(byArray, 0, byArray2, n4, n3);
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray2, 8, byArray4, 0, 8);
        this.Safer_Expand_Userkey(byArray3, byArray4);
    }

    private void Safer_Expand_Userkey(byte[] byArray, byte[] byArray2) {
        Object object;
        if (this.native_lock != null) {
            object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray, byArray2, this.rounds, this.isStrong()));
                    Object var4_4 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        SAFER.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        object = new byte[9];
        byte[] byArray3 = new byte[9];
        int n2 = 0;
        this.sKey[n2++] = (byte)this.rounds;
        int n3 = 0;
        while (n3 < 8) {
            object[n3] = (byte)(byArray[n3] << 5 | (byArray[n3] & 0xFF) >>> 3);
            Object object2 = object;
            object2[8] = (byte)(object2[8] ^ object[n3]);
            this.sKey[n2++] = byArray2[n3];
            byArray3[n3] = byArray2[n3];
            byArray3[8] = (byte)(byArray3[8] ^ byArray3[n3]);
            ++n3;
        }
        n3 = 1;
        while (n3 <= this.rounds) {
            int n4 = 0;
            while (n4 < 9) {
                object[n4] = (byte)(object[n4] << 6 | (object[n4] & 0xFF) >>> 2);
                byArray3[n4] = (byte)(byArray3[n4] << 6 | (byArray3[n4] & 0xFF) >>> 2);
                ++n4;
            }
            n4 = 0;
            while (n4 < 8) {
                this.sKey[n2++] = this.isStrong() ? object[(n4 + 2 * n3 - 1) % 9] + EXP[EXP[18 * n3 + n4 + 1]] & 0xFF : object[n4] + EXP[EXP[18 * n3 + n4 + 1]] & 0xFF;
                ++n4;
            }
            n4 = 0;
            while (n4 < 8) {
                this.sKey[n2++] = this.isStrong() ? byArray3[(n4 + 2 * n3) % 9] + EXP[EXP[18 * n3 + n4 + 10]] & 0xFF : byArray3[n4] + EXP[EXP[18 * n3 + n4 + 10]] & 0xFF;
                ++n4;
            }
            ++n3;
        }
    }

    private boolean isStrong() {
        return this.variant < 2;
    }

    public SAFER() {
        super(false, false, "Cryptix");
        String string;
        try {
            string = Security.getAlgorithmProperty("SAFER", "variant");
            if (string != null) {
                this.setVariant(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (this.variant) {
            case 0: {
                this.rounds = 10;
                break;
            }
            case 1: {
                this.rounds = 8;
                break;
            }
            case 2: {
                this.rounds = 10;
                break;
            }
            case 3: {
                this.rounds = 6;
                break;
            }
        }
        try {
            string = Security.getAlgorithmProperty("SAFER", "rounds");
            if (string != null) {
                this.setRounds(Integer.parseInt(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.link();
    }

    static {
        int n2 = 1;
        int n3 = 0;
        while (n3 < 256) {
            SAFER.EXP[n3] = n2 & 0xFF;
            SAFER.LOG[SAFER.EXP[n3]] = n3;
            n2 = n2 * 45 % 257;
            ++n3;
        }
    }
}

