/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class Rijndael
extends Cipher
implements SymmetricCipher {
    private static final int BLOCK_SIZE = 16;
    private static final String SS = "\u637c\u777b\uf26b\u6fc5\u3001\u672b\ufed7\uab76\uca82\uc97d\ufa59\u47f0\uadd4\ua2af\u9ca4\u72c0\ub7fd\u9326\u363f\uf7cc\u34a5\ue5f1\u71d8\u3115\u04c7\u23c3\u1896\u059a\u0712\u80e2\ueb27\ub275\u0983\u2c1a\u1b6e\u5aa0\u523b\ud6b3\u29e3\u2f84\u53d1\u00ed\u20fc\ub15b\u6acb\ube39\u4a4c\u58cf\ud0ef\uaafb\u434d\u3385\u45f9\u027f\u503c\u9fa8\u51a3\u408f\u929d\u38f5\ubcb6\uda21\u10ff\uf3d2\ucd0c\u13ec\u5f97\u4417\uc4a7\u7e3d\u645d\u1973\u6081\u4fdc\u222a\u9088\u46ee\ub814\ude5e\u0bdb\ue032\u3a0a\u4906\u245c\uc2d3\uac62\u9195\ue479\ue7c8\u376d\u8dd5\u4ea9\u6c56\uf4ea\u657a\uae08\uba78\u252e\u1ca6\ub4c6\ue8dd\u741f\u4bbd\u8b8a\u703e\ub566\u4803\uf60e\u6135\u57b9\u86c1\u1d9e\ue1f8\u9811\u69d9\u8e94\u9b1e\u87e9\uce55\u28df\u8ca1\u890d\ubfe6\u4268\u4199\u2d0f\ub054\ubb16";
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] rcon;
    private boolean ROUNDS_12;
    private boolean ROUNDS_14;
    private boolean decrypt;
    private int[] K;
    private int limit;

    protected void coreInit(Key key, boolean bl) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        int n2 = byArray.length;
        if (n2 != 16 && n2 != 24 && n2 != 32) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.decrypt = bl;
        this.K = Rijndael.makeKey(byArray, bl);
        if (bl) {
            Rijndael.invertKey(this.K);
        }
        this.ROUNDS_12 = n2 >= 24;
        this.ROUNDS_14 = n2 == 32;
        this.limit = Rijndael.getRounds(n2) * 4;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.coreInit(key, false);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.coreInit(key, true);
    }

    /*
     * Unable to fully structure code
     */
    protected int engineUpdate(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5) {
        block2: {
            var6_6 = var3_3;
            if (!this.decrypt) ** GOTO lbl14
            while (var3_3 > 0) {
                this.blockDecrypt(var1_1, var2_2, var4_4, var5_5);
                var2_2 += 16;
                var5_5 += 16;
                var3_3 -= 16;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                this.blockEncrypt(var1_1, var2_2, var4_4, var5_5);
                var2_2 += 16;
                var5_5 += 16;
                var3_3 -= 16;
lbl14:
                // 2 sources

                ** while (var3_3 > 0)
            }
        }
        return var6_6;
    }

    protected int engineBlockSize() {
        return 16;
    }

    private void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[n5++];
        int n7 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[n5++];
        int n8 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[n5++];
        int n9 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[n5++];
        while (n5 < this.limit) {
            n4 = T1[n6 >>> 24] ^ T2[n7 >>> 16 & 0xFF] ^ T3[n8 >>> 8 & 0xFF] ^ T4[n9 & 0xFF] ^ this.K[n5++];
            int n10 = T1[n7 >>> 24] ^ T2[n8 >>> 16 & 0xFF] ^ T3[n9 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ this.K[n5++];
            int n11 = T1[n8 >>> 24] ^ T2[n9 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n7 & 0xFF] ^ this.K[n5++];
            n9 = T1[n9 >>> 24] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n7 >>> 8 & 0xFF] ^ T4[n8 & 0xFF] ^ this.K[n5++];
            n6 = n4;
            n7 = n10;
            n8 = n11;
        }
        n4 = this.K[n5++];
        byArray2[n3++] = (byte)(S[n6 >>> 24] ^ n4 >>> 24);
        byArray2[n3++] = (byte)(S[n7 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3++] = (byte)(S[n8 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3++] = (byte)(S[n9 & 0xFF] ^ n4);
        n4 = this.K[n5++];
        byArray2[n3++] = (byte)(S[n7 >>> 24] ^ n4 >>> 24);
        byArray2[n3++] = (byte)(S[n8 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3++] = (byte)(S[n9 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3++] = (byte)(S[n6 & 0xFF] ^ n4);
        n4 = this.K[n5++];
        byArray2[n3++] = (byte)(S[n8 >>> 24] ^ n4 >>> 24);
        byArray2[n3++] = (byte)(S[n9 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3++] = (byte)(S[n6 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3++] = (byte)(S[n7 & 0xFF] ^ n4);
        n4 = this.K[n5++];
        byArray2[n3++] = (byte)(S[n9 >>> 24] ^ n4 >>> 24);
        byArray2[n3++] = (byte)(S[n6 >>> 16 & 0xFF] ^ n4 >>> 16);
        byArray2[n3++] = (byte)(S[n7 >>> 8 & 0xFF] ^ n4 >>> 8);
        byArray2[n3] = (byte)(S[n8 & 0xFF] ^ n4);
    }

    private void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = 8;
        int n8 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[4];
        int n9 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[5];
        int n10 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) ^ this.K[6];
        int n11 = (byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF) ^ this.K[7];
        if (this.ROUNDS_12) {
            n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
            n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
            n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
            n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
            n8 = T5[n6 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n7++];
            n9 = T5[n5 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n7++];
            n10 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
            n11 = T5[n11 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ this.K[n7++];
            if (this.ROUNDS_14) {
                n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
                n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
                n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
                n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
                n8 = T5[n6 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n7++];
                n9 = T5[n5 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n7++];
                n10 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
                n11 = T5[n11 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ this.K[n7++];
            }
        }
        n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
        n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
        n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
        n8 = T5[n6 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n7++];
        n9 = T5[n5 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n7++];
        n10 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ this.K[n7++];
        n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
        n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
        n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
        n8 = T5[n6 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n7++];
        n9 = T5[n5 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n7++];
        n10 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ this.K[n7++];
        n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
        n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
        n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
        n8 = T5[n6 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n7++];
        n9 = T5[n5 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n7++];
        n10 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ this.K[n7++];
        n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
        n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
        n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
        n8 = T5[n6 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ this.K[n7++];
        n9 = T5[n5 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ this.K[n7++];
        n10 = T5[n4 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ this.K[n7++];
        n6 = T5[n8 >>> 24] ^ T6[n11 >>> 16 & 0xFF] ^ T7[n10 >>> 8 & 0xFF] ^ T8[n9 & 0xFF] ^ this.K[n7++];
        n5 = T5[n9 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n11 >>> 8 & 0xFF] ^ T8[n10 & 0xFF] ^ this.K[n7++];
        n4 = T5[n10 >>> 24] ^ T6[n9 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n11 & 0xFF] ^ this.K[n7++];
        n11 = T5[n11 >>> 24] ^ T6[n10 >>> 16 & 0xFF] ^ T7[n9 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ this.K[n7++];
        n9 = this.K[0];
        byArray2[n3++] = (byte)(Si[n6 >>> 24] ^ n9 >>> 24);
        byArray2[n3++] = (byte)(Si[n11 >>> 16 & 0xFF] ^ n9 >>> 16);
        byArray2[n3++] = (byte)(Si[n4 >>> 8 & 0xFF] ^ n9 >>> 8);
        byArray2[n3++] = (byte)(Si[n5 & 0xFF] ^ n9);
        n9 = this.K[1];
        byArray2[n3++] = (byte)(Si[n5 >>> 24] ^ n9 >>> 24);
        byArray2[n3++] = (byte)(Si[n6 >>> 16 & 0xFF] ^ n9 >>> 16);
        byArray2[n3++] = (byte)(Si[n11 >>> 8 & 0xFF] ^ n9 >>> 8);
        byArray2[n3++] = (byte)(Si[n4 & 0xFF] ^ n9);
        n9 = this.K[2];
        byArray2[n3++] = (byte)(Si[n4 >>> 24] ^ n9 >>> 24);
        byArray2[n3++] = (byte)(Si[n5 >>> 16 & 0xFF] ^ n9 >>> 16);
        byArray2[n3++] = (byte)(Si[n6 >>> 8 & 0xFF] ^ n9 >>> 8);
        byArray2[n3++] = (byte)(Si[n11 & 0xFF] ^ n9);
        n9 = this.K[3];
        byArray2[n3++] = (byte)(Si[n11 >>> 24] ^ n9 >>> 24);
        byArray2[n3++] = (byte)(Si[n4 >>> 16 & 0xFF] ^ n9 >>> 16);
        byArray2[n3++] = (byte)(Si[n5 >>> 8 & 0xFF] ^ n9 >>> 8);
        byArray2[n3] = (byte)(Si[n6 & 0xFF] ^ n9);
    }

    private static int[] makeKey(byte[] byArray, boolean bl) throws InvalidKeyException {
        int n2 = Rijndael.getRounds(byArray.length);
        int n3 = (n2 + 1) * 4;
        int[] nArray = new int[n3];
        int n4 = byArray.length / 4;
        int[] nArray2 = new int[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            nArray2[n5++] = byArray[n6++] << 24 | (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
        }
        int n7 = 0;
        while (n7 < n4) {
            nArray[n7] = nArray2[n7];
            ++n7;
        }
        int n8 = 0;
        while (n7 < n3) {
            int n9 = nArray2[n4 - 1];
            nArray2[0] = nArray2[0] ^ (S[n9 >>> 16 & 0xFF] << 24 ^ (S[n9 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n9 & 0xFF] & 0xFF) << 8 ^ S[n9 >>> 24] & 0xFF ^ rcon[n8++] << 24);
            if (n4 != 8) {
                n5 = 1;
                n6 = 0;
                while (n5 < n4) {
                    int n10 = n5++;
                    nArray2[n10] = nArray2[n10] ^ nArray2[n6++];
                }
            } else {
                n5 = 1;
                n6 = 0;
                while (n5 < n4 / 2) {
                    int n11 = n5++;
                    nArray2[n11] = nArray2[n11] ^ nArray2[n6++];
                }
                n9 = nArray2[n4 / 2 - 1];
                int n12 = n4 / 2;
                nArray2[n12] = nArray2[n12] ^ (S[n9 & 0xFF] & 0xFF ^ (S[n9 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n9 >>> 16 & 0xFF] & 0xFF) << 16 ^ S[n9 >>> 24] << 24);
                n6 = n4 / 2;
                n5 = n6 + 1;
                while (n5 < n4) {
                    int n13 = n5++;
                    nArray2[n13] = nArray2[n13] ^ nArray2[n6++];
                }
            }
            n6 = 0;
            while (n6 < n4 && n7 < n3) {
                nArray[n7] = nArray2[n6];
                ++n6;
                ++n7;
            }
        }
        return nArray;
    }

    private static void invertKey(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        while (n6 < nArray.length / 2 - 4) {
            n5 = nArray[n6];
            n4 = nArray[n6 + 1];
            n3 = nArray[n6 + 2];
            n2 = nArray[n6 + 3];
            nArray[n6] = nArray[nArray.length - n6 - 4];
            nArray[n6 + 1] = nArray[nArray.length - n6 - 4 + 1];
            nArray[n6 + 2] = nArray[nArray.length - n6 - 4 + 2];
            nArray[n6 + 3] = nArray[nArray.length - n6 - 4 + 3];
            nArray[nArray.length - n6 - 4] = n5;
            nArray[nArray.length - n6 - 4 + 1] = n4;
            nArray[nArray.length - n6 - 4 + 2] = n3;
            nArray[nArray.length - n6 - 4 + 3] = n2;
            n6 += 4;
        }
        n6 = 4;
        while (n6 < nArray.length - 4) {
            n5 = nArray[n6];
            nArray[n6] = U1[n5 >>> 24 & 0xFF] ^ U2[n5 >>> 16 & 0xFF] ^ U3[n5 >>> 8 & 0xFF] ^ U4[n5 & 0xFF];
            ++n6;
        }
        n6 = nArray[nArray.length - 4];
        n5 = nArray[nArray.length - 3];
        n4 = nArray[nArray.length - 2];
        n3 = nArray[nArray.length - 1];
        n2 = nArray.length - 1;
        while (n2 > 3) {
            nArray[n2] = nArray[n2 - 4];
            --n2;
        }
        nArray[0] = n6;
        nArray[1] = n5;
        nArray[2] = n4;
        nArray[3] = n3;
    }

    private static int getRounds(int n2) {
        return (n2 >> 2) + 6;
    }

    public Rijndael() {
        super(false, false, "Cryptix");
    }

    static {
        int n2;
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        int n3 = 283;
        boolean bl = false;
        int n4 = 0;
        while (n4 < 256) {
            int n5;
            int n6;
            int n7;
            char c2 = SS.charAt(n4 >>> 1);
            Rijndael.S[n4] = (byte)((n4 & 1) == 0 ? c2 >>> 8 : c2 & 0xFF);
            n2 = S[n4] & 0xFF;
            Rijndael.Si[n2] = (byte)n4;
            int n8 = n2 << 1;
            if (n8 >= 256) {
                n8 ^= n3;
            }
            int n9 = n8 ^ n2;
            int n10 = n4 << 1;
            if (n10 >= 256) {
                n10 ^= n3;
            }
            if ((n7 = n10 << 1) >= 256) {
                n7 ^= n3;
            }
            if ((n6 = n7 << 1) >= 256) {
                n6 ^= n3;
            }
            int n11 = n6 ^ n4;
            int n12 = n11 ^ n10;
            int n13 = n11 ^ n7;
            int n14 = n6 ^ n7 ^ n10;
            Rijndael.T1[n4] = n5 = n8 << 24 | n2 << 16 | n2 << 8 | n9;
            Rijndael.T2[n4] = n5 >>> 8 | n5 << 24;
            Rijndael.T3[n4] = n5 >>> 16 | n5 << 16;
            Rijndael.T4[n4] = n5 >>> 24 | n5 << 8;
            Rijndael.U1[n4] = n5 = n14 << 24 | n11 << 16 | n13 << 8 | n12;
            Rijndael.T5[n2] = n5;
            Rijndael.T6[n2] = Rijndael.U2[n4] = n5 >>> 8 | n5 << 24;
            Rijndael.T7[n2] = Rijndael.U3[n4] = n5 >>> 16 | n5 << 16;
            Rijndael.T8[n2] = Rijndael.U4[n4] = n5 >>> 24 | n5 << 8;
            ++n4;
        }
        n2 = 1;
        Rijndael.rcon[0] = 1;
        n4 = 1;
        while (n4 < 30) {
            if ((n2 <<= 1) >= 256) {
                n2 ^= n3;
            }
            Rijndael.rcon[n4] = (byte)n2;
            ++n4;
        }
    }
}

