/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpException;
import com.ireasoning.protocol.snmp.SnmpInt;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpTimeTicks;
import com.ireasoning.protocol.snmp.SnmpUInt;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.xb;
import java.net.InetAddress;

public abstract class SnmpV2Notification
extends SnmpPdu {
    public static final SnmpOID SYS_UP_TIME_OID = new SnmpOID(".1.3.6.1.2.1.1.3.0");
    public static final SnmpOID SNMP_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.4.1.0");
    public static final SnmpOID SNMP_TRAP_ENTERPRISE_OID = new SnmpOID(".1.3.6.1.6.3.1.1.4.3.0");
    public static final SnmpOID COLD_START_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.1");
    public static final SnmpOID WARM_START_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.2");
    public static final SnmpOID LINK_DOWN_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.3");
    public static final SnmpOID LINK_UP_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.4");
    public static final SnmpOID AUTHENTICATION_FAILURE_TRAP_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.5");
    public static final SnmpOID EGPNEIGHBOR_LOSS_OID = new SnmpOID(".1.3.6.1.6.3.1.1.5.6");

    SnmpV2Notification() {
    }

    public SnmpV2Notification(long l2, SnmpOID snmpOID, SnmpVarBind[] snmpVarBindArray) {
        this();
        this.removeAllVarBinds();
        SnmpTimeTicks snmpTimeTicks = new SnmpTimeTicks(l2);
        SnmpVarBind snmpVarBind = new SnmpVarBind(SYS_UP_TIME_OID, (SnmpDataType)snmpTimeTicks);
        this.addVarBind(snmpVarBind);
        snmpVarBind = new SnmpVarBind(SNMP_TRAP_OID, (SnmpDataType)snmpOID);
        this.addVarBind(snmpVarBind);
        this.addVarBinds(snmpVarBindArray);
    }

    public SnmpV2Notification(long l2, SnmpOID snmpOID) {
        this(l2, snmpOID, null);
    }

    public SnmpV2Notification(SnmpV2Notification snmpV2Notification) {
        super(snmpV2Notification);
    }

    public long getSysUpTime() {
        SnmpVarBind snmpVarBind = this.a.get(0);
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        int n2 = snmpDataType.getType();
        if (n2 == 67 || n2 == 66) {
            SnmpUInt snmpUInt = (SnmpUInt)snmpDataType;
            return snmpUInt.getValue();
        }
        if (n2 == 2) {
            SnmpInt snmpInt = (SnmpInt)snmpDataType;
            return snmpInt.getValue();
        }
        throw new SnmpException("Unknown sysUpTime object");
    }

    public void setSysUpTime(long l2) {
        SnmpVarBind snmpVarBind = this.a.get(0);
        snmpVarBind.setValue(new SnmpTimeTicks(l2));
    }

    public String getSysUpTimeString() {
        long l2 = this.getSysUpTime();
        return SnmpTimeTicks.getTimeString(l2);
    }

    public SnmpOID getSnmpTrapOID() {
        if (this.a.size() > 1) {
            SnmpVarBind snmpVarBind = this.a.get(1);
            return (SnmpOID)snmpVarBind.getValue();
        }
        return null;
    }

    public SnmpVarBind[] getObjects() {
        int n2 = this.a.size() - 2;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            snmpVarBindArray[i2] = this.a.get(i2 + 2);
        }
        return snmpVarBindArray;
    }

    public String getIpAddress() {
        return this.g;
    }

    public void setIpAddress(String string) {
        this.g = string;
    }

    public void setIpAddress(InetAddress inetAddress) {
        this.g = inetAddress.getHostAddress();
    }

    public String toString() {
        String string = "";
        string = string + "Community:\t\t" + xb.convertNull(this.d) + "\r\n";
        string = string + "sysUpTime.0:\t\t" + this.getSysUpTimeString() + "\r\n";
        string = string + "snmpTrapOID.0:\t\t" + this.getSnmpTrapOID() + "\r\n";
        if (this.getVarBindCount() > 2) {
            SnmpVarBind[] snmpVarBindArray = this.getObjects();
            for (int i2 = 0; i2 < snmpVarBindArray.length; ++i2) {
                string = string + snmpVarBindArray[i2].toString() + "\r\n";
            }
        }
        return string;
    }
}

