/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpDecodingException;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpIpAddress;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpTrap;
import com.ireasoning.protocol.snmp.SnmpV2Notification;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.VarBindContainer;
import com.ireasoning.protocol.snmp.f;
import com.ireasoning.protocol.snmp.g;
import com.ireasoning.util.Logger;
import com.ireasoning.util.dc;
import com.ireasoning.util.s;
import com.ireasoning.util.xb;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpV1Trap
extends VarBindContainer
implements SnmpDataType {
    SnmpOID b;
    SnmpIpAddress c;
    InetAddress d;
    int e = 0;
    int f = 0;
    long g = 0L;
    String h;
    static s i = new s();
    public static final int COLD_START_TRAP = 0;
    public static final int WARM_START_TRAP = 1;
    public static final int LINK_DOWN_TRAP = 2;
    public static final int LINK_UP_TRAP = 3;
    public static final int AUTHENTICATION_FAILURE_TRAP = 4;
    public static final int EGPNEIGHBOR_LOSS_TRAP = 5;
    private static final String[] j;
    static final SnmpOID k;
    static final SnmpOID l;
    static final SnmpOID[] m;

    SnmpV1Trap() {
        try {
            this.c = new SnmpIpAddress(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            Logger.error(unknownHostException);
            this.c = new SnmpIpAddress("0.0.0.0");
        }
    }

    public SnmpV1Trap(SnmpOID snmpOID) {
        this();
        this.b = new SnmpOID(snmpOID);
    }

    public SnmpV1Trap(String string) {
        this(new SnmpOID(string));
    }

    public SnmpV1Trap(SnmpV1Trap snmpV1Trap) {
        super(snmpV1Trap);
        this.b = snmpV1Trap.b;
        this.c = snmpV1Trap.c;
        this.e = snmpV1Trap.e;
        this.f = snmpV1Trap.f;
        this.g = snmpV1Trap.g;
        this.h = xb.cloneString(snmpV1Trap.h);
    }

    public static SnmpV1Trap decodeV1Trap(byte[] byArray, int n2) throws SnmpDecodingException {
        f f2 = new f(byArray, n2);
        SnmpV1Trap snmpV1Trap = (SnmpV1Trap)f2.a(false);
        return snmpV1Trap;
    }

    public static byte[] encodeV1Trap(SnmpV1Trap snmpV1Trap) throws SnmpEncodingException {
        g g2 = new g();
        g2.a(snmpV1Trap, snmpV1Trap.getCommunity());
        byte[] byArray = g2.a();
        int n2 = g2.b();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public SnmpOID getEnterprise() {
        return this.b;
    }

    public void setEnterprise(SnmpOID snmpOID) {
        this.b = new SnmpOID(snmpOID);
    }

    public void setEnterprise(String string) {
        this.b = new SnmpOID(string);
    }

    public SnmpIpAddress getIpAddress() {
        return this.c;
    }

    public InetAddress getTrapSenderIpAddress() {
        return this.d;
    }

    public void setTrapSenderIpAddress(InetAddress inetAddress) {
        this.d = inetAddress;
    }

    public void setIpAddress(SnmpIpAddress snmpIpAddress) {
        this.c = snmpIpAddress;
    }

    public void setIpAddress(String string) {
        this.c = new SnmpIpAddress(string);
    }

    public void setIpAddress(InetAddress inetAddress) {
        this.c = new SnmpIpAddress(inetAddress.getHostAddress());
    }

    public int getGeneric() {
        return this.e;
    }

    public String getGenericString() {
        if (this.e < 0 || this.e >= j.length) {
            return null;
        }
        return j[this.e];
    }

    public void setGeneric(int n2) {
        this.e = n2;
        if (this.e < 6) {
            this.f = 0;
        }
    }

    public int getSpecific() {
        return this.f;
    }

    public void setSpecific(int n2) {
        this.f = n2;
        if (n2 > 0) {
            this.e = 6;
        }
    }

    public long getTimestamp() {
        return this.g;
    }

    public void setTimestamp(long l2) {
        this.g = l2;
    }

    public String getTimestampString() {
        return "" + new dc(this.g * 10L);
    }

    public String getCommunity() {
        return this.h;
    }

    public void setCommunity(String string) {
        this.h = string;
    }

    public SnmpVarBind[] getVariables() {
        return this.getVarBinds();
    }

    public int getType() {
        return -92;
    }

    public String getTypeString() {
        return "V1Trap";
    }

    public SnmpTrap toV2Trap() {
        return this.toV2Trap(false);
    }

    public SnmpTrap toV2Trap(boolean bl) {
        Object object;
        long l2 = this.g;
        SnmpOID snmpOID = null;
        if (this.e == 6) {
            snmpOID = new SnmpOID(this.b);
            object = new long[]{0L, this.f};
            snmpOID.append((long[])object);
        } else {
            snmpOID = new SnmpOID((SnmpOID)i.get(this.e));
        }
        object = new SnmpTrap(l2, snmpOID, this.a.toArray());
        if (bl) {
            SnmpDataType snmpDataType;
            int n2;
            boolean[] blArray = new boolean[3];
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                snmpDataType = this.a.get(n2);
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (!snmpDataType.getName().equals(m[i2])) continue;
                    blArray[i2] = true;
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (blArray[n2]) continue;
                snmpDataType = null;
                if (n2 == 0) {
                    snmpDataType = this.c;
                } else if (n2 == 1) {
                    snmpDataType = new SnmpOctetString(this.h);
                } else if (n2 == 2) {
                    snmpDataType = this.b;
                }
                SnmpVarBind snmpVarBind = new SnmpVarBind(new SnmpOID(m[n2]), snmpDataType);
                object.addVarBind(snmpVarBind);
            }
        }
        object.setIpAddress(this.c.toString());
        return object;
    }

    public SnmpDataType copy() {
        return new SnmpV1Trap(this);
    }

    public int encode(g g2) throws SnmpEncodingException {
        return g2.a(this);
    }

    public String toString() {
        String string = "";
        string = string + "Community:\t\t" + xb.convertNull(this.h) + "\r\n";
        string = string + "Enterprise OID:\t\t" + this.getEnterprise() + "\r\n";
        string = string + "Ip Address:\t\t" + this.getIpAddress() + "\r\n";
        string = string + "Generic:\t\t" + this.getGenericString() + "\r\n";
        string = string + "Specific:\t\t" + this.getSpecific() + "\r\n";
        string = string + "TimeStamp:\t\t" + this.getTimestampString() + "\r\n";
        int n2 = this.getVarBindCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = this.getVarBind(i2);
            string = string + snmpVarBind.toString() + "\r\n";
        }
        return string;
    }

    static {
        i.put(0, SnmpV2Notification.COLD_START_TRAP_OID);
        i.put(1, SnmpV2Notification.WARM_START_TRAP_OID);
        i.put(2, SnmpV2Notification.LINK_DOWN_TRAP_OID);
        i.put(3, SnmpV2Notification.LINK_UP_TRAP_OID);
        i.put(4, SnmpV2Notification.AUTHENTICATION_FAILURE_TRAP_OID);
        i.put(5, SnmpV2Notification.EGPNEIGHBOR_LOSS_OID);
        j = new String[]{"coldStart", "warmStart", "linkDown", "linkUp", "authenticationFailure", "egpNeighborLoss", "enterpriseSpecific"};
        k = new SnmpOID(".1.3.6.1.6.3.18.1.3.0");
        l = new SnmpOID(".1.3.6.1.6.3.18.1.4.0");
        m = new SnmpOID[]{k, l, SnmpTrap.SNMP_TRAP_ENTERPRISE_OID};
    }
}

