/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.g;
import com.ireasoning.util.ec;
import com.ireasoning.util.o;

public class SnmpBits
extends SnmpOctetString {
    protected int _radix = 16;
    int c = -1;
    static final byte[][] d = new byte[][]{{0, 0, 0, 0}, {0, 0, 0, 1}, {0, 0, 1, 0}, {0, 0, 1, 1}, {0, 1, 0, 0}, {0, 1, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 1}, {1, 0, 0, 0}, {1, 0, 0, 1}, {1, 0, 1, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}, {1, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 1}};
    private long[] e = new long[SnmpBits.a(63) + 1];
    private transient int f = 0;

    public SnmpBits() {
    }

    public SnmpBits(int n2) {
        this._radix = n2;
        if (n2 != 2 && n2 != 16) {
            throw new IllegalArgumentException("Unknown radix");
        }
    }

    public SnmpBits(SnmpBits snmpBits) {
        this.or(snmpBits);
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "BITS";
    }

    public byte[] getValue() {
        int n2 = this.b();
        if (n2 % 8 != 0) {
            int n3 = n2 / 8;
            n2 = 8 * (n3 + 1);
        }
        byte[] byArray = null;
        if (this._radix == 2) {
            byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = i2 < this.b() ? (this.get(i2) ? (byte)1 : 0) : (byte)0;
            }
        } else {
            int n4 = n2 / 8;
            byArray = new byte[n4];
            int n5 = 0;
            char[] cArray = new char[8];
            for (int i3 = 0; i3 < n4; ++i3) {
                int n6;
                for (int i4 = 0; i4 < 8; ++i4) {
                    n6 = n5 < this.b() ? (this.get(n5++) ? 1 : 0) : 0;
                    cArray[i4] = n6 = (int)((char)(n6 + 48));
                }
                String string = new String(cArray);
                n6 = Integer.parseInt(string, 2);
                byArray[i3] = (byte)n6;
            }
        }
        return byArray;
    }

    public void setValue(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < this.b(); ++n2) {
            this.clear(n2);
        }
        n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (this._radix == 2) {
                if (byArray[i2] != 1) continue;
                this.set(i2);
                continue;
            }
            int n3 = byArray[i2];
            if (byArray[i2] < 0) {
                n3 = byArray[i2] + 256;
            }
            for (int i3 = 0; i3 < 2; ++i3) {
                int n4 = 0;
                n4 = i3 == 0 ? n3 >> 4 : n3 & 0xF;
                byte[] byArray2 = d[n4];
                for (int i4 = 0; i4 < byArray2.length; ++i4) {
                    if (byArray2[i4] != 1) continue;
                    this.set(n2 + i4);
                }
                n2 += 4;
            }
        }
    }

    public void setValue(String string, boolean bl) {
        if (bl) {
            int n2 = string.indexOf("{");
            int n3 = string.indexOf("}");
            string = string.substring(n2 + 1, n3);
            String[] stringArray = ec.parse(string, ',', true);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].length() <= 0) continue;
                int n4 = Integer.parseInt(stringArray[i2]);
                this.set(n4);
            }
        } else {
            this.a(string);
        }
    }

    public void setValue(String string) {
        this.a(string);
    }

    private void a(String string) {
        int n2;
        for (n2 = 0; n2 < this.b(); ++n2) {
            this.clear(n2);
        }
        n2 = 0;
        string = string.trim();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int n3;
            if (this._radix == 2) {
                n3 = this.a(cArray[i2]);
                if (n3 != 1) continue;
                this.set(i2);
                continue;
            }
            n3 = this.a(cArray[i2]);
            byte[] byArray = d[n3];
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                if (byArray[i3] != 1) continue;
                this.set(n2 + i3);
            }
            n2 += 4;
        }
    }

    private int a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            c2 = (char)(c2 - 48);
        } else if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 - 55);
        } else if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 87);
        }
        return c2;
    }

    public String toString() {
        int n2 = this.f << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n2 + 2);
        String string = "";
        stringBuffer.append('{');
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.get(i2)) continue;
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(i2);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public SnmpDataType copy() {
        return new SnmpBits(this);
    }

    public int encode(g g2) throws SnmpEncodingException {
        return g2.a(this);
    }

    private static int a(int n2) {
        return n2 >> 6;
    }

    private static long b(int n2) {
        return 1L << (n2 & 0x3F);
    }

    private void a() {
        int n2;
        for (n2 = this.f - 1; n2 >= 0 && this.e[n2] == 0L; --n2) {
        }
        this.f = n2 + 1;
    }

    private void c(int n2) {
        if (this.e.length < n2) {
            int n3 = Math.max(2 * this.e.length, n2);
            long[] lArray = new long[n3];
            System.arraycopy(this.e, 0, lArray, 0, this.f);
            this.e = lArray;
        }
    }

    public void flip(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = SnmpBits.a(n2);
        int n4 = n3 + 1;
        if (this.f < n4) {
            this.c(n4);
            int n5 = n3;
            this.e[n5] = this.e[n5] ^ SnmpBits.b(n2);
            this.f = n4;
        } else {
            int n6 = n3;
            this.e[n6] = this.e[n6] ^ SnmpBits.b(n2);
            if (this.e[this.f - 1] == 0L) {
                this.a();
            }
        }
    }

    public void flip(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = SnmpBits.a(n3);
        int n5 = n4 + 1;
        if (this.f < n5) {
            this.c(n5);
            this.f = n5;
        }
        int n6 = SnmpBits.a(n2);
        long l2 = 0L;
        if (n6 == n4) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n7 = n6;
            this.e[n7] = this.e[n7] ^ l2;
            if (this.e[this.f - 1] == 0L) {
                this.a();
            }
            return;
        }
        l2 = SnmpBits.e(n2 & 0x3F);
        int n8 = n6;
        this.e[n8] = this.e[n8] ^ l2;
        if (n4 - n6 > 1) {
            int n9 = n6 + 1;
            while (n9 < n4) {
                int n10 = n9++;
                this.e[n10] = this.e[n10] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l2 = SnmpBits.d(n3 & 0x3F);
        int n11 = n4;
        this.e[n11] = this.e[n11] ^ l2;
        if (this.e[this.f - 1] == 0L) {
            this.a();
        }
    }

    private static long d(int n2) {
        return n2 == 0 ? 0L : -1L >>> 64 - n2;
    }

    private static long e(int n2) {
        return -1L << n2;
    }

    public void set(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = SnmpBits.a(n2);
        int n4 = n3 + 1;
        if (this.f < n4) {
            this.c(n4);
            int n5 = n3;
            this.e[n5] = this.e[n5] | SnmpBits.b(n2);
            this.f = n4;
        } else {
            int n6 = n3;
            this.e[n6] = this.e[n6] | SnmpBits.b(n2);
        }
    }

    public void set(int n2, boolean bl) {
        if (bl) {
            this.set(n2);
        } else {
            this.clear(n2);
        }
    }

    public void set(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = SnmpBits.a(n3);
        int n5 = n4 + 1;
        if (this.f < n5) {
            this.c(n5);
            this.f = n5;
        }
        int n6 = SnmpBits.a(n2);
        long l2 = 0L;
        if (n6 == n4) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n7 = n6;
            this.e[n7] = this.e[n7] | l2;
            return;
        }
        l2 = SnmpBits.e(n2 & 0x3F);
        int n8 = n6;
        this.e[n8] = this.e[n8] | l2;
        if (n4 - n6 > 1) {
            int n9 = n6 + 1;
            while (n9 < n4) {
                int n10 = n9++;
                this.e[n10] = this.e[n10] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l2 = SnmpBits.d(n3 & 0x3F);
        int n11 = n4;
        this.e[n11] = this.e[n11] | l2;
    }

    public void set(int n2, int n3, boolean bl) {
        if (bl) {
            this.set(n2, n3);
        } else {
            this.clear(n2, n3);
        }
    }

    public void clear(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = SnmpBits.a(n2);
        if (n3 >= this.f) {
            return;
        }
        int n4 = n3;
        this.e[n4] = this.e[n4] & (SnmpBits.b(n2) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.e[this.f - 1] == 0L) {
            this.a();
        }
    }

    public void clear(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = SnmpBits.a(n2);
        if (n4 >= this.f) {
            return;
        }
        int n5 = SnmpBits.a(n3);
        long l2 = 0L;
        if (n4 == n5) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n6 = n4;
            this.e[n6] = this.e[n6] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.e[this.f - 1] == 0L) {
                this.a();
            }
            return;
        }
        l2 = SnmpBits.e(n2 & 0x3F);
        int n7 = n4;
        this.e[n7] = this.e[n7] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (n5 - n4 > 1) {
            for (int i2 = n4 + 1; i2 < n5; ++i2) {
                if (i2 >= this.f) continue;
                this.e[i2] = 0L;
            }
        }
        if (n5 < this.f) {
            l2 = SnmpBits.d(n3 & 0x3F);
            int n8 = n5;
            this.e[n8] = this.e[n8] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.e[this.f - 1] == 0L) {
            this.a();
        }
    }

    public void clear() {
        while (this.f > 0) {
            this.e[--this.f] = 0L;
        }
    }

    public boolean get(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        boolean bl = false;
        int n3 = SnmpBits.a(n2);
        if (n3 < this.f) {
            bl = (this.e[n3] & SnmpBits.b(n2)) != 0L;
        }
        return bl;
    }

    private int b() {
        if (this.c >= 0) {
            return this.c;
        }
        if (this.f == 0) {
            return 0;
        }
        long l2 = this.e[this.f - 1];
        int n2 = (int)(l2 >>> 32);
        return 64 * (this.f - 1) + (n2 == 0 ? SnmpBits.f((int)l2) : 32 + SnmpBits.f(n2));
    }

    private static int f(int n2) {
        return n2 < 32768 ? (n2 < 128 ? (n2 < 8 ? (n2 < 2 ? (n2 < 1 ? (n2 < 0 ? 32 : 0) : 1) : (n2 < 4 ? 2 : 3)) : (n2 < 32 ? (n2 < 16 ? 4 : 5) : (n2 < 64 ? 6 : 7))) : (n2 < 2048 ? (n2 < 512 ? (n2 < 256 ? 8 : 9) : (n2 < 1024 ? 10 : 11)) : (n2 < 8192 ? (n2 < 4096 ? 12 : 13) : (n2 < 16384 ? 14 : 15)))) : (n2 < 0x800000 ? (n2 < 524288 ? (n2 < 131072 ? (n2 < 65536 ? 16 : 17) : (n2 < 262144 ? 18 : 19)) : (n2 < 0x200000 ? (n2 < 0x100000 ? 20 : 21) : (n2 < 0x400000 ? 22 : 23))) : (n2 < 0x8000000 ? (n2 < 0x2000000 ? (n2 < 0x1000000 ? 24 : 25) : (n2 < 0x4000000 ? 26 : 27)) : (n2 < 0x20000000 ? (n2 < 0x10000000 ? 28 : 29) : (n2 < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        return this.f == 0;
    }

    public int cardinality() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.f; ++i2) {
            n2 += SnmpBits.a(this.e[i2]);
        }
        return n2;
    }

    private static int a(long l2) {
        l2 -= (l2 & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        l2 = (l2 & 0x3333333333333333L) + (l2 >>> 2 & 0x3333333333333333L);
        l2 = l2 + (l2 >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l2 += l2 >>> 8;
        l2 += l2 >>> 16;
        return (int)l2 + (int)(l2 >>> 32) & 0xFF;
    }

    public void and(SnmpBits snmpBits) {
        int n2;
        if (this == snmpBits) {
            return;
        }
        int n3 = this.f;
        this.f = Math.min(this.f, snmpBits.f);
        for (n2 = 0; n2 < this.f; ++n2) {
            int n4 = n2;
            this.e[n4] = this.e[n4] & snmpBits.e[n2];
        }
        while (n2 < n3) {
            this.e[n2] = 0L;
            ++n2;
        }
        if (this.f > 0 && this.e[this.f - 1] == 0L) {
            this.a();
        }
    }

    public void or(SnmpBits snmpBits) {
        int n2;
        if (this == snmpBits) {
            return;
        }
        this.c(snmpBits.f);
        int n3 = Math.min(this.f, snmpBits.f);
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2;
            this.e[n4] = this.e[n4] | snmpBits.e[n2];
        }
        while (n2 < snmpBits.f) {
            this.e[n2] = snmpBits.e[n2];
            ++n2;
        }
        if (this.f < snmpBits.f) {
            this.f = snmpBits.f;
        }
    }

    public void xor(SnmpBits snmpBits) {
        int n2;
        int n3;
        if (this.f >= snmpBits.f) {
            n3 = snmpBits.f;
        } else {
            n3 = this.f;
            n2 = snmpBits.f;
            this.c(n2);
            this.f = n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2;
            this.e[n4] = this.e[n4] ^ snmpBits.e[n2];
        }
        while (n2 < snmpBits.f) {
            this.e[n2] = snmpBits.e[n2];
            ++n2;
        }
        this.a();
    }

    public void andNot(SnmpBits snmpBits) {
        int n2 = Math.min(this.f, snmpBits.f);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.e[n3] = this.e[n3] & (snmpBits.e[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.a();
    }

    public int hashCode() {
        long l2 = 1234L;
        int n2 = this.e.length;
        while (--n2 >= 0) {
            l2 ^= this.e[n2] * (long)(n2 + 1);
        }
        return (int)(l2 >> 32 ^ l2);
    }

    public boolean equals(Object object) {
        int n2;
        if (!(object instanceof SnmpBits)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        SnmpBits snmpBits = (SnmpBits)object;
        int n3 = Math.min(this.f, snmpBits.f);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.e[n2] == snmpBits.e[n2]) continue;
            return false;
        }
        if (this.f > n3) {
            for (n2 = n3; n2 < this.f; ++n2) {
                if (this.e[n2] == 0L) continue;
                return false;
            }
        } else {
            for (n2 = n3; n2 < snmpBits.f; ++n2) {
                if (snmpBits.e[n2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public void setFixedLength(int n2) {
        this.c = n2;
    }

    public static void main(String[] stringArray) {
        SnmpBits snmpBits = null;
        snmpBits = new SnmpBits(2);
        snmpBits.setValue("000000000");
        byte[] byArray = snmpBits.getValue();
        o.hexDump(byArray, 0, byArray.length);
    }
}

