/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.NameValue;
import com.ireasoning.protocol.snmp.SnmpBits;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpV1Trap;
import com.ireasoning.util.CTreeNode;
import com.ireasoning.util.Logger;
import com.ireasoning.util.MibParseException;
import com.ireasoning.util.MibTreeNode;
import com.ireasoning.util.Syntax;
import com.ireasoning.util.ec;
import com.ireasoning.util.k;
import com.ireasoning.util.pb;
import com.ireasoning.util.ub;
import com.ireasoning.util.vb;
import com.ireasoning.util.xb;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;

public final class MibUtil {
    private static MibUtil a = new MibUtil();

    private MibUtil() {
    }

    public static void setResolveSyntax(boolean bl) {
        pb.setResolveSyntax(bl);
    }

    public static void loadMibs(String[] stringArray) throws IOException, MibParseException {
        MibUtil.loadMibs(stringArray, true);
    }

    public static void loadMibs(String[] stringArray, boolean bl) throws IOException, MibParseException {
        ub.loadMibs(stringArray, bl);
    }

    public static void loadMibs(String[] stringArray, String string) throws IOException, MibParseException {
        MibUtil.loadMibs(stringArray, true, string);
    }

    public static void loadMibs(String[] stringArray, boolean bl, String string) throws IOException, MibParseException {
        ub.loadMibs(stringArray, bl, string);
    }

    public static void loadMib(String string) throws IOException, MibParseException {
        MibUtil.loadMib(string, null);
    }

    public static void loadMib(String string, String string2) throws IOException, MibParseException {
        MibUtil.loadMib(string, true, string2);
    }

    public static void loadMib(String string, boolean bl) throws IOException, MibParseException {
        MibUtil.loadMib(string, bl, null);
    }

    public static void loadMib(String string, boolean bl, String string2) throws IOException, MibParseException {
        ub.loadMib(string, bl, string2);
    }

    public static void loadMib(Reader reader, boolean bl) throws IOException, MibParseException {
        ub.loadMib(reader, bl, null);
    }

    public static void loadMib(Reader reader, boolean bl, String string) throws IOException, MibParseException {
        ub.loadMib(reader, bl, string);
    }

    public static void loadMibs(Reader[] readerArray, boolean bl) throws IOException, MibParseException {
        ub.loadMibs(readerArray, bl, null);
    }

    public static void loadMib2() {
        boolean bl = SnmpEncodingException.a;
        try {
            URL uRL;
            Reader reader;
            block8: {
                block7: {
                    reader = vb.getResourceAsReader("RFC1213.MIB");
                    if (bl) break block7;
                    if (reader != null) break block8;
                    Logger.warn("Loading MIB-II from resource bundle failed. You may need to use loadMib method to load MIB-II explicitly.");
                }
                return;
            }
            URL uRL2 = uRL = vb.getResource("RFC1213.MIB");
            if (!bl) {
                if (uRL2 == null) {
                    Logger.warn("Loading MIB-II from resource bundle failed. You may need to use loadMib method to load MIB-II explicitly.");
                    return;
                }
                uRL2 = uRL;
            }
            String string = uRL2.toString();
            ub.loadMib(reader, string);
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    public static void unloadMib(String string) {
        ub.unloadMib(string);
    }

    public static void unloadAllMibs() {
        ub.unloadAllMibs();
    }

    public static boolean isMibFileLoaded() {
        return pb.isMibFileLoaded();
    }

    public static SnmpOID lookupOID(String string) {
        return MibUtil.lookupOID(string, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static SnmpOID lookupOID(String var0, String var1_1) {
        block58: {
            block57: {
                block56: {
                    block49: {
                        block55: {
                            block54: {
                                block53: {
                                    block45: {
                                        block43: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block48: {
                                                            block47: {
                                                                var16_2 = SnmpEncodingException.a;
                                                                v0 = var0.startsWith(".");
                                                                if (!var16_2) {
                                                                    if (v0 != 0) {
                                                                        var0 = var0.substring(1);
                                                                    }
                                                                    v0 = var0.equals("ccitt.0");
                                                                }
                                                                if (!var16_2) {
                                                                    if (v0 != 0) {
                                                                        return new SnmpOID(".0.0");
                                                                    }
                                                                    v0 = var0.indexOf(".");
                                                                }
                                                                if ((var2_3 = v0) >= 0) break block47;
                                                                var3_4 = null;
                                                                v1 = var1_1;
                                                                if (var16_2) ** GOTO lbl19
                                                                if (v1 == null) {
                                                                    var3_4 = ub.lookupOID(var0);
                                                                } else {
                                                                    v1 = var0 + ":" + var1_1;
lbl19:
                                                                    // 2 sources

                                                                    var3_4 = ub.lookupOID(v1);
                                                                }
                                                                return var3_4;
                                                            }
                                                            var3_5 = var0.substring(0, var2_3);
                                                            var4_6 = var0.substring(var2_3 + 1);
                                                            v2 = xb.isDigit(var3_5);
                                                            if (!var16_2) {
                                                                if (v2 != 0) {
                                                                    return new SnmpOID(var0);
                                                                }
                                                                v2 = xb.isDigit(var4_6);
                                                            }
                                                            if (var16_2) break block48;
                                                            if (v2 != 0) break block49;
                                                            v2 = var0.indexOf(".", var2_3 + 1);
                                                        }
                                                        v3 = var5_7 = v2;
                                                        if (var16_2) break block50;
                                                        if (v3 >= 0) break block51;
                                                        v3 = var0.length();
                                                    }
                                                    var5_7 = v3;
                                                }
                                                v4 = var6_9 = var0.substring(var2_3 + 1, var5_7);
                                                if (var16_2) break block52;
                                                if (xb.isDigit(v4)) break block49;
                                                v4 = var0;
                                            }
                                            var7_10 = ec.parse(v4, '.');
                                            var8_11 = ub.getRoots();
                                            var9_12 = var8_11.size();
                                            var10_13 = null;
                                            var11_14 = var7_10[0];
                                            var12_15 = 0;
                                            block0: while (true) {
                                                v5 = var12_15;
                                                block1: while (v5 < var9_12) {
                                                    var13_17 = (MibTreeNode)var8_11.get(var12_15);
                                                    v6 = var10_13 = var13_17.searchIgnoreCase(var11_14);
                                                    if (var16_2) break block43;
                                                    if (v6 != null) {
                                                        for (var14_19 = 1; var14_19 < var7_10.length; ++var14_19) {
                                                            block44: {
                                                                v5 = (int)xb.isDigit(var7_10[var14_19]);
                                                                if (var16_2) continue block1;
                                                                if (v5 != 0 && !var16_2) break block0;
                                                                for (var10_13 = (MibTreeNode)var10_13.getFirstChild(); var10_13 != null; var10_13 = (MibTreeNode)var10_13.getNextSibling()) {
                                                                    v7 = (int)var7_10[var14_19].equalsIgnoreCase(var10_13.getName().toString());
                                                                    if (!var16_2) {
                                                                        if (v7 != 0 && !var16_2) break;
                                                                        if (!var16_2) continue;
                                                                    }
                                                                    break block44;
                                                                }
                                                                if (var10_13 == null) break;
                                                                v7 = var14_19;
                                                            }
                                                            if (v7 == var7_10.length - 1 && !var16_2) break block0;
                                                            if (!var16_2) continue;
                                                        }
                                                    }
                                                    ++var12_15;
                                                    if (!var16_2) continue block0;
                                                }
                                                break;
                                            }
                                            v6 = var10_13;
                                        }
                                        if (!var16_2) {
                                            if (v6 == null) {
                                                return null;
                                            }
                                            v6 = var10_13;
                                        }
                                        var12_16 = v6.getOID();
                                        for (var13_18 = var7_10.length - 1; var13_18 >= 0; --var13_18) {
                                            v8 = (int)xb.isDigit(var7_10[var13_18]);
                                            if (!var16_2) {
                                                if (v8 == 0 && !var16_2) break;
                                                if (!var16_2) continue;
                                            }
                                            break block45;
                                        }
                                        v8 = var13_18;
                                    }
                                    if (!var16_2) {
                                        block46: {
                                            if (v8 != var7_10.length - 1) {
                                                var14_20 = "";
                                                for (var15_21 = var13_18 + 1; var15_21 < var7_10.length; ++var15_21) {
                                                    var14_20 = var14_20 + "." + var7_10[var15_21];
                                                    if (!var16_2) {
                                                        if (!var16_2) continue;
                                                    }
                                                    break block46;
                                                }
                                                var12_16.append(var14_20);
                                            }
                                        }
                                        v8 = (int)var10_13.isScalarNode();
                                    }
                                    if (var16_2) break block53;
                                    if (v8 == 0) break block54;
                                    v9 = var12_16;
                                    if (var16_2) break block55;
                                    v8 = (int)v9.endsWith(".0");
                                }
                                if (v8 == 0) {
                                    var12_16.append(".0");
                                }
                            }
                            v9 = var12_16;
                        }
                        return v9;
                    }
                    var5_8 = null;
                    v10 = var1_1;
                    if (var16_2) ** GOTO lbl123
                    if (v10 == null) {
                        var5_8 = ub.lookupOID(var3_5);
                    } else {
                        v10 = var3_5 + ":" + var1_1;
lbl123:
                        // 2 sources

                        var5_8 = ub.lookupOID(v10);
                    }
                    v11 = var5_8;
                    if (var16_2) ** GOTO lbl130
                    if (v11 == null) {
                        v12 = null;
                    } else {
                        v11 = var5_8;
lbl130:
                        // 2 sources

                        v12 = v11.append(var4_6);
                    }
                    var5_8 = v12;
                    v13 = ub.isScalarNode(var3_5);
                    if (var16_2) break block56;
                    if (!v13) break block57;
                    v14 = var5_8;
                    if (var16_2) break block58;
                    v13 = v14.endsWith(".0.0");
                }
                if (v13) {
                    var5_8 = var5_8.suboid(0, var5_8.getLength() - 1);
                }
            }
            v14 = var5_8;
        }
        return v14;
    }

    public static String translateOID(String string, boolean bl) {
        MibTreeNode mibTreeNode;
        block5: {
            MibTreeNode mibTreeNode2;
            block4: {
                mibTreeNode2 = mibTreeNode = ub.get(string);
                if (SnmpEncodingException.a) break block4;
                if (mibTreeNode2 != null) break block5;
                mibTreeNode2 = mibTreeNode = ub.searchOther(new SnmpOID(string));
            }
            if (mibTreeNode2 == null) {
                return null;
            }
        }
        String string2 = MibUtil.a(string, mibTreeNode, bl);
        return string2;
    }

    public static String translateOID(SnmpOID snmpOID, boolean bl) {
        return MibUtil.translateOID(snmpOID.toString(), bl);
    }

    public static String translateSnmpV1Trap(SnmpV1Trap snmpV1Trap) {
        return MibUtil.translateSnmpV1Trap(snmpV1Trap.getEnterprise(), snmpV1Trap.getGeneric(), snmpV1Trap.getSpecific());
    }

    public static String translateSnmpV1Trap(SnmpOID snmpOID, int n2, int n3) {
        int n4;
        block12: {
            block13: {
                int n5;
                block14: {
                    boolean bl = SnmpEncodingException.a;
                    n4 = n2;
                    if (bl) break block12;
                    if (n4 >= 6) break block13;
                    n4 = n2;
                    if (!bl) {
                        if (n4 == 0) {
                            return "coldStart";
                        }
                        n4 = 1;
                    }
                    n5 = n2;
                    if (!bl) {
                        if (n4 == n5) {
                            return "warmStart";
                        }
                        n4 = 2;
                        n5 = n2;
                    }
                    if (!bl) {
                        if (n4 == n5) {
                            return "linkDown";
                        }
                        n4 = 3;
                        n5 = n2;
                    }
                    if (!bl) {
                        if (n4 == n5) {
                            return "linkUp";
                        }
                        n4 = 4;
                        n5 = n2;
                    }
                    if (bl) break block14;
                    if (n4 == n5) {
                        return "authenticationFailure";
                    }
                    n4 = 5;
                    if (bl) break block12;
                    n5 = n2;
                }
                if (n4 == n5) {
                    return "egpNeighborLoss";
                }
            }
            n4 = n3;
        }
        long l2 = (long)n4 & 0xFFFFFFFFL;
        String string = snmpOID.toString() + ".0." + l2;
        return ub.getSnmpV1TrapName(string);
    }

    public static String translateValue(String string, String string2) {
        String string3;
        boolean bl = SnmpEncodingException.a;
        String string4 = string2;
        if (!bl) {
            if (string4 == null) {
                return null;
            }
            string4 = string;
        }
        MibTreeNode mibTreeNode = ub.get(string4);
        String string5 = string3 = MibUtil.a(string2, mibTreeNode);
        if (!bl) {
            if (string5 == null) {
                string3 = string2;
            }
            string5 = string3;
        }
        return string5;
    }

    public static String translateValue(SnmpOID snmpOID, String string) {
        return MibUtil.translateValue(snmpOID.toString(), string);
    }

    public static NameValue translate(String string, String string2, boolean bl) {
        MibTreeNode mibTreeNode = ub.get(string);
        if (mibTreeNode == null) {
            return null;
        }
        String string3 = MibUtil.a(string, mibTreeNode, bl);
        string2 = MibUtil.a(string2, mibTreeNode);
        return new NameValue(string3, string2);
    }

    public static NameValue translate(SnmpOID snmpOID, String string, boolean bl) {
        return MibUtil.translate(snmpOID.toString(), string, bl);
    }

    public static MibTreeNode parseMib(String string) throws IOException, MibParseException {
        return MibUtil.parseMib(string, true);
    }

    public static MibTreeNode parseMib(Reader reader, boolean bl) throws IOException, MibParseException {
        k k2;
        pb pb2 = pb.loadMib(reader, bl);
        k k3 = k2 = (k)pb2.getRoot();
        if (!SnmpEncodingException.a) {
            if (k3 != null) {
                k2.setTrapNodes(pb2.getTraps());
            }
            k3 = k2;
        }
        return k3;
    }

    public static MibTreeNode parseMibs(Reader[] readerArray, boolean bl) throws IOException, MibParseException {
        k k2;
        pb pb2;
        Vector vector;
        boolean bl2;
        block6: {
            bl2 = SnmpEncodingException.a;
            pb pb3 = pb.loadMib(readerArray[0], bl);
            vector = new Vector();
            vector.addAll(pb3.getTraps());
            for (int i2 = 1; i2 < readerArray.length; ++i2) {
                pb pb4;
                pb2 = pb4 = pb.loadMib(readerArray[i2]);
                if (!bl2) {
                    MibTreeNode mibTreeNode;
                    MibTreeNode mibTreeNode2;
                    pb pb5;
                    if (!bl2) {
                        if (pb2 == null) continue;
                        vector.addAll(pb4.getTraps());
                        pb5 = pb4;
                    }
                    CTreeNode cTreeNode = mibTreeNode2 = pb5.getRoot();
                    if (!bl2) {
                        if (cTreeNode == null) continue;
                        cTreeNode = mibTreeNode2.getFirstChild();
                    }
                    if ((mibTreeNode = cTreeNode) == null) continue;
                    pb3.addOtherSubTree((MibTreeNode)mibTreeNode.getFirstChild());
                    if (!bl2) continue;
                }
                break block6;
            }
            pb2 = pb3;
        }
        k k3 = k2 = (k)pb2.getRoot();
        if (!bl2) {
            if (k3 != null) {
                k2.setTrapNodes(vector);
            }
            k3 = k2;
        }
        return k3;
    }

    public static MibTreeNode parseMib(String string, boolean bl) throws IOException, MibParseException {
        k k2;
        pb pb2 = pb.loadMib(string, bl);
        k k3 = k2 = (k)pb2.getRoot();
        if (!SnmpEncodingException.a) {
            if (k3 != null) {
                k2.setTrapNodes(pb2.getTraps());
            }
            k3 = k2;
        }
        return k3;
    }

    public static MibTreeNode parseMibs(String[] stringArray) throws IOException, MibParseException {
        return MibUtil.parseMibs(stringArray, true);
    }

    public static MibTreeNode parseMibs(String[] stringArray, boolean bl) throws IOException, MibParseException {
        k k2;
        pb pb2;
        Vector vector;
        boolean bl2;
        block6: {
            bl2 = SnmpEncodingException.a;
            pb pb3 = pb.loadMib(stringArray[0], bl);
            vector = new Vector();
            vector.addAll(pb3.getTraps());
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                pb pb4;
                pb2 = pb4 = pb.loadMib(stringArray[i2]);
                if (!bl2) {
                    MibTreeNode mibTreeNode;
                    MibTreeNode mibTreeNode2;
                    pb pb5;
                    if (!bl2) {
                        if (pb2 == null) continue;
                        vector.addAll(pb4.getTraps());
                        pb5 = pb4;
                    }
                    CTreeNode cTreeNode = mibTreeNode2 = pb5.getRoot();
                    if (!bl2) {
                        if (cTreeNode == null) continue;
                        cTreeNode = mibTreeNode2.getFirstChild();
                    }
                    if ((mibTreeNode = cTreeNode) == null) continue;
                    pb3.addOtherSubTree((MibTreeNode)mibTreeNode.getFirstChild());
                    if (!bl2) continue;
                }
                break block6;
            }
            pb2 = pb3;
        }
        k k3 = k2 = (k)pb2.getRoot();
        if (!bl2) {
            if (k3 != null) {
                k2.setTrapNodes(vector);
            }
            k3 = k2;
        }
        return k3;
    }

    public static MibTreeNode[] parseMibsWithoutMerge(String[] stringArray) throws IOException, MibParseException {
        return MibUtil.parseMibsWithoutMerge(stringArray, true);
    }

    public static MibTreeNode[] parseMibsWithoutMerge(String[] stringArray, boolean bl) throws IOException, MibParseException {
        MibTreeNode[] mibTreeNodeArray;
        block2: {
            boolean bl2 = SnmpEncodingException.a;
            MibTreeNode[] mibTreeNodeArray2 = new MibTreeNode[stringArray.length];
            for (int i2 = 0; i2 < mibTreeNodeArray2.length; ++i2) {
                mibTreeNodeArray = mibTreeNodeArray2;
                if (!bl2) {
                    mibTreeNodeArray[i2] = MibUtil.parseMib(stringArray[i2], bl);
                    if (!bl2) continue;
                }
                break block2;
            }
            mibTreeNodeArray = mibTreeNodeArray2;
        }
        return mibTreeNodeArray;
    }

    private static String a(String string, MibTreeNode mibTreeNode) {
        String string2;
        block14: {
            block13: {
                String string3;
                Syntax syntax;
                boolean bl;
                block12: {
                    Syntax syntax2;
                    block11: {
                        String string4;
                        block9: {
                            block10: {
                                String string5;
                                bl = SnmpEncodingException.a;
                                MibTreeNode mibTreeNode2 = mibTreeNode;
                                if (!bl) {
                                    if (mibTreeNode2 == null) {
                                        return null;
                                    }
                                    mibTreeNode2 = mibTreeNode;
                                }
                                syntax2 = mibTreeNode2.getSyntax();
                                string4 = string5 = mibTreeNode.getSyntaxType();
                                if (bl) break block9;
                                if (string4.equals("BITS")) break block10;
                                string4 = string5;
                                if (bl) break block9;
                                if (!string4.equals("FcPortFCClass")) break block11;
                            }
                            string4 = MibUtil.b(string, mibTreeNode);
                        }
                        return string4;
                    }
                    syntax = syntax2;
                    if (bl) break block12;
                    if (syntax == null) break block13;
                    syntax = syntax2;
                }
                string2 = string3 = syntax.get(string);
                if (bl) break block14;
                if (string2 != null) {
                    string = string3;
                }
            }
            string2 = string;
        }
        return string2;
    }

    private static String b(String string, MibTreeNode mibTreeNode) {
        String string2;
        block11: {
            int n2;
            boolean bl = SnmpEncodingException.a;
            int n3 = n2 = string.indexOf("{");
            if (!bl) {
                n3 = n3 >= 0 ? 1 : 0;
            }
            int n4 = n3;
            SnmpBits snmpBits = new SnmpBits();
            int n5 = n2;
            if (!bl) {
                if (n5 < 0) {
                    byte[] byArray = SnmpOctetString.getBytes(string);
                    snmpBits.setValue(byArray);
                    string = snmpBits.toString();
                    n2 = string.indexOf("{");
                }
                n5 = string.indexOf("}");
            }
            int n6 = n5;
            string = string.substring(n2 + 1, n6);
            String[] stringArray = ec.parse(string, ',', true);
            Syntax syntax = mibTreeNode.getSyntax();
            string2 = "{";
            boolean bl2 = true;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string3;
                block13: {
                    Syntax syntax2;
                    block12: {
                        string3 = null;
                        if (bl) break block11;
                        syntax2 = syntax;
                        if (bl) break block12;
                        if (syntax2 == null) break block13;
                        syntax2 = syntax;
                    }
                    string3 = syntax2.get(stringArray[i2]);
                }
                boolean bl3 = bl2;
                if (!bl) {
                    if (!bl3) {
                        string2 = string2 + ", ";
                    }
                    bl3 = false;
                }
                bl2 = bl3;
                String string4 = string3;
                if (!bl) {
                    if (string4 != null) {
                        string2 = string2 + string3;
                        if (!bl) continue;
                    }
                    string4 = string2 + stringArray[i2];
                }
                string2 = string4;
                if (!bl) continue;
            }
            string2 = string2 + "}";
        }
        return string2;
    }

    private static String a(String string, MibTreeNode mibTreeNode, boolean bl) {
        Object object;
        boolean bl2 = SnmpEncodingException.a;
        MibTreeNode mibTreeNode2 = mibTreeNode;
        if (!bl2) {
            if (mibTreeNode2 == null) {
                return null;
            }
            mibTreeNode2 = mibTreeNode;
        }
        SnmpOID snmpOID = mibTreeNode2.getOID();
        SnmpOID snmpOID2 = new SnmpOID(string);
        String string2 = "";
        int n2 = snmpOID.getLength();
        if (!bl2) {
            if (n2 < snmpOID2.getLength()) {
                object = snmpOID2.suboid(snmpOID.getLength(), snmpOID2.getLength());
                string2 = ((SnmpOID)object).toString();
            }
            n2 = bl ? 1 : 0;
        }
        object = n2 != 0 ? mibTreeNode.getFullName() + string2 : mibTreeNode.getName().toString() + string2;
        return object;
    }
}

