/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol;

import com.ireasoning.core.jmx.State;
import com.ireasoning.core.network.d;
import com.ireasoning.core.network.e;
import com.ireasoning.core.network.l;
import com.ireasoning.protocol.ListenThread;
import com.ireasoning.protocol.ListenerManager;
import com.ireasoning.protocol.Target;
import com.ireasoning.util.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;

public abstract class Session
extends ListenerManager
implements Serializable,
State {
    public static final int UDP = 0;
    public static final int TCP = 1;
    public static final int DEFAULT_TIME_OUT = 60000;
    protected Target _target;
    protected l _transportLayer;
    protected int _timeout;
    protected int _tries;
    protected int _state;
    protected ListenThread _thread;
    protected transient InetAddress _localAddr;
    protected transient int _localPort;

    protected Session() {
        this._target = null;
        this._transportLayer = null;
        this._timeout = 60000;
        this._tries = 3;
        this._state = 3;
        this._thread = null;
    }

    protected Session(int n2) {
        int n3 = ListenerManager.b;
        this._target = null;
        this._transportLayer = null;
        this._timeout = 60000;
        this._tries = 3;
        this._state = 3;
        this._thread = null;
        this._transportLayer = this.getTransportLayer(n2);
        if (Logger.o) {
            ListenerManager.b = ++n3;
        }
    }

    protected Session(l l2) {
        this._target = null;
        this._transportLayer = null;
        this._timeout = 60000;
        this._tries = 3;
        this._state = 3;
        this._thread = null;
        this._transportLayer = l2;
    }

    protected Session(String string, int n2, int n3) throws IOException {
        this(string, n2, n3, null, 0);
    }

    protected Session(String string, int n2, int n3, InetAddress inetAddress, int n4) throws IOException {
        int n5 = ListenerManager.b;
        this._target = null;
        this._transportLayer = null;
        this._timeout = 60000;
        this._tries = 3;
        this._state = 3;
        this._thread = null;
        this._transportLayer = this.getTransportLayer(n3);
        this.open(string, n2, inetAddress, n4);
        if (n5 != 0) {
            Logger.o = !Logger.o;
        }
    }

    protected Session(Target target, int n2, InetAddress inetAddress, int n3) throws IOException {
        this(target.getHost(), target.getPort(), n2, inetAddress, n3);
        this._target = target;
    }

    protected void reopen(Target target) throws IOException {
        this._state = 0;
        this.open(target, this._localAddr, this._localPort);
        this._thread = null;
    }

    protected void open(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        int n4 = ListenerManager.b;
        Session session = this;
        if (n4 == 0) {
            if (session._state == 1) {
                return;
            }
            session = this;
        }
        session._state = 3;
        if (n4 == 0) {
            if (string == null) {
                Logger.error("host is null");
                throw new IOException("host is null");
            }
            this._transportLayer.open(string, n2, inetAddress, n3);
            this._localPort = n3;
            this._localAddr = inetAddress;
            this._state = 0;
        }
        try {
            int n5 = this._timeout;
            this._timeout = -1;
            this.setTimeout(n5);
        }
        catch (SocketException socketException) {
            Logger.error(socketException);
        }
        this._state = 1;
    }

    protected void open(Target target, InetAddress inetAddress, int n2) throws IOException {
        this.open(target.getHost(), target.getPort(), inetAddress, n2);
        this._target = target;
    }

    public void setTransportLayer(int n2) {
        this._transportLayer = this.getTransportLayer(n2);
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int n2) throws SocketException {
        this._timeout = n2;
    }

    public int getRetries() {
        return this._tries - 1;
    }

    public void setRetries(int n2) {
        this._tries = n2 + 1;
    }

    public void close() {
        block3: {
            l l2;
            block2: {
                this._state = 3;
                l2 = this._transportLayer;
                if (ListenerManager.b != 0) break block2;
                if (l2 == null) break block3;
                l2 = this._transportLayer;
            }
            l2.close();
        }
    }

    public Target getTarget() {
        return this._target;
    }

    public void setTarget(Target target) {
        this._target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getState() {
        return this._state;
    }

    public String getStateString() {
        return State.STATES[this._state];
    }

    protected l getTransportLayer(int n2) {
        int n3 = n2;
        if (ListenerManager.b == 0) {
            if (n3 == 0) {
                return new e();
            }
            n3 = n2;
        }
        if (n3 == 1) {
            return new d();
        }
        throw new IllegalArgumentException("Unknown transport layer");
    }

    public synchronized void startThread() {
        block3: {
            ListenThread listenThread;
            block2: {
                listenThread = this._thread;
                if (ListenerManager.b != 0) break block2;
                if (listenThread != null) break block3;
                Logger.debug("Start a thread to listen for async. responses");
                listenThread = this._thread = new ListenThread(this);
            }
            listenThread.start();
        }
    }

    protected abstract Object receiveObject() throws IOException;
}

