/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import eGTTIntegration.TTIntegrationWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import net.atos.esb.schemas.common.AuthenticationType;
import net.atos.esb.schemas.common.HeaderBaseType;
import net.atos.esb.schemas.common.HeaderOptionalDestinationType;
import net.atos.esb.schemas.common.ReturnType;
import net.atos.esb.schemas.event.ConfigItemIDType;
import net.atos.esb.schemas.event.ConfigItemIDTypeEnumType;
import net.atos.esb.schemas.event.EventClassType;
import net.atos.esb.schemas.event.EventKeyType;
import net.atos.esb.schemas.event.EventResolveType;
import net.atos.esb.schemas.event.EventTimeType;
import net.atos.esb.schemas.event.EventType;
import net.atos.esb.schemas.event.EventTypeEnumType;
import net.atos.esb.schemas.event.StatusNotificationSubscriptionEnumType;
import net.atos.esb.schemas.event.TroubleTicketPriorityEnumType;
import net.atos.esb.schemas.event.TroubleTicketType;
import net.atos.esb.wsdl.esbeventservice.CreateEventFault;
import net.atos.esb.wsdl.esbeventservice.ResolveEventFault;
import net.atos.esb.wsdl.esbeventservice.ServiceEventManagemen;
import net.atos.esb.wsdl.esbeventservice.ServiceEventManagemen_Service;

public class ATFIntegrator
extends TTIntegrationWrapper {
    private String alarmDateFormat;
    private EgDateInfo date;
    private HashSet testAndMeasure_hs;
    private String DefaultDescFormat;
    private String WS_EndpointURLLocation;
    private String WS_ServiceName;
    private String availabilityMeasureStr;
    private String category;
    private String descriptionFormat;
    private String eventSender;
    private String eventSenderType;
    private String password;
    private String priorityForCritical;
    private String priorityForMajor;
    private String priorityForMinor;
    private String statusForAbnormal;
    private String statusForNormal;
    private String statusNotificationSubscription;
    private String strAuthKey;
    private String summaryFormat;
    private String targetNamespace;
    private String userName;
    private String workGroup;
    private String timeoutStr;
    private int MAX_DESC_SIZE;
    private int MAX_TITLE_SIZE;
    private int timeout;
    private static QName qName = null;
    private static String ENDPOINT_URL = "";
    private static String WSDL_URL = "";

    public ATFIntegrator(Hashtable hashtable) {
        block2: {
            this.alarmDateFormat = "MMM dd, yyyy HH:mm:ss";
            this.date = new EgDateInfo();
            this.testAndMeasure_hs = null;
            this.DefaultDescFormat = " Priority :$prior  Component : $cname  Component  Type : $ctype  Layer : $layer  Problem  Description : $pdesc";
            this.WS_EndpointURLLocation = null;
            this.WS_ServiceName = "";
            this.availabilityMeasureStr = "";
            this.category = "";
            this.descriptionFormat = "";
            this.eventSender = "";
            this.eventSenderType = "";
            this.password = "";
            this.priorityForCritical = "";
            this.priorityForMajor = "";
            this.priorityForMinor = "";
            this.statusForAbnormal = "Active";
            this.statusForNormal = "Resolved";
            this.statusNotificationSubscription = "";
            this.strAuthKey = "";
            this.summaryFormat = "$prior - $ctype / $cname  - $pdesc";
            this.targetNamespace = "";
            this.userName = "";
            this.workGroup = "";
            this.timeoutStr = "";
            this.MAX_DESC_SIZE = 1024;
            this.MAX_TITLE_SIZE = 255;
            this.timeout = 60000;
            try {
                this.setGlobalValues(hashtable);
            }
            catch (Throwable throwable) {
                if (!this.logEnabled) break block2;
                this.sop("ERROR: Got an exception, while setting Global Values in ATF Integrator" + throwable.getMessage());
            }
        }
    }

    public void updateInitParams(Hashtable hashtable) {
        this.setGlobalValues(hashtable);
    }

    public void setGlobalValues(Hashtable hashtable) {
        WSDL_URL = (String)hashtable.get("wsdl_url");
        this.userName = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.eventSender = (String)hashtable.get("eventSender");
        this.eventSenderType = (String)hashtable.get("eventSenderType");
        this.workGroup = (String)hashtable.get("workGroup");
        this.category = (String)hashtable.get("category");
        this.summaryFormat = (String)hashtable.get("ticketTitleFormat");
        this.descriptionFormat = (String)hashtable.get("DescriptionFormat");
        this.targetNamespace = (String)hashtable.get("WSDL_targetNamespace");
        this.WS_ServiceName = (String)hashtable.get("WSDL_ServiceName");
        this.WS_EndpointURLLocation = (String)hashtable.get("WSDL_EndpointURLLocation");
        this.availabilityMeasureStr = (String)hashtable.get("AvailabilityMeasureList");
        this.statusNotificationSubscription = (String)hashtable.get("statusNotificationSubscription");
        this.timeoutStr = (String)hashtable.get("timeout");
        if (this.timeoutStr != null && !this.timeoutStr.equals("")) {
            try {
                this.timeout = Integer.parseInt(this.timeoutStr);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.statusNotificationSubscription == null || this.statusNotificationSubscription.trim().length() == 0) {
            this.statusNotificationSubscription = "NEVER";
        }
        String string = (String)hashtable.get("titleLength");
        String string2 = (String)hashtable.get("descriptionLength");
        if (string == null || string.length() == 0) {
            string = "255";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "4000";
        }
        try {
            this.MAX_TITLE_SIZE = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.MAX_TITLE_SIZE = 255;
        }
        try {
            this.MAX_DESC_SIZE = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.MAX_DESC_SIZE = 4000;
        }
        this.setGlobalValuesForPriority(hashtable);
        if (this.targetNamespace == null || this.targetNamespace.length() == 0) {
            this.targetNamespace = "http://esb.atos.net/wsdl/ESBEventService";
        }
        if (this.WS_ServiceName == null || this.WS_ServiceName.length() == 0) {
            this.WS_ServiceName = "ServiceEventManagemen";
        }
        if (WSDL_URL != null && WSDL_URL.indexOf("?") > -1) {
            ENDPOINT_URL = WSDL_URL.substring(0, WSDL_URL.indexOf("?"));
            if (this.WS_EndpointURLLocation == null) {
                this.WS_EndpointURLLocation = ENDPOINT_URL + "?SOAP";
            }
        } else if (this.logEnabled) {
            this.sop("ERROR: Invalid WSDL URL: " + WSDL_URL);
        }
        qName = new QName(this.targetNamespace, this.WS_ServiceName);
        if (this.availabilityMeasureStr != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.availabilityMeasureStr, ",");
            this.testAndMeasure_hs = new HashSet();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                string3 = string3.trim();
                this.testAndMeasure_hs.add(string3);
            }
        }
    }

    public void setGlobalValuesForPriority(Hashtable hashtable) {
        if (hashtable != null) {
            this.priorityForCritical = (String)hashtable.get("priorityForCritical");
            this.priorityForMajor = (String)hashtable.get("priorityForMajor");
            this.priorityForMinor = (String)hashtable.get("priorityForMinor");
        }
        this.priorityForCritical = this.priorityForCritical != null && this.priorityForCritical.trim().length() > 0 ? this.priorityForCritical : "High";
        this.priorityForMajor = this.priorityForMajor != null && this.priorityForMajor.trim().length() > 0 ? this.priorityForMajor : "Medium";
        this.priorityForMinor = this.priorityForMinor != null && this.priorityForMinor.trim().length() > 0 ? this.priorityForMinor : "Medium";
    }

    public void setGlobalValuesForStatus(Hashtable hashtable) {
        if (hashtable != null) {
            this.statusForAbnormal = (String)hashtable.get("statusForAbnormal");
            this.statusForNormal = (String)hashtable.get("statusForNormal");
        }
        this.statusForAbnormal = this.statusForAbnormal != null && this.statusForAbnormal.trim().length() > 0 ? this.statusForAbnormal : "Active";
        this.statusForNormal = this.statusForNormal != null && this.statusForNormal.trim().length() > 0 ? this.statusForNormal : "Resolved";
    }

    public String createTicket(Object[] objectArray) throws IOException {
        String string = "";
        String string2 = "";
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            ReturnType returnType;
            String string3;
            Object object;
            Serializable serializable;
            String string4 = "";
            String string5 = "";
            Hashtable hashtable = null;
            String string6 = "";
            String string7 = (String)objectArray[0];
            String string8 = (String)objectArray[2];
            String string9 = (String)objectArray[3];
            String string10 = (String)objectArray[4];
            String string11 = (String)objectArray[5];
            String string12 = (String)objectArray[6];
            String string13 = (String)objectArray[7];
            String string14 = (String)objectArray[8];
            String string15 = (String)objectArray[9];
            String string16 = (String)objectArray[11];
            String string17 = (String)objectArray[12];
            String string18 = (String)objectArray[13];
            String string19 = (String)objectArray[14];
            try {
                serializable = new SimpleDateFormat(this.alarmDateFormat);
                if (this.date != null && serializable != null) {
                    ATFIntegrator aTFIntegrator = this;
                    ((DateFormat)serializable).setTimeZone(aTFIntegrator.date.getTimeZone());
                    object = ((DateFormat)serializable).parse(string19);
                    xMLGregorianCalendar = ATFIntegrator.dateToXMLGregorianCalendar((Date)object);
                }
            }
            catch (ParseException parseException) {
                System.out.println("[ATFIntegrator class] Got an ParseException while date parsing. Date:  Error msg: " + parseException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("[ATFIntegrator class] Got an Exception while date parsing. Date:  Error msg: " + exception.getMessage());
            }
            if (string10 != null && string10.indexOf(":") > -1) {
                string6 = string10.substring(0, string10.indexOf(":"));
            } else if (string10 != null) {
                string6 = string10;
            }
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(" Priority: ");
            ((StringBuffer)serializable).append(string7);
            ((StringBuffer)serializable).append(" Component Type: ");
            ((StringBuffer)serializable).append(string9);
            ((StringBuffer)serializable).append(" Component Name: ");
            ((StringBuffer)serializable).append(string10);
            ((StringBuffer)serializable).append(" Layer: ");
            ((StringBuffer)serializable).append(string11);
            ((StringBuffer)serializable).append(" Problem Description: ");
            ((StringBuffer)serializable).append(string12);
            string2 = ((StringBuffer)serializable).toString();
            hashtable = this.getFormattedData(objectArray);
            if (hashtable != null && !hashtable.isEmpty()) {
                string5 = (String)hashtable.get("summary");
                string4 = (String)hashtable.get("description");
            }
            object = this.getMappedPriority(string7);
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                }
            });
            ServiceEventManagemen_Service serviceEventManagemen_Service = new ServiceEventManagemen_Service(new URL(WSDL_URL), qName);
            ServiceEventManagemen serviceEventManagemen = serviceEventManagemen_Service.getEndpointSOAP11();
            Map map = ((BindingProvider)serviceEventManagemen).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", this.WS_EndpointURLLocation);
            map.put("com.sun.xml.ws.developer.JAXWSProperties.CONNECT_TIMEOUT", new Integer(this.timeout));
            map.put("com.sun.xml.ws.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.internal.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.request.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.internal.ws.request.timeout", new Integer(this.timeout));
            AuthenticationType authenticationType = new AuthenticationType();
            authenticationType.setUserName(this.userName);
            authenticationType.setPassword(this.password);
            HeaderBaseType headerBaseType = new HeaderBaseType();
            headerBaseType.setAuthentication(authenticationType);
            EventKeyType eventKeyType = new EventKeyType();
            eventKeyType.setEventID(string15);
            eventKeyType.setEventSender(this.eventSender);
            HeaderOptionalDestinationType headerOptionalDestinationType = new HeaderOptionalDestinationType();
            headerOptionalDestinationType.setAuthentication(authenticationType);
            String string20 = string15 + "#" + string7 + "#" + string10;
            EventClassType eventClassType = new EventClassType();
            eventClassType.setEventClass(string20);
            eventClassType.setEventSenderType(this.eventSenderType);
            eventClassType.setEventHostname(string10);
            eventClassType.setEventMessageText(string4);
            if (this.isEventRelatedtoAvailabilityMeasure(string16)) {
                eventClassType.setEventType(EventTypeEnumType.AVAILABILITY);
            } else {
                eventClassType.setEventType(EventTypeEnumType.PERFORMANCE);
            }
            eventClassType.setEventSeverity(string7);
            HashMap hashMap = this.searchForCIInfo(string6);
            String string21 = "";
            String string22 = "CIID";
            String string23 = "";
            if (hashMap != null) {
                string21 = (String)hashMap.get("id");
                string22 = (String)hashMap.get("idType");
                string23 = (String)hashMap.get("configItemSource");
            }
            ConfigItemIDType configItemIDType = new ConfigItemIDType();
            configItemIDType.setIdType(ConfigItemIDTypeEnumType.valueOf((String)string22));
            configItemIDType.setConfigItemSource(string23);
            configItemIDType.setId(string21);
            XMLGregorianCalendar xMLGregorianCalendar2 = ATFIntegrator.dateToXMLGregorianCalendar(new Date());
            EventTimeType eventTimeType = new EventTimeType();
            eventTimeType.setTimeOccured(xMLGregorianCalendar);
            eventTimeType.setTimeSent(xMLGregorianCalendar2);
            TroubleTicketType troubleTicketType = new TroubleTicketType();
            if (!(this.category == null || this.category.trim().equalsIgnoreCase("$unconfigured") || this.category.trim().equalsIgnoreCase("none") || this.category.trim().equals(""))) {
                troubleTicketType.setCategory(this.category);
            }
            if (!(this.workGroup == null || this.workGroup.trim().equalsIgnoreCase("$unconfigured") || this.workGroup.trim().equalsIgnoreCase("none") || this.workGroup.trim().equals(""))) {
                troubleTicketType.setWorkgroup(this.workGroup);
            }
            if ((string3 = this.getMappedPriority(string7)) != null && (string3.trim().equalsIgnoreCase("High") || string3.trim().equalsIgnoreCase("Medium"))) {
                troubleTicketType.setPriority(TroubleTicketPriorityEnumType.fromValue((String)string3.trim()));
            }
            EventType eventType = new EventType();
            eventType.setEventClass(eventClassType);
            eventType.setEventKey(eventKeyType);
            eventType.setEventTime(eventTimeType);
            eventType.setConfigItemID(configItemIDType);
            eventType.setTroubleTicket(troubleTicketType);
            Holder holder = new Holder();
            holder.value = headerOptionalDestinationType;
            if (!(this.statusNotificationSubscription == null || this.statusNotificationSubscription.trim().equals("ALWAYS") || this.statusNotificationSubscription.trim().equals("RESOLVE") || this.statusNotificationSubscription.trim().equals("NEVER"))) {
                this.statusNotificationSubscription = "NEVER";
            }
            if ((returnType = serviceEventManagemen.createEvent(holder, StatusNotificationSubscriptionEnumType.fromValue((String)this.statusNotificationSubscription.trim()), eventType)) != null) {
                String string24 = returnType.getReturnCode();
                if (string24 != null && (string24.equalsIgnoreCase("SIA-0000") || string24.equalsIgnoreCase("SIA-0004") || string24.equalsIgnoreCase("SIA-0006"))) {
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket has been created successfully...  Ticket Details-> Ticket Number: " + returnType.getDetail() + " Event ID: " + string15 + " " + string2);
                    }
                    string = string15;
                } else if (this.logEnabled) {
                    this.sop("Error: Ticket creation got failed with following ReturnCode :: " + string24 + " Details: " + returnType.getDetail() + " Ticket Details->  " + string2);
                }
            }
        }
        catch (CreateEventFault createEventFault) {
            ReturnType returnType = createEventFault.getFaultInfo();
            if (this.logEnabled) {
                this.sop("Error: Ticket creation got failed with following error message :: ReturnCode: " + returnType.getReturnCode() + " Details: " + returnType.getDetail());
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("Error: Ticket creation got failed with following error message :: " + throwable.getMessage());
            }
            throwable.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTicket(String string, Object[] objectArray) throws IOException {
        Date date;
        SimpleDateFormat simpleDateFormat;
        Object var3_3 = null;
        String string2 = "update";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        XMLGregorianCalendar xMLGregorianCalendar = null;
        boolean bl = false;
        boolean bl2 = false;
        String string7 = (String)objectArray[0];
        Object object = (String)objectArray[2];
        String string8 = (String)objectArray[3];
        String string9 = (String)objectArray[4];
        String string10 = (String)objectArray[5];
        String string11 = (String)objectArray[6];
        String string12 = (String)objectArray[7];
        String string13 = (String)objectArray[8];
        String string14 = (String)objectArray[9];
        String string15 = (String)objectArray[14];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Priority: ");
        stringBuffer.append(string7);
        stringBuffer.append(" Component Type: ");
        stringBuffer.append(string8);
        stringBuffer.append(" Component Name: ");
        stringBuffer.append(string9);
        stringBuffer.append(" Layer: ");
        stringBuffer.append(string10);
        stringBuffer.append(" Problem Description: ");
        stringBuffer.append(string11);
        string6 = stringBuffer.toString();
        try {
            simpleDateFormat = new SimpleDateFormat(this.alarmDateFormat);
            if (this.date != null && simpleDateFormat != null) {
                ATFIntegrator aTFIntegrator = this;
                simpleDateFormat.setTimeZone(aTFIntegrator.date.getTimeZone());
                date = simpleDateFormat.parse(string15);
                xMLGregorianCalendar = ATFIntegrator.dateToXMLGregorianCalendar(date);
            }
        }
        catch (ParseException parseException) {
            System.out.println("[ATFIntegrator class] Got an ParseException while date parsing. Date:  Error msg: " + parseException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("[ATFIntegrator class] Got an Exception while date parsing. Date:  Error msg: " + exception.getMessage());
        }
        if (string7 == null || !string7.equalsIgnoreCase("Normal")) {
            if (this.logEnabled) {
                this.sop("INFO: Ticket updation got skipped(since ATF REST API is not supporting update action). Details-> Event ID: " + string + " " + string6);
            }
            boolean bl3 = false;
            return bl3;
        }
        bl = true;
        string2 = "resolve";
        try {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ATFIntegrator.this.userName, ATFIntegrator.this.password.toCharArray());
                }
            });
            simpleDateFormat = new ServiceEventManagemen_Service(new URL(WSDL_URL), qName);
            date = simpleDateFormat.getEndpointSOAP11();
            Map map = ((BindingProvider)date).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", this.WS_EndpointURLLocation);
            map.put("com.sun.xml.ws.developer.JAXWSProperties.CONNECT_TIMEOUT", new Integer(this.timeout));
            map.put("com.sun.xml.ws.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.internal.connect.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.ws.request.timeout", new Integer(this.timeout));
            map.put("com.sun.xml.internal.ws.request.timeout", new Integer(this.timeout));
            AuthenticationType authenticationType = new AuthenticationType();
            authenticationType.setUserName(this.userName);
            authenticationType.setPassword(this.password);
            HeaderBaseType headerBaseType = new HeaderBaseType();
            headerBaseType.setAuthentication(authenticationType);
            EventKeyType eventKeyType = new EventKeyType();
            eventKeyType.setEventID(string);
            eventKeyType.setEventSender(this.eventSender);
            HeaderOptionalDestinationType headerOptionalDestinationType = new HeaderOptionalDestinationType();
            headerOptionalDestinationType.setAuthentication(authenticationType);
            XMLGregorianCalendar xMLGregorianCalendar2 = ATFIntegrator.dateToXMLGregorianCalendar(new Date());
            EventTimeType eventTimeType = new EventTimeType();
            eventTimeType.setTimeOccured(xMLGregorianCalendar);
            eventTimeType.setTimeSent(xMLGregorianCalendar2);
            EventResolveType eventResolveType = new EventResolveType();
            eventResolveType.setEventKey(eventKeyType);
            eventResolveType.setEventTime(eventTimeType);
            Holder holder = new Holder();
            holder.value = headerOptionalDestinationType;
            ReturnType returnType = date.resolveEvent(holder, eventResolveType);
            if (returnType != null) {
                if (returnType.getReturnCode().equalsIgnoreCase("SIA-0000")) {
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket has been resolved successfully...  Ticket Details-> Ticket Number: " + returnType.getDetail() + " Event ID: " + string + " " + string6);
                    }
                    bl2 = true;
                } else if (this.logEnabled) {
                    this.sop("Error: Failed to resolve the Ticket with following ReturnCode :: " + returnType.getReturnCode() + " Detail: " + returnType.getDetail() + " Ticket Details->  " + string6);
                }
            }
        }
        catch (ResolveEventFault resolveEventFault) {
            object = resolveEventFault.getFaultInfo();
            if (this.logEnabled) {
                this.sop("Error: Failed to resolve ticket. with following error message :: ReturnCode: " + object.getReturnCode() + " Event ID: " + string + " Details: " + object.getDetail());
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR: Failed to resolve ticket. with following error message :: " + throwable.getMessage() + " Ticket Details->  Event ID: " + string + " " + string6);
            }
            throwable.printStackTrace();
        }
        return bl2;
    }

    private String getMappedPriority(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = this.priorityForCritical;
            } else if (string.equalsIgnoreCase("Major")) {
                string = this.priorityForMajor;
            } else if (string.equalsIgnoreCase("Minor")) {
                string = this.priorityForMinor;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getFormattedData(Object[] objectArray) {
        String string = "";
        Hashtable<String, String> hashtable = null;
        String string2 = (String)objectArray[0];
        String string3 = (String)objectArray[2];
        String string4 = (String)objectArray[3];
        String string5 = (String)objectArray[4];
        String string6 = (String)objectArray[5];
        String string7 = (String)objectArray[6];
        String string8 = (String)objectArray[7];
        String string9 = (String)objectArray[8];
        try {
            hashtable = new Hashtable<String, String>();
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("description", this.descriptionFormat);
            } else {
                hashtable.put("description", this.DefaultDescFormat);
            }
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("summary", this.summaryFormat);
            } else {
                hashtable.put("summary", string7);
            }
            if (hashtable != null && !hashtable.isEmpty()) {
                Set set = hashtable.keySet();
                for (String string10 : set) {
                    string = (String)hashtable.get(string10);
                    if (string10 == null || string == null) continue;
                    if (string.indexOf("$cname") > -1) {
                        string = this.replace(string, "$cname", string5);
                    }
                    if (string.indexOf("$ctype") > -1) {
                        string = this.replace(string, "$ctype", string4);
                    }
                    if (string.indexOf("$prior") > -1) {
                        string = this.replace(string, "$prior", string2);
                    }
                    if (string.indexOf("$pdesc") > -1) {
                        string = this.replace(string, "$pdesc", string7);
                    }
                    if (string.indexOf("$layer") > -1) {
                        string = this.replace(string, "$layer", string6);
                    }
                    if (string.indexOf("$starttime") > -1) {
                        string = this.replace(string, "$starttime", string8);
                    }
                    if (string.indexOf("$Service") > -1) {
                        string = this.replace(string, "$Service", string3);
                    }
                    if (string.indexOf("$user") > -1) {
                        string = this.replace(string, "$user", string9);
                    }
                    if (string10.equalsIgnoreCase("summary")) {
                        if (string.length() > this.MAX_TITLE_SIZE) {
                            string = string.substring(0, this.MAX_TITLE_SIZE - 4);
                            string = string + "...";
                        }
                    } else if (string10.equalsIgnoreCase("description") && string.length() > this.MAX_DESC_SIZE) {
                        string = string.substring(0, this.MAX_DESC_SIZE - 4);
                        string = string + "...";
                    }
                    hashtable.put(string10, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                return hashtable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    protected boolean isEventRelatedtoAvailabilityMeasure(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Hashtable hashtable = new Hashtable();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "|");
            if (stringTokenizer2.countTokens() < 4) continue;
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer2.nextToken();
            String string6 = stringTokenizer2.nextToken();
            String string7 = string5 + ":" + string6;
            if (this.testAndMeasure_hs == null || !this.testAndMeasure_hs.contains(string7)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public HashMap searchForCIInfo(String string) {
        HashMap<String, String> hashMap = null;
        String string2 = "#";
        String string3 = "ATF_CI_MAPPING";
        String string4 = System.getProperty("file.separator");
        String string5 = EgInstallInfo.getInstallDir() + string4 + "manager" + string4 + "config" + string4 + "eg_tt_ci_mapping.ini";
        File file = new File(string5);
        IniFile iniFile = new IniFile(string5);
        String string6 = iniFile.getValue(string3, string);
        hashMap = new HashMap<String, String>();
        String string7 = "";
        if (string6 != null && !string6.trim().equals("")) {
            if (string6.indexOf(string2) > -1) {
                String string8 = string6.substring(0, string6.indexOf(string2));
                String string9 = string6.substring(string6.indexOf(string2) + 1);
                hashMap.put("id", string8);
                if (string9 != null && string9.indexOf(string2) > -1) {
                    String string10 = string9.substring(0, string9.indexOf(string2));
                    string7 = string9.substring(string9.indexOf(string2) + 1);
                    string9 = string10;
                }
                hashMap.put("idType", string9);
                hashMap.put("configItemSource", string7);
            } else {
                hashMap.put("id", "");
                hashMap.put("idType", "CIID");
                hashMap.put("configItemSource", "");
            }
        } else {
            System.out.println("[ATFIntegrator class] INFO: CI entry is not found for component name [" + string + "] in eg_tt_ci_mapping.ini ");
            hashMap.put("id", "");
            hashMap.put("idType", "CIID");
            hashMap.put("configItemSource", "");
        }
        return hashMap;
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date) {
        String string = "UTC";
        TimeZone timeZone = TimeZone.getTimeZone(string);
        XMLGregorianCalendar xMLGregorianCalendar = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.setTimeZone(timeZone);
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (Exception exception) {
            System.out.println("[ATFIntegrator class]Exception in conversion of Date to XMLGregorianCalendar" + exception.getMessage());
        }
        return xMLGregorianCalendar;
    }
}

