/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.jsp.indexer.parser;

public class TokenMgrError
extends Error {
    public static final int LEXICAL_ERROR = 0;
    public static final int STATIC_LEXER_ERROR = 1;
    public static final int INVALID_LEXICAL_STATE = 2;
    public static final int LOOP_DETECTED = 3;
    int errorCode;

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(TokenMgrError.lexicalError(EOFSeen, errorLine, errorColumn, errorAfter, curChar), reason);
    }

    protected static final String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }

    private static final String lexicalError(boolean EOFSeen, int errorLine, int errorColumn, String errorAfter, char curChar) {
        StringBuffer sb = new StringBuffer();
        sb.append("Lexical error at line ");
        sb.append(errorLine);
        sb.append(", column ");
        sb.append(errorColumn);
        sb.append(".  Encountered: ");
        sb.append(EOFSeen ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(curChar)) + "\"" + " (" + curChar + "), ");
        sb.append("after : \"");
        sb.append(TokenMgrError.addEscapes(errorAfter));
        sb.append("\"");
        return sb.toString();
    }
}

