/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.jsp.indexer;

import com.egurkha.jsp.indexer.parser.PagerTagExport;
import com.egurkha.jsp.indexer.parser.ParseException;
import com.egurkha.jsp.indexer.parser.TagExportParser;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public final class PagerTag
extends TagSupport {
    public static final String DEFAULT_ID = "indexer";
    private static final int DEFAULT_MAX_ITEMS = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_PAGE_ITEMS = 10;
    private static final int DEFAULT_MAX_INDEX_PAGES = 10;
    public static final String OFFSET_PARAM = "offset";
    public static final String PAGE = "page";
    public static final String REQUEST = "request";
    public static final String CENTER = "center";
    public static final String FORWARD = "forward";
    public static final String HALF_FULL = "half-full";
    private String url = null;
    private String index = null;
    private int items = 0;
    private int maxItems = Integer.MAX_VALUE;
    private int maxPageItems = 10;
    private int maxIndexPages = 10;
    private boolean isOffset = false;
    private String export = null;
    private String scope = null;
    private StringBuffer uri = null;
    private int params = 0;
    private int offset = 0;
    private int itemCount = 0;
    private int pageNumber = 0;
    private Integer pageNumberInteger = null;
    private String idOffsetParam = "indexeroffset";
    private PagerTagExport pagerTagExport = null;
    private Object oldPager = null;
    private Object oldOffset = null;
    private Object oldPageNumber = null;

    public PagerTag() {
        this.id = DEFAULT_ID;
    }

    public final void setId(String sid) {
        super.setId(sid);
        this.idOffsetParam = String.valueOf(sid) + OFFSET_PARAM;
    }

    public final void setUrl(String value) {
        this.url = value;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setIndex(String val) throws JspException {
        if (!(val == null || CENTER.equals(val) || FORWARD.equals(val) || HALF_FULL.equals(val))) {
            throw new JspTagException("value for attribute \"index\" must be either \"center\", \"forward\" or \"half-full\".");
        }
        this.index = val;
    }

    public final String getIndex() {
        return this.index;
    }

    public final void setItems(int value) {
        this.items = value;
    }

    public final int getItems() {
        return this.items;
    }

    public final void setMaxItems(int value) {
        this.maxItems = value;
    }

    public final int getMaxItems() {
        return this.maxItems;
    }

    public final void setMaxPageItems(int value) {
        this.maxPageItems = value;
    }

    public final int getMaxPageItems() {
        return this.maxPageItems;
    }

    public final void setMaxIndexPages(int value) {
        this.maxIndexPages = value;
    }

    public final int getMaxIndexPages() {
        return this.maxIndexPages;
    }

    public final void setIsOffset(boolean val) {
        this.isOffset = val;
    }

    public final boolean getIsOffset() {
        return this.isOffset;
    }

    public final void setExport(String value) throws JspException {
        if (this.export != value) {
            try {
                this.pagerTagExport = TagExportParser.parsePagerTagExport(value);
            }
            catch (ParseException ex) {
                throw new JspTagException(ex.getMessage());
            }
        }
        this.export = value;
    }

    public final String getExport() {
        return this.export;
    }

    public final void setScope(String val) throws JspException {
        if (val != null && !PAGE.equals(val) && !REQUEST.equals(val)) {
            throw new JspTagException("value for attribute \"scope\" must be either \"page\" or \"request\".");
        }
        this.scope = val;
    }

    public final String getScope() {
        return this.scope;
    }

    final void addParam(String name, String value) {
        if (value != null) {
            name = URLEncoder.encode(name);
            value = URLEncoder.encode(value);
            this.uri.append(this.params == 0 ? (char)'?' : '&').append(name).append('=').append(value);
            ++this.params;
        } else {
            String[] values = this.pageContext.getRequest().getParameterValues(name);
            if (values != null) {
                name = URLEncoder.encode(name);
                int i = 0;
                int l = values.length;
                while (i < l) {
                    value = URLEncoder.encode(values[i]);
                    this.uri.append(this.params == 0 ? (char)'?' : '&').append(name).append('=').append(value);
                    ++this.params;
                    ++i;
                }
            }
        }
    }

    final boolean nextItem() {
        boolean showItem = false;
        if (this.itemCount < this.maxItems) {
            showItem = this.itemCount >= this.offset && this.itemCount < this.offset + this.maxPageItems;
            ++this.itemCount;
        }
        return showItem;
    }

    final int getOffset() {
        return this.offset;
    }

    final boolean isIndexNeeded() {
        return this.offset != 0 || this.getItemCount() > this.maxPageItems;
    }

    final boolean hasPrevPage() {
        return this.offset > 0;
    }

    final boolean hasNextPage() {
        return this.getItemCount() > this.getNextOffset();
    }

    final boolean hasPage(int page) {
        return page >= 0 && this.getItemCount() > page * this.maxPageItems;
    }

    final int getPrevOffset() {
        return Math.max(0, this.offset - this.maxPageItems);
    }

    final int getNextOffset() {
        return this.offset + this.maxPageItems;
    }

    final String getOffsetUrl(int pageOffset) {
        int uriLen = this.uri.length();
        this.uri.append(this.params == 0 ? (char)'?' : '&').append(this.idOffsetParam).append('=').append(pageOffset);
        String offsetUrl = this.uri.toString();
        this.uri.setLength(uriLen);
        return offsetUrl;
    }

    final String getPageUrl(int i) {
        return this.getOffsetUrl(this.maxPageItems * i);
    }

    final Integer getOffsetPageNumber(int pageOffset) {
        return new Integer(1 + this.pageNumber(pageOffset));
    }

    final Integer getPageNumber(int i) {
        if (i == this.pageNumber) {
            return this.pageNumberInteger;
        }
        return new Integer(1 + i);
    }

    final int getPageNumber() {
        return this.pageNumber;
    }

    final int getPageCount() {
        return this.pageNumber(this.getItemCount());
    }

    final int getFirstIndexPage() {
        int indexPages;
        int pages;
        int firstPage = 0;
        int halfIndexPages = this.maxIndexPages / 2;
        if (FORWARD.equals(this.index)) {
            firstPage = Math.min(this.pageNumber + 1, this.getPageCount());
        } else if (!(HALF_FULL.equals(this.index) && this.pageNumber < halfIndexPages || (pages = this.getPageCount()) <= this.maxIndexPages || (indexPages = pages - (firstPage = Math.max(0, this.pageNumber - halfIndexPages))) >= this.maxIndexPages)) {
            firstPage -= this.maxIndexPages - indexPages;
        }
        return firstPage;
    }

    final int getLastIndexPage(int firstPage) {
        int pages = this.getPageCount();
        int halfIndexPages = this.maxIndexPages / 2;
        int maxPages = HALF_FULL.equals(this.index) && this.pageNumber < halfIndexPages ? this.pageNumber + halfIndexPages : firstPage + this.maxIndexPages;
        return (pages <= maxPages ? pages : maxPages) - 1;
    }

    final int getItemCount() {
        return this.items != 0 ? this.items : this.itemCount;
    }

    private final int pageNumber(int offset) {
        return offset / this.maxPageItems + (offset % this.maxPageItems == 0 ? 0 : 1);
    }

    public int doStartTag() throws JspException {
        String baseUri;
        if (this.url != null) {
            baseUri = this.url;
        } else {
            baseUri = ((HttpServletRequest)this.pageContext.getRequest()).getRequestURI();
            int i = baseUri.indexOf(63);
            if (i != -1) {
                baseUri = baseUri.substring(0, i);
            }
        }
        if (this.uri == null) {
            this.uri = new StringBuffer(baseUri.length() + 32);
        } else {
            this.uri.setLength(0);
        }
        this.uri.append(baseUri);
        this.params = 0;
        this.offset = 0;
        this.itemCount = 0;
        String offsetParam = this.pageContext.getRequest().getParameter(this.idOffsetParam);
        if (offsetParam != null) {
            try {
                this.offset = Math.max(0, Integer.parseInt(offsetParam));
                if (this.isOffset) {
                    this.itemCount = this.offset;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pageNumber = this.pageNumber(this.offset);
        this.pageNumberInteger = new Integer(1 + this.pageNumber);
        if (REQUEST.equals(this.scope)) {
            ServletRequest request = this.pageContext.getRequest();
            this.oldPager = request.getAttribute(this.id);
            request.setAttribute(this.id, (Object)this);
            if (this.pagerTagExport != null) {
                String name = this.pagerTagExport.getPageOffset();
                if (name != null) {
                    this.oldOffset = request.getAttribute(name);
                    request.setAttribute(name, (Object)new Integer(this.offset));
                }
                if ((name = this.pagerTagExport.getPageNumber()) != null) {
                    this.oldPageNumber = request.getAttribute(name);
                    request.setAttribute(name, (Object)this.pageNumberInteger);
                }
            }
        } else if (this.pagerTagExport != null) {
            String name = this.pagerTagExport.getPageOffset();
            if (name != null) {
                this.oldOffset = this.pageContext.getAttribute(name);
                this.pageContext.setAttribute(name, (Object)new Integer(this.offset));
            }
            if ((name = this.pagerTagExport.getPageNumber()) != null) {
                this.oldPageNumber = this.pageContext.getAttribute(name);
                this.pageContext.setAttribute(name, (Object)this.pageNumberInteger);
            }
        }
        return 1;
    }

    private static void restoreAttribute(ServletRequest request, String name, Object oldValue) {
        if (oldValue != null) {
            request.setAttribute(name, oldValue);
        } else {
            request.removeAttribute(name);
        }
    }

    private static void restoreAttribute(PageContext pageContext, String name, Object oldValue) {
        if (oldValue != null) {
            pageContext.setAttribute(name, oldValue);
        } else {
            pageContext.removeAttribute(name);
        }
    }

    public int doEndTag() throws JspException {
        if (REQUEST.equals(this.scope)) {
            ServletRequest request = this.pageContext.getRequest();
            PagerTag.restoreAttribute(request, this.id, this.oldPager);
            this.oldPager = null;
            if (this.pagerTagExport != null) {
                String name = this.pagerTagExport.getPageOffset();
                if (name != null) {
                    PagerTag.restoreAttribute(request, name, this.oldOffset);
                    this.oldOffset = null;
                }
                if ((name = this.pagerTagExport.getPageNumber()) != null) {
                    PagerTag.restoreAttribute(request, name, this.oldPageNumber);
                    this.oldPageNumber = null;
                }
            }
        } else if (this.pagerTagExport != null) {
            String name = this.pagerTagExport.getPageOffset();
            if (name != null) {
                PagerTag.restoreAttribute(this.pageContext, name, this.oldOffset);
                this.oldOffset = null;
            }
            if ((name = this.pagerTagExport.getPageNumber()) != null) {
                PagerTag.restoreAttribute(this.pageContext, name, this.oldPageNumber);
                this.oldPageNumber = null;
            }
        }
        if (this.uri.capacity() > 1024) {
            this.uri = null;
        }
        this.pageNumberInteger = null;
        return 6;
    }

    public void release() {
        this.url = null;
        this.index = null;
        this.items = 0;
        this.maxItems = Integer.MAX_VALUE;
        this.maxPageItems = 10;
        this.maxIndexPages = 10;
        this.isOffset = false;
        this.export = null;
        this.scope = null;
        this.uri = null;
        this.params = 0;
        this.offset = 0;
        this.itemCount = 0;
        this.pageNumber = 0;
        this.pageNumberInteger = null;
        this.idOffsetParam = "indexeroffset";
        this.pagerTagExport = null;
        this.oldPager = null;
        this.oldOffset = null;
        this.oldPageNumber = null;
        super.release();
    }
}

