/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

class IfxBoolean
extends IfxBaseType {
    boolean value;
    public static final byte IFX_BOOL_NULL = -1;

    IfxBoolean() throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
    }

    IfxBoolean(boolean bl) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = bl;
    }

    IfxBoolean(Boolean bl) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = bl;
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        super.fromIfx(byArray, n, n2);
        if (!this.isNull()) {
            byte by = this.inputStream.readByte();
            if (by == 1) {
                this.value = true;
            } else if (by == 0) {
                this.value = false;
            } else if (by == -1) {
                this.nullify();
            }
        }
    }

    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            byte by = this.value ? (byte)1 : 0;
            this.outputStream.writeByte(by);
        }
        return super.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        byte[] byArray;
        if (this.isNull()) {
            byArray = new byte[5];
            memoryUtil.byfill(byArray, (byte)0);
            byArray[0] = 1;
        } else {
            byArray = new byte[6];
            byArray[0] = 0;
            byte[] byArray2 = this.toIfx();
            int n = 0;
            while (n < byArray2.length) {
                byArray[n + 1] = byArray2[n];
                ++n;
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxBoolean)) {
            return false;
        }
        IfxBoolean ifxBoolean = (IfxBoolean)object;
        if (ifxBoolean.isNull()) {
            return false;
        }
        return this.value == ifxBoolean.value;
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.value);
    }

    public short toShort() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    public void fromShort(short s) throws SQLException {
        this.value = s == 1;
        this.unnullify();
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.toInt();
    }

    public void fromDouble(double d2) throws SQLException {
        this.value = d2 == 1.0;
        this.unnullify();
    }

    public void fromDouble(Double d2) throws SQLException {
        if (d2 == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d2);
        }
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.toInt();
    }

    public void fromFloat(float f2) throws SQLException {
        this.value = (double)f2 == 1.0;
        this.unnullify();
    }

    public void fromFloat(Float f2) throws SQLException {
        if (f2 == null) {
            this.nullify();
        } else {
            this.fromFloat(f2.floatValue());
        }
    }

    public int toInt() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    public void fromInt(int n) throws SQLException {
        this.value = n == 1;
        this.unnullify();
    }

    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0L;
        }
        return 1L;
    }

    public void fromLong(long l) throws SQLException {
        this.value = l == 1L;
        this.unnullify();
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
            this.unnullify();
        }
    }

    public void fromByte(byte by) throws SQLException {
        if (by == 255) {
            this.nullify();
        } else {
            this.value = by == 1;
            this.unnullify();
        }
    }

    public void fromByte(Byte by) throws SQLException {
        this.fromByte((byte)by);
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value;
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl;
        this.unnullify();
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
        }
    }

    public void fromDecimal(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            this.value = bigDecimal.compareTo(new BigDecimal("1")) == 0;
            this.unnullify();
        } else {
            this.nullify();
        }
    }

    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return new BigDecimal(1.0);
        }
        return new BigDecimal(0.0);
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "t";
        }
        return "f";
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true")) {
                this.value = true;
            } else if (string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("false")) {
                this.value = false;
            } else {
                throw IfxErrMsg.getSQLException(-79771, this.conn);
            }
            this.unnullify();
        }
    }
}

