/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.ServletContext;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.scanning.JarFileScanner;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderException;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderStack;

class WebAppResourcesScanner
implements ResourceFinder {
    private final ServletContext sc;
    private ResourceFinderStack resourceFinderStack = new ResourceFinderStack();
    private static String[] paths = new String[]{"/WEB-INF/lib/", "/WEB-INF/classes/"};

    WebAppResourcesScanner(ServletContext sc) {
        this.sc = sc;
        this.processPaths(paths);
    }

    private void processPaths(String ... paths) {
        String path;
        Set resourcePaths;
        String[] stringArray = paths;
        int n = stringArray.length;
        for (int i = 0; i < n && (resourcePaths = this.sc.getResourcePaths(path = stringArray[i])) != null; ++i) {
            this.resourceFinderStack.push(new ResourceFinder(){
                private Deque<String> resourcePathsStack = new LinkedList<String>(){
                    private static final long serialVersionUID = 3109256773218160485L;
                    {
                        for (String resourcePath : resourcePaths) {
                            this.push(resourcePath);
                        }
                    }
                };
                private String current;
                private String next;

                @Override
                public boolean hasNext() {
                    while (this.next == null && !this.resourcePathsStack.isEmpty()) {
                        this.next = this.resourcePathsStack.pop();
                        if (this.next.endsWith("/")) {
                            WebAppResourcesScanner.this.processPaths(new String[]{this.next});
                            this.next = null;
                            continue;
                        }
                        if (!this.next.endsWith(".jar")) continue;
                        try {
                            WebAppResourcesScanner.this.resourceFinderStack.push(new JarFileScanner(WebAppResourcesScanner.this.sc.getResourceAsStream(this.next), "", true));
                        }
                        catch (IOException ioe) {
                            throw new ResourceFinderException(ioe);
                        }
                        this.next = null;
                    }
                    return this.next != null;
                }

                @Override
                public String next() {
                    if (this.next != null || this.hasNext()) {
                        this.current = this.next;
                        this.next = null;
                        return this.current;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public InputStream open() {
                    return WebAppResourcesScanner.this.sc.getResourceAsStream(this.current);
                }

                @Override
                public void reset() {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }

    @Override
    public boolean hasNext() {
        return this.resourceFinderStack.hasNext();
    }

    @Override
    public String next() {
        return this.resourceFinderStack.next();
    }

    @Override
    public void remove() {
        this.resourceFinderStack.remove();
    }

    @Override
    public InputStream open() {
        return this.resourceFinderStack.open();
    }

    @Override
    public void reset() {
        this.resourceFinderStack = new ResourceFinderStack();
        this.processPaths(paths);
    }
}

