/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.monitoring.TimeWindowStatistics;

final class TimeWindowStatisticsImpl
implements TimeWindowStatistics {
    private static final ConcurrentHashMap<Long, TimeWindowStatisticsImpl> EMPTY = new ConcurrentHashMap(6);
    private final long interval;
    private final long minimumDuration;
    private final long maximumDuration;
    private final long averageDuration;
    private final long totalCount;
    private final double requestsPerSecond;

    private TimeWindowStatisticsImpl(long interval, double requestsPerSecond, long minimumDuration, long maximumDuration, long averageDuration, long totalCount) {
        this.interval = interval;
        this.requestsPerSecond = requestsPerSecond;
        this.minimumDuration = minimumDuration;
        this.maximumDuration = maximumDuration;
        this.averageDuration = averageDuration;
        this.totalCount = totalCount;
    }

    @Override
    public long getTimeWindow() {
        return this.interval;
    }

    @Override
    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Override
    public long getMinimumDuration() {
        return this.minimumDuration;
    }

    @Override
    public long getMaximumDuration() {
        return this.maximumDuration;
    }

    @Override
    public long getRequestCount() {
        return this.totalCount;
    }

    @Override
    public TimeWindowStatistics snapshot() {
        return this;
    }

    @Override
    public long getAverageDuration() {
        return this.averageDuration;
    }

    static {
        EMPTY.putIfAbsent(0L, new TimeWindowStatisticsImpl(0L, 0.0, 0L, 0L, 0L, 0L));
    }

    static class Builder {
        private static final int DEFAULT_UNITS_PER_INTERVAL = 100;
        private static final int MINIMUM_UNIT_SIZE = 1000;
        private final long interval;
        private final long unit;
        private final int unitsPerInterval;
        private final long startTime;
        private final Queue<Unit> unitQueue;
        private long totalCount;
        private long totalDuration;
        private final long intervalWithRoundError;
        private long lastUnitEnd;
        private long lastUnitCount;
        private long lastUnitMin = -1L;
        private long lastUnitMax = -1L;
        private long lastUnitDuration = 0L;
        private Unit oldestUnit;

        Builder(long timeWindowSize, TimeUnit timeUnit) {
            this(timeWindowSize, timeUnit, System.currentTimeMillis());
        }

        Builder(long timeWindowSize, TimeUnit timeUnit, long now) {
            this.startTime = now;
            this.interval = timeUnit.toMillis(timeWindowSize);
            if (this.interval == 0L) {
                this.unit = 0L;
                this.unitsPerInterval = 0;
                this.intervalWithRoundError = 0L;
                this.unitQueue = null;
            } else {
                int n = 100;
                long u = this.interval / (long)n;
                if (u < 1000L) {
                    n = (int)this.interval / 1000;
                    u = this.interval / (long)n;
                }
                this.unit = u;
                this.unitsPerInterval = n;
                this.intervalWithRoundError = this.unit * (long)this.unitsPerInterval;
                this.unitQueue = new LinkedList<Unit>();
                this.lastUnitEnd = this.startTime + this.unit;
            }
        }

        void addRequest(long requestTime, long duration) {
            this.closeLastUnitIfNeeded(requestTime);
            ++this.lastUnitCount;
            this.lastUnitDuration += duration;
            if (duration < this.lastUnitMin || this.lastUnitMin == -1L) {
                this.lastUnitMin = duration;
            }
            if (duration > this.lastUnitMax || this.lastUnitMax == -1L) {
                this.lastUnitMax = duration;
            }
        }

        private void closeLastUnitIfNeeded(long requestTime) {
            if (this.interval != 0L) {
                if (requestTime - this.lastUnitEnd > this.interval + this.unit) {
                    this.resetQueue(requestTime);
                }
                if (this.lastUnitEnd < requestTime) {
                    if (this.lastUnitCount > 0L) {
                        this.add(new Unit(this.lastUnitCount, this.lastUnitMin, this.lastUnitMax, this.lastUnitDuration));
                    } else {
                        this.add(Unit.EMPTY_UNIT);
                    }
                    this.lastUnitEnd += this.unit;
                    this.resetLastUnit();
                    while (this.lastUnitEnd < requestTime) {
                        this.add(Unit.EMPTY_UNIT);
                        this.lastUnitEnd += this.unit;
                    }
                }
            }
        }

        private void resetLastUnit() {
            this.lastUnitCount = 0L;
            this.lastUnitMin = -1L;
            this.lastUnitMax = -1L;
            this.lastUnitDuration = 0L;
        }

        private void add(Unit unit) {
            this.unitQueue.add(unit);
            if (this.unitQueue.size() > this.unitsPerInterval) {
                Unit removedUnit = this.unitQueue.remove();
                this.totalCount -= removedUnit.count;
                this.totalDuration -= removedUnit.duration;
            }
            this.oldestUnit = this.unitQueue.element();
            this.totalCount += this.lastUnitCount;
            this.totalDuration += this.lastUnitDuration;
        }

        private void resetQueue(long requestTime) {
            this.unitQueue.clear();
            this.lastUnitEnd = requestTime + this.unit;
            this.resetLastUnit();
            for (int i = 0; i < this.unitsPerInterval; ++i) {
                this.unitQueue.add(Unit.EMPTY_UNIT);
            }
        }

        TimeWindowStatisticsImpl build() {
            return this.build(System.currentTimeMillis());
        }

        TimeWindowStatisticsImpl build(long currentTime) {
            double requestsPerSecond;
            long diff = currentTime - this.startTime;
            if (this.interval == 0L) {
                if (diff < 1000L) {
                    return (TimeWindowStatisticsImpl)EMPTY.get(0L);
                }
                double requestsPerSecond2 = (double)(1000L * this.lastUnitCount) / (double)diff;
                long avg = this.lastUnitCount == 0L ? -1L : this.lastUnitDuration / this.lastUnitCount;
                return this.lastUnitCount == 0L ? (TimeWindowStatisticsImpl)EMPTY.get(0L) : new TimeWindowStatisticsImpl(0L, requestsPerSecond2, this.lastUnitMin, this.lastUnitMax, avg, this.lastUnitCount);
            }
            this.closeLastUnitIfNeeded(currentTime);
            long min = -1L;
            long max = -1L;
            for (Unit u : this.unitQueue) {
                min = this.getMin(min, u.minimumDuration);
                max = this.getMax(max, u.maximumDuration);
            }
            min = this.getMin(min, this.lastUnitMin);
            max = this.getMax(max, this.lastUnitMax);
            long adjustedTotalCount = this.totalCount + this.lastUnitCount;
            long adjustedTotalDuration = this.totalDuration + this.lastUnitDuration;
            int size = this.unitQueue.size();
            if (size >= this.unitsPerInterval) {
                double ratio = (double)(currentTime - (this.lastUnitEnd - this.unit)) / (double)this.unit;
                if (this.oldestUnit != null) {
                    adjustedTotalCount -= (long)((double)this.oldestUnit.count * ratio);
                    adjustedTotalDuration -= (long)((double)this.oldestUnit.duration * ratio);
                }
                requestsPerSecond = (double)(1000L * adjustedTotalCount) / (double)this.intervalWithRoundError;
            } else {
                double d = requestsPerSecond = diff == 0L ? 0.0 : (double)(1000L * adjustedTotalCount) / (double)diff;
            }
            if (adjustedTotalCount == 0L) {
                return this.getOrCreateEmptyStats(this.interval);
            }
            long avg = adjustedTotalDuration / adjustedTotalCount;
            return new TimeWindowStatisticsImpl(this.interval, requestsPerSecond, min, max, avg, adjustedTotalCount);
        }

        private TimeWindowStatisticsImpl getOrCreateEmptyStats(long interval) {
            if (!EMPTY.containsKey(interval)) {
                EMPTY.putIfAbsent(interval, new TimeWindowStatisticsImpl(interval, 0.0, -1L, -1L, -1L, 0L));
            }
            return (TimeWindowStatisticsImpl)EMPTY.get(interval);
        }

        private long getMax(long globalMax, long unitMax) {
            if (unitMax > globalMax && unitMax != -1L || globalMax == -1L) {
                globalMax = unitMax;
            }
            return globalMax;
        }

        private long getMin(long globalMin, long unitMin) {
            if (unitMin < globalMin && unitMin != -1L || globalMin == -1L) {
                globalMin = unitMin;
            }
            return globalMin;
        }

        public long getInterval() {
            return this.interval;
        }

        private static class Unit {
            private final long count;
            private final long minimumDuration;
            private final long maximumDuration;
            private final long duration;
            private static Unit EMPTY_UNIT = new Unit(0L, -1L, -1L, 0L);

            private Unit(long count, long minimumDuration, long maximumDuration, long duration) {
                this.count = count;
                this.minimumDuration = minimumDuration;
                this.maximumDuration = maximumDuration;
                this.duration = duration;
            }
        }
    }
}

