'use strict'
var log =require('../../logger')
var shimmer = require('../shimmer')
var fs = require('fs')
var appendMsg = 'Wrap_error :'

module.exports = function capture(_agent) {

    // var _agent = agent._agent;

    if (_agent && _agent.socket) {

        if (process._fatalException) {

            log.info(appendMsg ,"Wrapped process._fatalException to handle uncaught exeception error");
            //https://github.com/nodejs/node/blob/master/lib/internal/bootstrap_node.js
            //process._fatalException 
            shimmer.wrap(process, '_fatalException', function uncaughtExceptionWrapper(originalFunc) {
             
                return function uncaughtExceptionWrapped(error) {
                    try {
                     
                        log.error(appendMsg ,"Uncaught exception occured Message :", error.message, ' Stack', error.stack)

                        if (!_agent.socket.isMaxReachOut) {

                            _agent.socket.write([{
                                "infra":{
                                'error': {
                                    errorTime: getTimeStamp(),
                                    message: error.message ? error.message.toString() : error.toString(),
                                    stack: error.stack ? error.stack.toString() : '',
                                    processID: _agent.config.pid,
                                    isMaster: true , //_agent.config.isMaster,
                                    workerCount: _agent.config.workerCount
                                }
                             }
                            }]);
                        }

                        return originalFunc.apply(this, arguments)

                    } catch (e) {
                        log.error(appendMsg ,'Wrap process.uncaught exception:  Unhandled error', e)
                    }
                }
            });
        } else {
            log.error(appendMsg ,'Process._fatalException function not found, wrapping failed')
        }


        if (process.emit) {

            log.info(appendMsg ,"Wrapped process.emit to handle unhandled rejection error")

            shimmer.wrap(process, 'emit', function unhandledRejectionWrapper(originalFunc) {
                return function unhandledRejectionWrapped(reason, error, promise) {

                    try {

                        if (reason === 'unhandledRejection' && error) {
                            var listenerCount = 0;

                            //Process.listenerCount is deprecated since V4.0
                            if (process.listenerCount) {
                                listenerCount = process.listenerCount('unhandledRejection');
                            } else {
                                listenerCount = process.listeners('unhandledRejection').length;
                            }

                            if (listenerCount === 0) {
                                log.error(appendMsg ,"Unhandled rejection error occured Message:", 'Reason : ', reason, 'Error:', error, 'Promise:', promise)

                                _agent.socket.write([{
                                    "infra":{
                                    'error': {
                                        errorTime: getTimeStamp(),
                                        message: 'UnhandledPromiseRejectionWarning: Unhandled promise rejection :' + error,
                                        stack: '',
                                        processID: _agent.config.pid,
                                        isMaster: _agent.config.isMaster,
                                        workerCount: _agent.config.workerCount
                                    }
                                }
                                }]);
                            }
                        }

                        return originalFunc.apply(this, arguments);

                    } catch (e) {
                        log.error(appendMsg ,'Wrap process.emit unhandledRejection:  Unhandled error', e)
                    }
                }
            })
        } else {
            log.error(appendMsg ,'Process.emit not found, to capture unhandledRejection is failed')
        }

        log.info(appendMsg ,'wrapped uncaught exception & Rejection')
    }
}

function unwrap() {
    shimmer.unwrap(process, '_fatalException')
    shimmer.unwrap(process, 'emit')
}


function format(num) {
    return (num < 10 ? '0' : '') + num;
};

//dd/MM/yyyy HH:mm:ss
function getTimeStamp() {
    var now = new Date();

    return format(now.getDate()) +
        '/' + format(now.getMonth() + 1) +
        '/' + now.getFullYear() +
        ' ' + format(now.getHours()) +
        ':' + format(now.getMinutes()) +
        ':' + format(now.getSeconds())
};