'use strict'

var shimmer = require('../shimmer')

var searchRegexp = /_search$/
var logger = require('../../logger')
var appendMsg = 'ElasticSearch :'

module.exports = function (elasticsearch, agent, version, enabled) {

  if (!enabled) return elasticsearch

  logger.debug(appendMsg, 'shimming elasticsearch.Transport.prototype.request')
  shimmer.wrap(elasticsearch.Transport && elasticsearch.Transport.prototype, 'request', wrapRequest)

  return elasticsearch

  function wrapRequest(original) {
    return function wrappedRequest(params, cb) {
      var span = agent.buildSpan()
      var id = span && span.transaction.id
      var method = params && params.method
      var path = params && params.path
      var query = params && params.query

      logger.debug(appendMsg,'intercepted call to elasticsearch.Transport.prototype.request %o', {
        id: id,
        method: method,
        path: path
      })

      if (span && method && path) {
        span.start('Elasticsearch: ' + method + ' ' + path, 'db.elasticsearch.request')

        if (query && searchRegexp.test(path)) {

        }

        var options = {
          host: this._config ? this._config.host : '',
          port: 3306,
          resTime: '',
          serverType: 'elastic',
          error: '',
          nodeOrder: '',
          query: JSON.stringify(query),
          path: path,
          method: method
        }

        span.options = options

        if (typeof cb === 'function') {
          var args = Array.prototype.slice.call(arguments)
          args[1] = function () {
            span.end()
            return cb.apply(this, arguments)
          }
          return original.apply(this, args)
        } else {
          var p = original.apply(this, arguments)
          p.then(function () {
            span.end()
          })
          return p
        }
      } else {
        logger.debug(appendMsg, 'could not instrument elasticsearch request %o', {
          id: id
        })
        return original.apply(this, arguments)
      }
    }
  }
}
