'use strict'
/**
 * A queue is a simple data structure that allows elements to be inserted from one end, 
 * called the rear (also called tail), and deleted from the other end, called the front
 * @param {number} size 
 */
var Queue = function (size) {

    this.QUEUE_MAX_SIZE = size || 100000;
    this.bucket = [];
}

Queue.prototype.isEmpty = function () {
    return this.bucket.length === 0;
}

Queue.prototype.enqueue = function (data) {
    //Check if queue reached max size then delete old data
    if (this.bucket.length >= this.QUEUE_MAX_SIZE) {
        //Optimize:- This one is costly operation
        this.bucket.shift();
        //Add log remove old element and insert the new element print size also
    }

    this.bucket.push(data)
}

Queue.prototype.dequeue = function (data) {
    return this.bucket.shift();
}

Queue.prototype.peek = function () {
    return this.bucket[0];
}

Queue.prototype.size = function () {
    return this.bucket.length;
}

Queue.prototype.getAll = function(){
    return this.bucket;
}

Queue.prototype.reset = function(){
    this.bucket = [];
}

module.exports = Queue;