## Installation and Usage
The installation of the eg-node-monitor is a simple three step process. 

Step 1 :  download the `eg-node-monitor.zip` package in your application from eg-manager.

step 2 : unzip the  `eg-node-monitor.zip` in the project folder and install the eg-node-monitor dependencies which is defined in the package.json 

via below command
```
npm install 
```
Step 3: 
It’s important that the agent is started before you require any other modules in your Node.js application - i.e. before express, http, etc.

This means that you should probably require and start the agent in your application’s main file (usually index.js, server.js or app.js).

Do this by requiring and initializing it as the *first statement* in your application. Here’s a simple Express example

```javascript
// Add this to the VERY top of the first file loaded in your app
var egurkha = require('eg-node-monitor')

egurkha.start({
    key: 'nodejstest',
    component_id: "[nodejs_app:3000]",
    log_level: 'debug',
    agent_port: 21700,
    agent_host: '192.168.8.221',
    inframetrics_enabled: true,
    inframetrics_interval: 55000,
    maxQueueSize: 500,
    blocked_threshold : 20
});

// All other require statements must be done after the eg-node-monitor is initialized.
// const express = require('express');
```

## Collecting CPU Profiling, Garbage Collection and Event Loop Information

Some information is not available to Node.js programs without the help of native addons. Specifically, the eg-node-monitor uses these addons
- to retrieve information about garbage collection,
- to retrieve information about event loop activity,
- for CPU profiling

Native addons are compiled automatically for your system and Node.js version when the eg-node-monitor dependency is installed (as part of the `npm install` step). In order for the compilation to work, the system needs to have tools like `make`, `g++` and `python` installed. These tools can often be installed via a bundle called `build-essential` or similar (depending on your package manager and registry). 

The following example shows how to do this for a typical Ubuntu setup.

```
apt-get install build-essential
# -or-
yum groupinstall "Development Tools"
```

For windows 

```
npm install --global windows-build-tools
//Refer https://www.npmjs.com/package/windows-build-tools
```

**It is important that the installation of the dependencies is happening on the machine which will run the application.** This needs to be ensured, because otherwise native addons may be incompatible with the target machine's system architecture or the Node.js version in use. It is therefore a *bad practice* to `npm install` dependencies on a build server and to copy the application (including the dependencies) to the target machine.

If you run your Node.js application dockerized, this aspect deserves extra attention. You might want to check the output of your Docker build for `node-gyp` errors (look for `gyp ERR!` and `node-pre-gyp ERR!`). If these are present, you should inspect and evaluate them. Some of them can be safely ignored. For example, some packages might try to download precompiled binaries, if this fails, they fall back to compilation via `node-gyp` that is, the download error can be ignored, if the compilation step worked. Other packages emit a lot of notes and warnings during compilation, which can also be ignored.




The agent compiles a C++ addon during install, thus you’ll need to have the following on the system prior to installing the agent:

gcc version 4.7 and above
for node-gyp: make and python 2.x (version 2.7 is recommended)
Note that some systems may provide multiple python versions, in which case you would need to specify the correct package name for python 2.7.

On Debian/Ubuntu:
sudo apt-get install g++ make python

On RHEL/CentOS/Amazon Linux:
sudo yum install gcc-c++ make python

On Alpine:
$ sudo apk add g++ make python

Our C++ addon currently supports Linux only. The agent will install on other platforms such as OS X but will run in “no-op” mode where it does not emit trace data or metrics

Important NOTE :-
If you prepare and package deployments on one machine and install them on another, the two machines must have the same operating system and architecture.
If they are not, you will need to re-build the native module after deploying in order to get the correct binaries.