/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.egurkha.util.CacheServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

class CacheHttpServletResponse
implements HttpServletResponse {
    private int status;
    private Hashtable headers;
    private int contentLength;
    private String contentType;
    private Locale locale;
    private Vector cookies;
    private boolean didError;
    private boolean didRedirect;
    private boolean gotStream;
    private boolean gotWriter;
    private HttpServletResponse delegate;
    private CacheServletOutputStream out;
    private PrintWriter writer;

    CacheHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.delegate = httpServletResponse;
        try {
            this.out = new CacheServletOutputStream(httpServletResponse.getOutputStream());
        }
        catch (IOException iOException) {
            System.out.println("Got IOException constructing cached response: " + iOException.getMessage());
        }
        this.internalReset();
    }

    private void internalReset() {
        this.status = 200;
        this.headers = new Hashtable();
        this.contentLength = -1;
        this.contentType = null;
        this.locale = null;
        this.cookies = new Vector();
        this.didError = false;
        this.didRedirect = false;
        this.gotStream = false;
        this.gotWriter = false;
        this.out.getBuffer().reset();
    }

    public boolean isValid() {
        return !this.didError && !this.didRedirect;
    }

    private void internalSetHeader(String string, Object object) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        this.headers.put(string, vector);
    }

    private void internalAddHeader(String string, Object object) {
        Vector<Object> vector = (Vector<Object>)this.headers.get(string);
        if (vector == null) {
            vector = new Vector<Object>();
        }
        vector.addElement(object);
        this.headers.put(string, vector);
    }

    public void writeTo(HttpServletResponse httpServletResponse) {
        Object object;
        httpServletResponse.setStatus(this.status);
        if (this.contentType != null) {
            httpServletResponse.setContentType(this.contentType);
        }
        if (this.locale != null) {
            httpServletResponse.setLocale(this.locale);
        }
        Enumeration<Object> enumeration = this.cookies.elements();
        while (enumeration.hasMoreElements()) {
            object = (Cookie)enumeration.nextElement();
            httpServletResponse.addCookie(object);
        }
        enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Vector vector = (Vector)this.headers.get(object);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                if (e instanceof String) {
                    httpServletResponse.setHeader((String)object, (String)e);
                }
                if (e instanceof Integer) {
                    httpServletResponse.setIntHeader((String)object, ((Integer)e).intValue());
                }
                if (!(e instanceof Long)) continue;
                httpServletResponse.setDateHeader((String)object, ((Long)e).longValue());
            }
        }
        httpServletResponse.setContentLength(this.out.getBuffer().size());
        try {
            this.out.getBuffer().writeTo((OutputStream)httpServletResponse.getOutputStream());
        }
        catch (IOException iOException) {
            System.out.println("Got IOException writing cached response: " + iOException.getMessage());
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.gotWriter) {
            throw new IllegalStateException("Cannot get output stream after getting writer");
        }
        this.gotStream = true;
        return this.out;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.gotStream) {
            throw new IllegalStateException("Cannot get writer after getting output stream");
        }
        this.gotWriter = true;
        if (this.writer == null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)this.out), this.getCharacterEncoding());
            this.writer = new PrintWriter((Writer)outputStreamWriter, true);
        }
        return this.writer;
    }

    public void setContentLength(int n) {
        this.delegate.setContentLength(n);
    }

    public void setContentType(String string) {
        this.delegate.setContentType(string);
        this.contentType = string;
    }

    public String getCharacterEncoding() {
        return this.delegate.getCharacterEncoding();
    }

    public void setBufferSize(int n) throws IllegalStateException {
        this.delegate.setBufferSize(n);
    }

    public int getBufferSize() {
        return this.delegate.getBufferSize();
    }

    public void reset() throws IllegalStateException {
        this.delegate.reset();
        this.internalReset();
    }

    public void resetBuffer() throws IllegalStateException {
        this.delegate.resetBuffer();
        this.contentLength = -1;
        this.out.getBuffer().reset();
    }

    public boolean isCommitted() {
        return this.delegate.isCommitted();
    }

    public void flushBuffer() throws IOException {
        this.delegate.flushBuffer();
    }

    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public void addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie);
        this.cookies.addElement(cookie);
    }

    public boolean containsHeader(String string) {
        return this.delegate.containsHeader(string);
    }

    public void setStatus(int n, String string) {
        this.delegate.setStatus(n, string);
        this.status = n;
    }

    public void setStatus(int n) {
        this.delegate.setStatus(n);
        this.status = n;
    }

    public void setHeader(String string, String string2) {
        this.delegate.setHeader(string, string2);
        this.internalSetHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.delegate.setIntHeader(string, n);
        this.internalSetHeader(string, new Integer(n));
    }

    public void setDateHeader(String string, long l) {
        this.delegate.setDateHeader(string, l);
        this.internalSetHeader(string, new Long(l));
    }

    public void sendError(int n, String string) throws IOException {
        this.delegate.sendError(n, string);
        this.didError = true;
    }

    public void sendError(int n) throws IOException {
        this.delegate.sendError(n);
        this.didError = true;
    }

    public void sendRedirect(String string) throws IOException {
        this.delegate.sendRedirect(string);
        this.didRedirect = true;
    }

    public String encodeURL(String string) {
        return this.delegate.encodeURL(string);
    }

    public String encodeRedirectURL(String string) {
        return this.delegate.encodeRedirectURL(string);
    }

    public void addHeader(String string, String string2) {
        this.internalAddHeader(string, string2);
    }

    public void addIntHeader(String string, int n) {
        this.internalAddHeader(string, new Integer(n));
    }

    public void addDateHeader(String string, long l) {
        this.internalAddHeader(string, new Long(l));
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }
}

