/*
 * Decompiled with CFR 0.152.
 */
package com.zehon.sftp;

import com.zehon.BatchTransferProgress;
import com.zehon.FileTransferClient;
import com.zehon.exception.FileTransferException;
import com.zehon.sftp.SFTPClient;
import java.io.InputStream;

public class SFTP {
    private SFTP() {
    }

    private static SFTPClient getSFTPClient(String serverName, String username, String password) {
        SFTPClient sftpClient = new SFTPClient(serverName, username, password);
        return sftpClient;
    }

    public static int sendFile(String localFilePath, String sftpDestFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).sendFile(localFilePath, sftpDestFolder);
    }

    public static int sendFile(String localFilePath, String sftpDestFolder, String nameOfFileToStore, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).sendFile(localFilePath, sftpDestFolder, nameOfFileToStore);
    }

    public static int sendFile(InputStream inputStream, String nameOfFileToStore, String sftpDestFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).sendFile(inputStream, nameOfFileToStore, sftpDestFolder);
    }

    public static int sendFileOriginal(String localFilePath, String sftpDestFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).sendFileOriginal(localFilePath, sftpDestFolder);
    }

    public static InputStream getFileAsStream(String remoteFileName, String sftpFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).getFileAsStream(remoteFileName, sftpFolder);
    }

    public static int getFile(String remoteFileName, String sftpFolder, String serverName, String username, String password, String toLocalFolder) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).getFile(remoteFileName, sftpFolder, toLocalFolder);
    }

    public static int deleteFile(String nameOfFileToDelete, String sftpFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).deleteFile(nameOfFileToDelete, sftpFolder);
    }

    public static int createFolder(String nameOfFolderToCreate, String sftpFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).createFolder(nameOfFolderToCreate, sftpFolder);
    }

    public static int moveFile(String nameOfFileToMove, String sftpFromFolder, String newNameOfFile, String sftpToFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).moveFile(nameOfFileToMove, sftpFromFolder, newNameOfFile, sftpToFolder);
    }

    public static int copyFile(String sourceFilePath, String destFilePath, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).copyFile(sourceFilePath, destFilePath);
    }

    public static int getFolder(String sftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).getFolder(sftpFolder, toLocalFolder, batchTransferProgress);
    }

    public static int getFolderCreate(String sftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).getFolderCreate(sftpFolder, toLocalFolder, batchTransferProgress);
    }

    public static String[] getFileNamesInFolder(String sftpFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).getFileNamesInFolder(sftpFolder);
    }

    public static int sendFolder(String sendingFolder, String sftpFolder, BatchTransferProgress batchTransferProgress, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).sendFolder(sendingFolder, sftpFolder, batchTransferProgress);
    }

    public static int sendFolderCreate(String sendingFolder, String sftpFolder, BatchTransferProgress batchTransferProgress, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).sendFolderCreate(sendingFolder, sftpFolder, batchTransferProgress);
    }

    public static boolean folderExists(String sftpFolder, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).folderExists(sftpFolder);
    }

    public static boolean fileExists(String sftpFolder, String nameOfFile, String serverName, String username, String password) throws FileTransferException {
        return SFTP.getSFTPClient(serverName, username, password).fileExists(sftpFolder, nameOfFile);
    }

    public static void closeCache() throws FileTransferException {
        FileTransferClient.closeCache();
    }
}

