/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import java.io.InputStream;
import java.io.OutputStream;

public class CircularByteBuffer {
    private byte[] _data;
    private int _writerPos;
    private int _readerPos;
    private boolean _blocking;

    public CircularByteBuffer(int size) {
        this._data = new byte[size];
    }

    synchronized int read() {
        if (this._readerPos == this._data.length) {
            this._readerPos = 0;
        }
        try {
            while (this._blocking && this._readerPos == this._writerPos) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this._readerPos == this._writerPos ? -1 : 0xFF & this._data[this._readerPos++];
    }

    synchronized void write(int b) {
        this._data[this._writerPos++] = (byte)(b & 0xFF);
        if (this._writerPos == this._data.length) {
            this._writerPos = 0;
        }
        if (this._writerPos == this._readerPos) {
            byte[] newData = new byte[2 * this._data.length];
            System.arraycopy(this._data, this._readerPos, newData, 0, this._data.length - this._readerPos);
            System.arraycopy(this._data, 0, newData, this._data.length - this._readerPos, this._readerPos);
            this._readerPos = 0;
            this._writerPos = this._data.length;
            this._data = newData;
        }
    }

    synchronized void flush() {
        this.notify();
    }

    public byte[] readFully() {
        byte[] results;
        if (this._writerPos == this._readerPos) {
            return new byte[0];
        }
        if (this._writerPos > this._readerPos) {
            results = new byte[this._writerPos - this._readerPos];
            System.arraycopy(this._data, this._readerPos, results, 0, results.length);
        } else {
            int numBytesBeforeWrap = this._data.length - this._readerPos;
            results = new byte[this._writerPos + numBytesBeforeWrap];
            System.arraycopy(this._data, this._readerPos, results, 0, numBytesBeforeWrap);
            System.arraycopy(this._data, 0, results, numBytesBeforeWrap, this._writerPos);
        }
        this._readerPos = this._writerPos;
        return results;
    }

    public long available() {
        if (this._writerPos < this._readerPos) {
            return this._data.length - this._readerPos + this._writerPos;
        }
        return this._writerPos - this._readerPos;
    }

    public InputStream createInputStream() {
        this._blocking = true;
        return new InputStream(){

            public int read() {
                return CircularByteBuffer.this.read();
            }

            public int available() {
                return (int)CircularByteBuffer.this.available();
            }

            public int read(byte[] b, int off, int len) {
                int firstByte = this.read();
                if (firstByte < 0) {
                    return -1;
                }
                b[off++] = (byte)firstByte;
                int length = 1 + Math.min(len - 1, (int)CircularByteBuffer.this.available());
                for (int i = 1; i < length; ++i) {
                    b[off++] = (byte)this.read();
                }
                return length;
            }
        };
    }

    public OutputStream createOutputStream() {
        return new OutputStream(){

            public void write(int b) {
                CircularByteBuffer.this.write(b);
            }

            public void flush() {
                CircularByteBuffer.this.flush();
            }

            public void close() {
                this.flush();
            }
        };
    }
}

