/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.transaction;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.SubordinateXAResource;
import com.evermind.server.SubordinateXAResourceAdapter;
import com.evermind.server.SubordinateXAResourceImpl;
import com.evermind.server.rmi.InterceptorNotificationException;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIInterceptor;
import com.evermind.server.rmi.RMIInterceptorContext;
import java.io.IOException;
import java.io.Serializable;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import oracle.as.j2ee.transaction.propagation.AbstractHandler;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.j2ee.transaction.TransactionMessages;

public class TransactionInterceptor
extends AbstractHandler
implements RMIInterceptor {
    private int m_identifier = this.getClass().getName().hashCode();

    public boolean isInterested(int command) {
        boolean interested = RMIConnection.isMethodInvocationCommand(command);
        if (TransactionMessages.isLevelFinest()) {
            TransactionMessages.finest("Returning " + interested + " from isInterested()");
        }
        return interested;
    }

    public Object processSendRequest() throws IOException {
        try {
            ApplicationServerTransaction tx = this.getCallerTransactionForPropagation();
            TransactionMessages.finest(TransactionMessages.getTraceMsgProcessSendRequest(tx));
            return tx == null ? null : this.setupTransactionContext(tx);
        }
        catch (SystemException e) {
            IOException io = new IOException("Exception occurred trying to suspend transaction");
            io.initCause(e);
            throw io;
        }
    }

    public void processReceiveRequest(Object context, RMIInterceptorContext metaContext) throws IOException {
        TransactionMessages.finest(TransactionMessages.getTraceMsgProcessReceiveRequest(context));
        if (context == null) {
            return;
        }
        RequestContext txnContext = (RequestContext)context;
        txnContext.validate();
        try {
            this.inflowTransaction(new NormalXid(txnContext.tid, txnContext.formatId, txnContext.branchId), txnContext.transactionTimeout);
        }
        catch (RollbackException e) {
            throw this.newIOException((Exception)((Object)e));
        }
        catch (InvalidTransactionException e) {
            throw this.newIOException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.newIOException((Exception)((Object)e));
        }
        catch (NotSupportedException e) {
            throw this.newIOException((Exception)((Object)e));
        }
    }

    public Object processSendReply() throws IOException {
        Transaction tx = ((ApplicationServerTransactionManager)this.getTransactionManager()).getTransaction();
        TransactionMessages.finest(TransactionMessages.getTraceMsgProcessSendReply(tx));
        if (tx == null) {
            return null;
        }
        boolean returnResource = this.shouldResourceBeReturned();
        try {
            this.terminateInfection((ApplicationServerTransaction)tx);
        }
        catch (SystemException e) {
            this.markBranchRollbackOnly(tx, (Exception)((Object)e));
        }
        ReplyContext ctx = returnResource ? this.returnContext((ApplicationServerTransaction)tx) : null;
        TransactionMessages.finest(TransactionMessages.getTraceMsgReturnContext(ctx));
        return ctx;
    }

    public void processReceiveReply(Object context) throws IOException {
        try {
            byte[] bqual;
            ReplyContext ctx = (ReplyContext)context;
            SubordinateXAResourceAdapter resource = context == null ? null : new SubordinateXAResourceAdapter(ctx.subordinateXAResource, ctx.rmArgs);
            byte[] byArray = bqual = ctx == null ? null : ctx.branchId;
            if (TransactionMessages.isLevelFinest()) {
                TransactionMessages.finest("processReceiveReply called with resource: " + resource + ", branch: " + bqual + " on Thread: " + Thread.currentThread().getName());
            }
            this.enlistRemoteResourceFromResponse(resource, bqual);
        }
        catch (RollbackException e) {
            throw this.newIOException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.newIOException((Exception)((Object)e));
        }
    }

    public void receiveException(Throwable e) throws InterceptorNotificationException {
        ApplicationServerTransaction tx = null;
        try {
            TransactionMessages.warning("TransactionInterceptor.receiveException about to resumeTransaction on thread " + Thread.currentThread().getName());
            tx = this.resumeTransaction();
            TransactionMessages.warning("TransactionInterceptor.receiveException returned from resumeTransaction on thread " + Thread.currentThread().getName() + " tx:" + tx);
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (InvalidTransactionException ex) {
            this.processInvalidTransactionExceptionInReceiveException(tx, ex, e);
        }
        catch (SystemException ex) {
            TransactionMessages.warning("TransactionInterceptor.receiveException SystemException from resumeTransaction on thread " + Thread.currentThread().getName() + " tx:" + tx);
            throw new InterceptorNotificationException("Unable to resume transaction in receiveException", ex);
        }
        catch (IllegalStateException ex) {
            TransactionMessages.warning("TransactionInterceptor.receiveException IllegalStateException from resumeTransaction on thread " + Thread.currentThread().getName() + " tx:" + tx);
            throw new InterceptorNotificationException("Unable to resume transaction in receiveException", ex);
        }
    }

    private void processInvalidTransactionExceptionInReceiveException(Transaction tx, InvalidTransactionException ex, Throwable e) throws InterceptorNotificationException {
        TransactionMessages.warning("TransactionInterceptor.receiveException InvalidTransactionException from resumeTransaction on thread " + Thread.currentThread().getName() + " tx:" + tx);
        tx = (ApplicationServerTransaction)TransactionInterceptor.getSuspendedTx().get();
        try {
            if (!this.isInRMIServerShutdownStarted() || tx == null || tx.getStatus() != 0 && tx.getStatus() != 1) {
                throw new InterceptorNotificationException("Unable to resume transaction in receiveException", ex);
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        TransactionMessages.warning("Encountered an InvalidTransactionException in receiveException  after ORMI server shutdown during resume of transaction:" + tx + " A re-attempt to resume the transaction will be made.");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            TransactionMessages.warning("InterruptedException in receiveException during shutdown: " + interruptedException);
        }
        this.receiveException(e);
    }

    protected boolean isInRMIServerShutdownStarted() {
        return ApplicationServer.getInstance().isInRMIServerShutdownStarted();
    }

    public void sendException(Throwable e) throws InterceptorNotificationException {
        Transaction tx = ((ApplicationServerTransactionManager)this.getTransactionManager()).getTransaction();
        if (tx == null) {
            return;
        }
        if (this.shouldResourceBeReturned()) {
            this.rollbackBranch((ApplicationServerTransaction)tx);
        } else {
            this.markBranchRollbackOnly(tx);
            try {
                this.terminateInfection((ApplicationServerTransaction)tx);
            }
            catch (SystemException ex) {
                throw new InterceptorNotificationException("Unable to end transaction association in sendException", ex);
            }
        }
    }

    public int getIdentifier() {
        return this.m_identifier;
    }

    private RequestContext setupTransactionContext(ApplicationServerTransaction tx) {
        RequestContext txnContext = new RequestContext();
        txnContext.tid = tx.getGlobalID();
        txnContext.formatId = tx.getXid().getFormatId();
        txnContext.branchId = tx.getNextBranchID();
        txnContext.transactionTimeout = tx.getTransactionTimeout();
        return txnContext;
    }

    private ReplyContext returnContext(ApplicationServerTransaction tx) throws IOException {
        ReplyContext ctx = new ReplyContext();
        ctx.branchId = tx.getXid().getBranchQualifier();
        try {
            ctx.rmArgs = SubordinateXAResourceImpl.instance().getRecoveryInfo();
            ctx.subordinateXAResource = SubordinateXAResourceImpl.instance();
        }
        catch (IllegalStateException ise) {
            this.rollbackBranch(tx, ise);
            throw ise;
        }
        return ctx;
    }

    private IOException newIOException(Exception e) {
        IOException io = new IOException();
        io.initCause(e);
        return io;
    }

    private void rollbackBranch(Transaction tx, Exception ex) throws IOException {
        try {
            tx.rollback();
        }
        catch (SystemException se) {
            try {
                tx.setRollbackOnly();
            }
            catch (SystemException e) {
                // empty catch block
            }
            IOException ioe = new IOException("Unable to rollback transaction: " + tx);
            if (se.getCause() == null) {
                se.initCause((Throwable)ex);
            }
            ioe.initCause(se);
            throw ioe;
        }
    }

    private void rollbackBranch(ApplicationServerTransaction tx) throws InterceptorNotificationException {
        try {
            tx.rollback(false);
        }
        catch (XAException se) {
            try {
                tx.setRollbackOnly();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            throw new InterceptorNotificationException("Unable to rollback transaction due to SystemException ", se);
        }
    }

    private void markBranchRollbackOnly(Transaction tx, Exception ex) throws IOException {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException se) {
            IOException ioe = new IOException("Unable to mark transaction for rollback due to SystemException: " + tx);
            if (se.getCause() == null) {
                se.initCause((Throwable)ex);
            }
            ioe.initCause(se);
            throw ioe;
        }
    }

    private void markBranchRollbackOnly(Transaction tx) throws InterceptorNotificationException {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException se) {
            throw new InterceptorNotificationException("Unable to rollback transaction due to SystemException: " + tx, se);
        }
    }

    public static class ReplyContext
    implements Serializable {
        public SubordinateXAResource subordinateXAResource;
        public byte[] branchId;
        public String rmArgs;
    }

    public static class RequestContext
    implements Serializable {
        public short versionNumber = 0;
        public int transactionTimeout = 60;
        public int formatId;
        public byte[] branchId;
        public byte[] tid;

        void validate() throws IOException {
            if (this.tid == null) {
                throw new IOException("Tid is null in transaction context");
            }
            if (this.branchId == null) {
                throw new IOException("Branch id is null in transaction context");
            }
        }
    }
}

