/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import com.evermind.server.WrappedXAResource;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.spi.ManagedConnectionImpl;
import oracle.oc4j.sql.spi.TxState;
import oracle.oc4j.transaction.TransactionIsolationLevel;

public class XAResourceWrapper
implements XAResource,
WrappedXAResource,
TransactionIsolationLevel {
    private XAResource m_xaResource;
    private ManagedConnectionImpl m_managedConnection;
    private TxState m_txState;
    private int m_isolationLevelBeforeSetTransactionIsolationCall;
    private boolean m_isIsolationLevelSet = false;

    public XAResource getWrappedResource() {
        return this.m_xaResource;
    }

    public XAResourceWrapper(XAResource xaResource, ManagedConnectionImpl managedConnection) {
        ConnectionFactoryConfig cfc;
        this.m_xaResource = xaResource;
        this.m_managedConnection = managedConnection;
        this.m_txState = managedConnection.getTxState();
        if (xaResource != null && DataSourceUtils.isClass(xaResource.getClass(), "oracle.jdbc.xa.OracleXAResource") && (cfc = managedConnection.getManagedConnectionFactory().getDataSourceConnectionPool().getConnectionFactory().getConnectionFactoryConfig()).getDbLinkPropertyValue() != null) {
            try {
                Class[] paramTypes = new Class[]{String.class};
                Object[] args = new Object[]{cfc.getDbLinkPropertyValue().toUpperCase()};
                xaResource.getClass().getMethod("setDBLink", paramTypes).invoke((Object)xaResource, args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void commit(Xid xid, boolean onePC) throws XAException {
        this.commit(xid, onePC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePC, boolean inDBCoord) throws XAException {
        try {
            if (!inDBCoord) {
                this.m_xaResource.commit(xid, onePC);
            }
            Object var5_4 = null;
            if (this.m_isIsolationLevelSet) {
                this.resetTransactionIsolation();
            }
            this.m_txState.xaResourceAction(xid, onePC ? TxState.COMMIT_1PC : TxState.COMMIT_2PC);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.m_isIsolationLevelSet) {
                this.resetTransactionIsolation();
            }
            this.m_txState.xaResourceAction(xid, onePC ? TxState.COMMIT_1PC : TxState.COMMIT_2PC);
            throw throwable;
        }
        this.m_managedConnection.xaResourceCommitCalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.m_xaResource.end(xid, flags);
        }
        finally {
            this.m_txState.xaResourceAction(xid, TxState.actionFromXAResourceEndFlags(flags));
        }
        try {
            this.m_managedConnection.xaResourceEndCalled(flags);
        }
        catch (SQLException e) {
            XAException xaException = new XAException(-3);
            xaException.initCause(e);
            throw xaException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        try {
            this.m_xaResource.forget(xid);
        }
        finally {
            this.m_txState.xaResourceAction(xid, TxState.FORGET);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        DataSourceMessages.infoXAResourceWrapperIsSameRmCalled();
        return this.m_xaResource.isSameRM(xaResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        int returnValue = 0;
        try {
            returnValue = this.m_xaResource.prepare(xid);
            Object var4_3 = null;
            this.m_txState.xaResourceAction(xid, returnValue == 3 ? TxState.PREPARE_RDONLY : TxState.PREPARE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_txState.xaResourceAction(xid, returnValue == 3 ? TxState.PREPARE_RDONLY : TxState.PREPARE);
            throw throwable;
        }
        return returnValue;
    }

    public Xid[] recover(int i) throws XAException {
        return this.m_xaResource.recover(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            this.m_xaResource.rollback(xid);
            Object var3_2 = null;
            if (this.m_isIsolationLevelSet) {
                this.resetTransactionIsolation();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.m_isIsolationLevelSet) {
                this.resetTransactionIsolation();
            }
            this.m_txState.xaResourceAction(xid, TxState.ROLLBACK);
            throw throwable;
        }
        this.m_txState.xaResourceAction(xid, TxState.ROLLBACK);
        this.m_managedConnection.xaResourceRollbackCalled();
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return this.m_xaResource.setTransactionTimeout(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.m_xaResource.start(xid, flags);
        }
        finally {
            this.m_txState.xaResourceAction(xid, TxState.actionFromXAResourceStartFlags(flags));
        }
        try {
            this.m_managedConnection.xaResourceStartCalled(flags);
        }
        catch (SQLException e) {
            XAException xaException = new XAException(-3);
            xaException.initCause(e);
            throw xaException;
        }
    }

    public void setTransactionIsolation(int isolationLevel) throws XAException {
        try {
            this.m_isolationLevelBeforeSetTransactionIsolationCall = this.m_managedConnection.getConnection().getTransactionIsolation();
            this.m_managedConnection.getConnection().setTransactionIsolation(isolationLevel);
            this.m_isIsolationLevelSet = true;
        }
        catch (SQLException e) {
            XAException xaException = new XAException("SQLException thrown while trying to setTransactionIsolation");
            xaException.initCause(e);
            xaException.errorCode = -3;
            throw xaException;
        }
    }

    public void resetTransactionIsolation() {
        try {
            this.m_managedConnection.getConnection().setTransactionIsolation(this.m_isolationLevelBeforeSetTransactionIsolationCall);
        }
        catch (SQLException e) {
            DataSourceMessages.warningSQLExceptionDuringResetTransactionIsolation(e);
        }
    }

    public String toString() {
        if (this.m_xaResource == null) {
            return super.toString();
        }
        return this.m_xaResource.toString();
    }
}

