/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import com.evermind.server.Application;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceConnectionPoolImpl;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;

public class ResourceAdapterImpl
implements ResourceAdapter {
    public static final long DEFAULT_UPDATE_STATISTICS_INTERVAL = 60000L;
    private static Hashtable m_resourceAdapters = new Hashtable();
    private Hashtable m_dataSourceConnectionPools = new Hashtable();
    private Hashtable m_connectionPoolConnectionFactories = new Hashtable();
    private transient Application m_application = null;
    private transient Timer m_connectionPoolStatsTimer = null;
    private String m_resourceAdapterListKey = "";
    private long m_updateStatisticsInterval = 60000L;
    private transient ClassLoader m_classLoaderForProxyCreation = null;

    private void initConnectionPoolStatsTimer() {
        this.m_connectionPoolStatsTimer = new Timer();
        this.m_connectionPoolStatsTimer.schedule((TimerTask)new StatsTimerTask(), 0L, this.m_updateStatisticsInterval);
    }

    public int getNumDataSourceConnectionPools() {
        return this.m_dataSourceConnectionPools.size();
    }

    public DataSourceConnectionPool getDataSourceConnectionPool(String name) {
        return (DataSourceConnectionPool)this.m_dataSourceConnectionPools.get(name);
    }

    public DataSourceConnectionPool createDataSourceConnectionPool(ConnectionPoolConfig connectionPoolConfig, String applicationName) throws ResourceException {
        DataSourceConnectionPoolImpl dataSourceConnectionPool = null;
        try {
            dataSourceConnectionPool = new DataSourceConnectionPoolImpl(this, connectionPoolConfig, applicationName);
            this.addDataSourceConnectionPool(dataSourceConnectionPool);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (DataSourceException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (DataSourceConfigException e) {
            throw new ResourceException((Throwable)e);
        }
        return dataSourceConnectionPool;
    }

    public synchronized void addDataSourceConnectionPool(DataSourceConnectionPool connectionPool) throws ResourceException {
        String poolName = connectionPool.getName();
        if (this.m_dataSourceConnectionPools.get(poolName) != null) {
            throw new ResourceException("The connection pool named '" + poolName + "' already exists.");
        }
        this.m_dataSourceConnectionPools.put(poolName, connectionPool);
        if (this.m_connectionPoolStatsTimer == null) {
            this.initConnectionPoolStatsTimer();
        }
    }

    public synchronized DataSourceConnectionPool removeDataSourceConnectionPool(String poolName) {
        if (poolName == null) {
            poolName = "";
        }
        this.m_connectionPoolConnectionFactories.remove(poolName);
        DataSourceConnectionPool pool = (DataSourceConnectionPool)this.m_dataSourceConnectionPools.remove(poolName);
        if (this.m_dataSourceConnectionPools.size() == 0) {
            this.destroyStatsTimer();
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindConnectionFactoryToConnectionPool(ManagedConnectionFactoryImpl managedConnectionFactory) {
        String poolName = managedConnectionFactory.getDataSourceConnectionPool().getName();
        Hashtable hashtable = this.m_connectionPoolConnectionFactories;
        synchronized (hashtable) {
            HashSet<ManagedConnectionFactoryImpl> factories = (HashSet<ManagedConnectionFactoryImpl>)this.m_connectionPoolConnectionFactories.get(poolName);
            if (factories == null) {
                factories = new HashSet<ManagedConnectionFactoryImpl>();
            }
            factories.add(managedConnectionFactory);
            this.m_connectionPoolConnectionFactories.put(poolName, factories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindConnectionFactoryToConnectionPool(String jndiLocation, String connectionPoolName) {
        if (jndiLocation != null && connectionPoolName != null) {
            Hashtable hashtable = this.m_connectionPoolConnectionFactories;
            synchronized (hashtable) {
                HashSet factories = (HashSet)this.m_connectionPoolConnectionFactories.get(connectionPoolName);
                if (factories != null) {
                    ManagedConnectionFactoryImpl foundMCF = null;
                    Iterator iter = factories.iterator();
                    while (iter.hasNext() && foundMCF == null) {
                        ManagedConnectionFactoryImpl mcf = (ManagedConnectionFactoryImpl)iter.next();
                        if (!jndiLocation.equals(mcf.getManagedDataSourceConfig().getJndiName())) continue;
                        foundMCF = mcf;
                    }
                    if (foundMCF != null) {
                        factories.remove(foundMCF);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionFactoryImpl[] getConnectionPoolConnectionFactories(String poolName) {
        ManagedConnectionFactoryImpl[] managedConnectionFactories = null;
        Hashtable hashtable = this.m_connectionPoolConnectionFactories;
        synchronized (hashtable) {
            Set factories = (Set)this.m_connectionPoolConnectionFactories.get(poolName);
            if (factories == null) {
                managedConnectionFactories = new ManagedConnectionFactoryImpl[]{};
            } else {
                managedConnectionFactories = new ManagedConnectionFactoryImpl[factories.size()];
                factories.toArray(managedConnectionFactories);
            }
        }
        return managedConnectionFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumConnectionFactories(String poolName) {
        int numFactories = 0;
        Hashtable hashtable = this.m_connectionPoolConnectionFactories;
        synchronized (hashtable) {
            Set factories = (Set)this.m_connectionPoolConnectionFactories.get(poolName);
            if (factories != null) {
                numFactories = factories.size();
            }
        }
        return numFactories;
    }

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
    }

    public void stopDataSourceConnectionPool(DataSourceConnectionPool dscp) throws DataSourceException {
        try {
            if (this.m_application != null) {
                this.m_application.removeDataSourceConnectionPoolMBean(dscp);
            }
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
        dscp.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.m_application != null) {
            Hashtable hashtable = this.m_connectionPoolConnectionFactories;
            synchronized (hashtable) {
                Iterator iter = this.m_connectionPoolConnectionFactories.values().iterator();
                while (iter.hasNext()) {
                    Set factories = (Set)iter.next();
                    Iterator factoriesIter = factories.iterator();
                    while (factoriesIter.hasNext()) {
                        ManagedConnectionFactoryImpl mcf = (ManagedConnectionFactoryImpl)factoriesIter.next();
                        try {
                            this.m_application.removeManagedDataSourceMBean(mcf.getManagedDataSourceConfig().getName());
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            hashtable = this.m_dataSourceConnectionPools;
            synchronized (hashtable) {
                Object[] objects = this.m_dataSourceConnectionPools.values().toArray();
                for (int i = 0; i < objects.length; ++i) {
                    try {
                        DataSourceConnectionPool dscp = (DataSourceConnectionPool)objects[i];
                        this.stopDataSourceConnectionPool(dscp);
                        continue;
                    }
                    catch (DataSourceException dataSourceException) {
                        // empty catch block
                    }
                }
            }
        }
        this.destroyStatsTimer();
        m_resourceAdapters.remove(this.m_resourceAdapterListKey);
    }

    private void destroyStatsTimer() {
        if (this.m_connectionPoolStatsTimer != null) {
            this.m_connectionPoolStatsTimer.cancel();
            this.m_connectionPoolStatsTimer = null;
        }
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException {
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        return new XAResource[0];
    }

    public static void addResourceAdapter(String applicationName, ResourceAdapterImpl resourceAdapter) {
        m_resourceAdapters.put(applicationName, resourceAdapter);
        resourceAdapter.m_resourceAdapterListKey = applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceAdapterImpl getResourceAdapter(String applicationName) {
        Hashtable hashtable = m_resourceAdapters;
        synchronized (hashtable) {
            ResourceAdapterImpl resourceAdapter = (ResourceAdapterImpl)m_resourceAdapters.get(applicationName);
            if (resourceAdapter == null) {
                resourceAdapter = new ResourceAdapterImpl();
                ResourceAdapterImpl.addResourceAdapter(applicationName, resourceAdapter);
            }
            return resourceAdapter;
        }
    }

    public Application getApplication() {
        return this.m_application;
    }

    public void setApplication(Application application) {
        this.m_application = application;
    }

    public long getUpdateStatisticsInterval() {
        return this.m_updateStatisticsInterval;
    }

    public void setUpdateStatisticsInterval(long updateStatisticsInterval) {
        this.m_updateStatisticsInterval = updateStatisticsInterval;
        if (this.m_connectionPoolStatsTimer != null) {
            this.m_connectionPoolStatsTimer.cancel();
        }
        if (updateStatisticsInterval > 0L) {
            this.initConnectionPoolStatsTimer();
        } else {
            this.m_connectionPoolStatsTimer = null;
        }
    }

    Timer getConnectionPoolStatsTimer() {
        return this.m_connectionPoolStatsTimer;
    }

    public synchronized ClassLoader getClassLoaderForProxyCreation() {
        if (this.m_classLoaderForProxyCreation == null) {
            if (this.m_application != null) {
                this.m_classLoaderForProxyCreation = this.m_application.getClassLoader();
            }
            if (this.m_classLoaderForProxyCreation == null) {
                this.m_classLoaderForProxyCreation = this.getClass().getClassLoader();
            }
        }
        return this.m_classLoaderForProxyCreation;
    }

    private class StatsTimerTask
    extends TimerTask {
        private StatsTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] cps;
            Hashtable hashtable = ResourceAdapterImpl.this.m_dataSourceConnectionPools;
            synchronized (hashtable) {
                cps = ResourceAdapterImpl.this.m_dataSourceConnectionPools.values().toArray();
            }
            for (int i = 0; i < cps.length; ++i) {
                DataSourceConnectionPool dscp = (DataSourceConnectionPool)cps[i];
                dscp.updateDMSStats();
                ManagedConnectionFactoryImpl[] factories = ResourceAdapterImpl.this.getConnectionPoolConnectionFactories(dscp.getName());
                int numFactories = factories.length;
                for (int j = 0; j < numFactories; ++j) {
                    ManagedDataSource managedDataSource = factories[j].getManagedDataSource();
                    if (managedDataSource == null) continue;
                    managedDataSource.getDmsConnectionStats();
                }
            }
        }
    }
}

