/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.proxy;

import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.proxy.BCELProxyFactory;
import oracle.j2ee.connector.proxy.ProxyBuilder;
import oracle.j2ee.connector.proxy.ProxyInterceptException;
import oracle.oc4j.sql.proxy.ConstructionKey;
import oracle.oc4j.sql.proxy.SQLBCELProxyBuilder;
import oracle.oc4j.sql.proxy.SQLBCELProxyEvent;
import oracle.oc4j.sql.proxy.SQLBCELProxyEventType;
import oracle.oc4j.sql.proxy.SQLBCELProxyFactory;

public class SQLBCELProxy
extends AbstractProxy {
    private Set m_childProxies;
    private ConstructionKey m_constructionKey = null;
    protected boolean m_requiresReconstruction = false;
    protected boolean m_isValid = true;
    protected boolean m_isActive = true;
    protected boolean m_doIntercept = true;

    protected SQLBCELProxy(Object target, SQLBCELProxy parent) {
        super(target);
        this.oc4j_setParent(parent);
    }

    public void oc4j_setParent(AbstractProxy parent) {
        super.oc4j_setParent(parent);
        if (parent != null) {
            ((SQLBCELProxy)parent).oc4j_addChildProxy(this);
        }
    }

    protected synchronized void oc4j_addChildProxy(SQLBCELProxy child) {
        if (this.m_childProxies == null) {
            this.m_childProxies = new HashSet();
        }
        this.m_childProxies.add(child);
    }

    protected synchronized void oc4j_removeChildProxy(SQLBCELProxy child) {
        if (this.m_childProxies != null) {
            this.m_childProxies.remove(child);
            child.oc4j_setParent(null);
        }
    }

    protected boolean oc4j_close(boolean removeFromParent) throws SQLException {
        SQLBCELProxy parent;
        if (this.m_isClosed) {
            return false;
        }
        this.m_isClosed = true;
        this.oc4j_notifyChildren(SQLBCELProxyEvent.CLOSE_EVENT);
        this.oc4j_releaseTarget();
        if (removeFromParent && (parent = (SQLBCELProxy)this.oc4j_getParent()) != null) {
            parent.oc4j_removeChildProxy(this);
        }
        return true;
    }

    protected void oc4j_dissociate() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        if (this.m_isActive) {
            this.m_isActive = false;
            this.oc4j_notifyChildren(SQLBCELProxyEvent.DISSOCIATE_CONNECTION_EVENT);
        }
    }

    protected void oc4j_associate() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        if (!this.m_isActive) {
            this.m_isActive = true;
            this.oc4j_notifyChildren(SQLBCELProxyEvent.ASSOCIATE_CONNECTION_EVENT);
        }
    }

    protected void oc4j_markForReconstruction() throws SQLException {
        ConstructionKey key = this.oc4j_getConstructionKey();
        if (key != null) {
            key.setValid(false);
            this.m_requiresReconstruction = true;
        }
    }

    public void oc4j_invalidate() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        if (this.m_isValid) {
            this.m_isValid = false;
            this.oc4j_notifyChildren(SQLBCELProxyEvent.INVALIDATE_EVENT);
        }
    }

    public boolean oc4j_isValid() {
        return this.m_isValid;
    }

    public void oc4j_resetValid() {
        this.m_isValid = true;
    }

    protected synchronized boolean oc4j_hasChild(SQLBCELProxy childProxy) {
        return this.m_childProxies.contains(childProxy);
    }

    protected synchronized void oc4j_notifyChildren(SQLBCELProxyEventType type) throws SQLException {
        if (this.m_childProxies == null) {
            return;
        }
        SQLBCELProxyEvent event = new SQLBCELProxyEvent(this, type);
        Iterator iter = this.m_childProxies.iterator();
        while (iter.hasNext()) {
            SQLBCELProxy child = (SQLBCELProxy)iter.next();
            child.oc4j_notify(event);
            if (!child.m_isClosed && child.m_isValid) continue;
            child.oc4j_setParent(null);
            iter.remove();
        }
    }

    protected void oc4j_notify(SQLBCELProxyEvent event) throws SQLException {
        SQLBCELProxyEventType eventType = event.getType();
        if (event.getSource() == this.oc4j_getParent()) {
            if (eventType == SQLBCELProxyEvent.CLOSE_EVENT) {
                this.oc4j_close(false);
            } else if (eventType == SQLBCELProxyEvent.ASSOCIATE_CONNECTION_EVENT) {
                this.oc4j_associate();
            } else if (eventType == SQLBCELProxyEvent.DISSOCIATE_CONNECTION_EVENT) {
                this.oc4j_dissociate();
            } else if (eventType == SQLBCELProxyEvent.INVALIDATE_EVENT) {
                this.oc4j_invalidate();
            }
        }
    }

    public synchronized void oc4j_resetTarget(Object target) throws IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("The target object can't be null!");
        }
        Class<?>[] proxyInterfaces = this.getClass().getInterfaces();
        Class<?> targetClass = target.getClass();
        for (int i = 0; i < proxyInterfaces.length; ++i) {
            Class<?> proxyInterface = proxyInterfaces[i];
            if (!Modifier.isPublic(proxyInterface.getModifiers()) || proxyInterface.isAssignableFrom(targetClass)) continue;
            throw new IllegalArgumentException("The target object " + target + " is not a " + proxyInterface);
        }
        this.m_target = target;
        this.oc4j_resetValid();
    }

    protected void oc4j_releaseTarget() throws SQLException {
        this.m_target = null;
    }

    public ProxyBuilder oc4j_getNewBuilder(Object target, String requiredInterfaceName) {
        return new SQLBCELProxyBuilder(target, this, requiredInterfaceName, (SQLBCELProxyFactory)this.oc4j_getFactory());
    }

    protected void oc4j_intercept() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException("SQL wrapper has been closed!");
        }
        if (!this.m_isValid) {
            throw new SQLException("SQL wrapper is not valid!");
        }
        if (this.oc4j_getParent() != null) {
            ((SQLBCELProxy)this.oc4j_getParent()).oc4j_intercept();
        }
        if (this.m_requiresReconstruction) {
            this.reconstructFromKey();
            this.m_requiresReconstruction = false;
        }
    }

    private void reconstructFromKey() {
        if (this.m_constructionKey != null && !this.m_constructionKey.isValid()) {
            if (this.oc4j_getParent() != null && this.oc4j_getParent().oc4j_getTarget() != null) {
                this.m_constructionKey.setTarget(this.oc4j_getParent().oc4j_getTarget());
                Object newTarget = ((SQLBCELProxy)this.oc4j_getParent()).oc4j_getCachedObject(this.m_constructionKey);
                if (newTarget == null) {
                    newTarget = this.m_constructionKey.invoke();
                }
                this.oc4j_resetTarget(newTarget);
                this.m_constructionKey.setTarget(null);
            }
            this.m_constructionKey.setValid(true);
        }
    }

    protected void oc4j_handleSQLException(SQLException exception) throws SQLException {
        if (this.oc4j_getParent() != null) {
            ((SQLBCELProxy)this.oc4j_getParent()).oc4j_handleSQLException(exception);
        }
        throw exception;
    }

    protected void oc4j_handleSQLExceptionNoRethrow(SQLException exception) {
        try {
            this.oc4j_handleSQLException(exception);
        }
        catch (SQLException e) {
            throw new ProxyInterceptException(e.toString(), e);
        }
    }

    protected ConstructionKey oc4j_createConstructionKey(String className, String interfaceName, String methodName, String methodSignature) throws SQLException {
        try {
            return ConstructionKey.createConstructionKey(className, interfaceName, methodName, methodSignature, ((BCELProxyFactory)this.oc4j_getFactory()).getBCELProxyClassLoader());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    protected Object oc4j_getCachedObject(ConstructionKey key) {
        return null;
    }

    protected boolean oc4j_addObjectToCache(ConstructionKey key, Object obj, boolean shareable) {
        return false;
    }

    public void oc4j_setConstructionKey(ConstructionKey key) {
        this.m_constructionKey = key;
    }

    public ConstructionKey oc4j_getConstructionKey() {
        return this.m_constructionKey;
    }

    public void setDoIntercept(boolean doIntercept) {
        this.m_doIntercept = doIntercept;
    }

    protected static AbstractProxy oc4j_getRoot(AbstractProxy proxy) {
        if (proxy == null) {
            return null;
        }
        while (proxy.oc4j_getParent() != null) {
            proxy = proxy.oc4j_getParent();
        }
        return proxy;
    }
}

