/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import com.evermind.server.UnSupportedMBeanOperationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.sql.DataSource;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.JDBCDataSource;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.mbean.NativeJDBCDataSourceCallBack;
import oracle.oc4j.sql.mbean.NativeJDBCDataSourceMBean;

public class NativeJDBCDataSource
extends JDBCDataSource
implements NativeJDBCDataSourceMBean {
    public static final String NATIVE_DATA_SOURCE_RESOURCE_NAME = "";
    public static final String TEST_CONNECTION_SUCCESSFUL_STRING = "Test was successful.";
    private DataSource m_nativeDataSource = null;
    private NativeDataSourceConfig m_nativeDataSourceConfig = null;
    private NativeJDBCDataSourceCallBack m_callBack;

    public NativeJDBCDataSource(String name, NativeJDBCDataSourceCallBack callBack) throws IllegalArgumentException {
        super(NATIVE_DATA_SOURCE_RESOURCE_NAME, name, callBack.getJ2EEApplicationCallBackIf());
        this.init(callBack);
    }

    private NativeJDBCDataSource(Locale locale, NativeJDBCDataSourceCallBack callBack) {
        super(locale);
        this.init(callBack);
    }

    public ModelMBeanInfo getMBeanInfo(Locale locale) {
        try {
            return ModelMBeanFactory.getModelMBeanInfo(new NativeJDBCDataSource(locale, this.m_callBack));
        }
        catch (MBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void init(NativeJDBCDataSourceCallBack callBack) throws IllegalArgumentException {
        if (callBack == null) {
            throw new IllegalArgumentException("The callback object cannot be null.");
        }
        this.m_callBack = callBack;
        this.m_nativeDataSource = callBack.getNativeDataSource();
        if (this.m_nativeDataSource == null) {
            throw new IllegalArgumentException("The Native Data Source cannot be null.");
        }
        this.m_nativeDataSourceConfig = callBack.getNativeDataSourceConfig();
        if (this.m_nativeDataSourceConfig == null) {
            throw new IllegalArgumentException("The Native Data Source Configuration cannot be null.");
        }
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("dataSourceClass", "java.lang.String", this.getLocalizedMessage("nativejdbcdatasource_DataSourceClass"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("url", "java.lang.String", this.getLocalizedMessage("nativejdbcdatasource_Url"), true, true, false), ON_APPLICATION_RESTART_ONUPDATE_PERSISTENCE_PROPERTIES);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyName")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addProperty", this.getLocalizedMessage("nativejdbcdatasource_addProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyName")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setProperty", this.getLocalizedMessage("nativejdbcdatasource_setProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("jdbc_removeProperty_propertyName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeProperty", this.getLocalizedMessage("nativejdbcdatasource_removeProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getProperties", this.getLocalizedMessage("nativejdbcdatasource_getProperties"), null, Map.class.getName(), 0), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("properties", "java.util.Map", this.getLocalizedMessage("nativejdbcdatasource_replaceproperties_properties"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("replaceProperties", this.getLocalizedMessage("nativejdbcdatasource_replaceProperties"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
    }

    public synchronized void removeProperty(String propertyName) throws MBeanException {
        this.m_nativeDataSourceConfig.removePropertyConfig(propertyName);
    }

    public Map getProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        PropertyConfig[] properties = this.m_nativeDataSourceConfig.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            map.put(properties[i].getName(), properties[i].getValue());
        }
        return map;
    }

    public synchronized void replaceProperties(Map properties) throws DataSourceConfigException, MBeanException {
        if (properties != null) {
            int numProperties = properties.size();
            int propertyNum = 0;
            PropertyConfig[] propertyConfigs = new PropertyConfig[numProperties];
            Iterator iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = (String)properties.get(name);
                propertyConfigs[propertyNum++] = new PropertyConfig(name, value);
            }
            for (int i = 0; i < propertyConfigs.length; ++i) {
                this.setProperty(propertyConfigs[i].getName(), propertyConfigs[i].getValue());
            }
            this.m_nativeDataSourceConfig.setProperties(propertyConfigs);
        }
    }

    public synchronized void addProperty(String propertyName, String propertyValue) throws MBeanException {
        try {
            if (!DataSourceUtils.isPropertySettable(this.m_nativeDataSource, propertyName)) {
                throw new DataSourceException("The native data source does not have a setter for the property: " + propertyName + "  Property names are case sensitive.");
            }
            this.m_nativeDataSourceConfig.addPropertyConfig(new PropertyConfig(propertyName, propertyValue));
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void setProperty(String propertyName, String propertyValue) throws MBeanException {
        this.setProperty(this.m_nativeDataSource, propertyName, propertyValue);
    }

    public synchronized void copyDataSource(String newDataSourceName, String jndiLocation) throws MBeanException {
        try {
            this.getApplicationCallBack().copyNativeDataSource(this.m_nativeDataSourceConfig.getName(), jndiLocation, newDataSourceName);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void removeDataSource() throws MBeanException {
        try {
            this.getApplicationCallBack().removeNativeDataSource(this.m_nativeDataSourceConfig.getName());
        }
        catch (DataSourceException dse) {
            throw new MBeanException(dse);
        }
    }

    public String testConnection(String sqlStatement) {
        return this.testConnection(sqlStatement, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String testConnection(String sqlStatement, String user, String password) {
        Connection connection = null;
        connection = user == null ? this.m_nativeDataSource.getConnection() : this.m_nativeDataSource.getConnection(user, password);
        Statement statement = connection.createStatement();
        statement.executeQuery(sqlStatement);
        Object var8_7 = null;
        if (connection == null) return TEST_CONNECTION_SUCCESSFUL_STRING;
        try {
            connection.close();
            return TEST_CONNECTION_SUCCESSFUL_STRING;
        }
        catch (SQLException sqlException) {
            DataSourceMessages.warningNativeJDBCDataSourceTestConnectionCloseConnection(sqlException);
        }
        return TEST_CONNECTION_SUCCESSFUL_STRING;
        {
            catch (Exception exception) {
                String string = DataSourceMessages.warningNativeJDBCDataSourceTestConnection(exception);
                Object var8_8 = null;
                if (connection == null) return string;
                try {
                    connection.close();
                    return string;
                }
                catch (SQLException sqlException) {
                    DataSourceMessages.warningNativeJDBCDataSourceTestConnectionCloseConnection(sqlException);
                }
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sqlException) {
                DataSourceMessages.warningNativeJDBCDataSourceTestConnectionCloseConnection(sqlException);
            }
            throw throwable;
        }
    }

    public String getdataSourceName() {
        return this.m_nativeDataSourceConfig.getName();
    }

    public synchronized void setdataSourceName(String dataSourceName) throws MBeanException {
        try {
            this.getApplicationCallBack().renameNativeDataSource(this.m_nativeDataSourceConfig.getName(), dataSourceName);
            this.unregisterMBean();
            this.m_nativeDataSourceConfig.setName(dataSourceName);
            this.setName(dataSourceName);
            this.setBaseObjectName();
            this.registerMBean();
        }
        catch (DataSourceConfigException e) {
            throw new MBeanException(e);
        }
        catch (DataSourceException e) {
            throw new MBeanException(e);
        }
        catch (UnSupportedMBeanOperationException e) {
            throw new MBeanException(e);
        }
    }

    public String getjndiName() {
        return this.m_nativeDataSourceConfig.getJndiName();
    }

    public String getdataSourceClass() {
        return this.m_nativeDataSourceConfig.getDataSourceClass();
    }

    public String getuser() {
        return this.m_nativeDataSourceConfig.getUser();
    }

    public synchronized void setuser(String user) throws MBeanException {
        try {
            this.m_nativeDataSourceConfig.setUser(user);
            DataSourceUtils.setUser(this.m_nativeDataSource, user);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String getpassword() {
        return this.m_nativeDataSourceConfig.getPassword();
    }

    public synchronized void setpassword(String password) throws MBeanException {
        try {
            this.m_nativeDataSourceConfig.setPassword(password);
            DataSourceUtils.setPassword(this.m_nativeDataSource, password);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String geturl() {
        return this.m_nativeDataSourceConfig.getUrl();
    }

    public synchronized void seturl(String url) throws MBeanException {
        try {
            this.m_nativeDataSourceConfig.setUrl(url);
            DataSourceUtils.setUrl(this.m_nativeDataSource, url);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public int getloginTimeout() throws MBeanException {
        try {
            return this.m_nativeDataSource.getLoginTimeout();
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void setloginTimeout(Integer loginTimeout) throws MBeanException {
        try {
            this.m_nativeDataSourceConfig.setLoginTimeout(loginTimeout);
            this.m_nativeDataSource.setLoginTimeout(loginTimeout);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public NativeJDBCDataSourceCallBack getCallBack() {
        return this.m_callBack;
    }
}

