/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import com.evermind.server.UnSupportedMBeanOperationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.JDBCDataSource;
import oracle.oc4j.admin.management.mbeans.StatisticsProvider;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionPoolStats;
import oracle.oc4j.sql.mbean.DMSUtils;
import oracle.oc4j.sql.mbean.JDBCStatsImpl;
import oracle.oc4j.sql.mbean.MBeanUtils;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSourceCallBack;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSourceMBean;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;

public class ManagedJDBCDataSource
extends JDBCDataSource
implements ManagedJDBCDataSourceMBean,
StatisticsProvider {
    private ManagedJDBCDataSourceCallBack m_callBack;
    private ManagedDataSource m_managedDataSource = null;
    private ManagedDataSourceConfig m_managedDataSourceConfig = null;
    private String m_connectionPoolName = null;

    public ManagedJDBCDataSource(String connectionPoolName, String name, ManagedJDBCDataSourceCallBack callBack) throws IllegalArgumentException {
        super(connectionPoolName, name, callBack.getJ2EEApplicationCallBackIf());
        if (connectionPoolName == null) {
            String msg = DataSourceMessages.severeManagedJDBCDataSourcePoolNameNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_connectionPoolName = connectionPoolName;
        this.init(callBack, false);
    }

    private ManagedJDBCDataSource(Locale locale, ManagedJDBCDataSourceCallBack callBack) throws IllegalArgumentException {
        super(locale);
        this.init(callBack, true);
    }

    public ModelMBeanInfo getMBeanInfo(Locale locale) {
        try {
            return ModelMBeanFactory.getModelMBeanInfo(new ManagedJDBCDataSource(locale, this.m_callBack));
        }
        catch (MBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void validateCallBack() throws IllegalArgumentException {
        if (this.m_callBack == null) {
            String msg = DataSourceMessages.severeManagedJDBCDataSourceCallbackNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_managedDataSource = this.m_callBack.getManagedDataSource();
        if (this.m_managedDataSource == null) {
            String msg = DataSourceMessages.severeManagedJDBCDataSourceManagedDataSourceNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_managedDataSourceConfig = this.m_callBack.getManagedDataSourceConfig();
        if (this.m_managedDataSourceConfig == null) {
            String msg = DataSourceMessages.severeManagedJDBCDataSourceManagedDataSourceConfigNull();
            throw new IllegalArgumentException(msg);
        }
    }

    private void init(ManagedJDBCDataSourceCallBack callBack, boolean localeInit) throws IllegalArgumentException {
        this.m_callBack = callBack;
        this.validateCallBack();
        if (DMSUtils.isDMSActive()) {
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("managedjdbcdatasource_stats"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        }
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("validTransactionLevels", "[Ljava.lang.String;", this.getLocalizedMessage("managedjdbcdatasource_ValidTransactionLevels"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transactionLevel", "java.lang.String", this.getLocalizedMessage("managedjdbcdatasource_TransactionLevel"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        if (this.m_managedDataSource.getManagedConnectionFactory().getDataSourceConnectionPool().isICC()) {
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("activeSQLTrace", "java.lang.Boolean", this.getLocalizedMessage("managedjdbcdatasource_ActiveSQLTrace"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
            MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
            this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("activateSQLTrace", this.getLocalizedMessage("managedjdbcdatasource_activateSQLTrace"), params, "void", 1), NEVER_PERSISTENCE_PROPERTIES);
            this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("deactivateSQLTrace", this.getLocalizedMessage("managedjdbcdatasource_deactivateSQLTrace"), params, "void", 1), NEVER_PERSISTENCE_PROPERTIES);
        }
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("manageLocalTransactions", "java.lang.Boolean", this.getLocalizedMessage("j2eeapplication_createDataSource_manageLocalTransactions"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("manageSqlObjectsValues", "[Ljava.lang.String;", this.getLocalizedMessage("managedjdbcdatasource_manageSqlObjectsValues"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("manageSqlObjects", "java.lang.String", this.getLocalizedMessage("j2eeapplication_createDataSource_manageSqlObjects"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        if (!localeInit) {
            this.m_managedDataSource.setMBean(this);
        }
    }

    public String gettransactionLevel() {
        return this.m_managedDataSourceConfig.getTxLevel();
    }

    public String[] getvalidTransactionLevels() {
        String[] levels = new String[]{"local", "global"};
        return levels;
    }

    public boolean getactiveSQLTrace() {
        ManagedConnectionFactoryImpl managedConnectionFactory = this.m_managedDataSource.getManagedConnectionFactory();
        return managedConnectionFactory.isOracleSQLTraceActive();
    }

    public synchronized void activateSQLTrace() {
        ManagedConnectionFactoryImpl managedConnectionFactory = this.m_managedDataSource.getManagedConnectionFactory();
        managedConnectionFactory.setOracleSQLTraceActive(true);
    }

    public synchronized void deactivateSQLTrace() {
        ManagedConnectionFactoryImpl managedConnectionFactory = this.m_managedDataSource.getManagedConnectionFactory();
        managedConnectionFactory.setOracleSQLTraceActive(false);
    }

    public String getjdbcDriver() throws JMXException {
        return MBeanUtils.getJdbcDriver(this.m_connectionPoolName, this, this.getApplicationName());
    }

    public synchronized void copyDataSource(String newDataSourceName, String jndiLocation) throws MBeanException {
        try {
            this.getApplicationCallBack().copyManagedDataSource(this.getName(), jndiLocation, newDataSourceName);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void removeDataSource() throws DataSourceException, MBeanException {
        this.getApplicationCallBack().removeManagedDataSource(this.getName());
    }

    public String testConnection(String sqlStatement) {
        return this.testConnection(sqlStatement, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String testConnection(String sqlStatement, String user, String password) {
        block11: {
            Connection connection = null;
            connection = user == null && password == null ? this.m_managedDataSource.getConnection() : this.m_managedDataSource.getConnection(user, password);
            Statement statement = connection.createStatement();
            statement.executeQuery(sqlStatement);
            Object var8_7 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block11;
            }
            catch (SQLException sqlException) {
                DataSourceMessages.warningManagedJDBCDataSourceTestConnectionCloseConnection(sqlException);
            }
            break block11;
            {
                catch (Exception exception) {
                    String string = DataSourceMessages.warningManagedJDBCDataSourceTestConnection(exception);
                    Object var8_8 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sqlException) {
                        DataSourceMessages.warningManagedJDBCDataSourceTestConnectionCloseConnection(sqlException);
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqlException) {
                    DataSourceMessages.warningManagedJDBCDataSourceTestConnectionCloseConnection(sqlException);
                }
                throw throwable;
            }
        }
        return "Test was successful.";
    }

    public String getdataSourceName() {
        return this.m_managedDataSource.getDataSourceName();
    }

    public synchronized void setdataSourceName(String dataSourceName) throws MBeanException {
        try {
            this.getApplicationCallBack().renameManagedDataSource(this.m_managedDataSourceConfig.getName(), dataSourceName);
            this.unregisterMBean();
            this.m_managedDataSourceConfig.setName(dataSourceName);
            this.m_managedDataSource.setDataSourceName(dataSourceName);
            this.setName(dataSourceName);
            this.setBaseObjectName();
            this.registerMBean();
        }
        catch (DataSourceConfigException e) {
            throw new MBeanException(e);
        }
        catch (DataSourceException e) {
            throw new MBeanException(e);
        }
        catch (UnSupportedMBeanOperationException e) {
            throw new MBeanException(e);
        }
    }

    public String getjndiName() {
        return this.m_managedDataSourceConfig.getJndiName();
    }

    public String getuser() {
        return this.m_managedDataSourceConfig.getUser();
    }

    public synchronized void setuser(String user) throws MBeanException {
        try {
            this.m_managedDataSourceConfig.setUser(user);
            this.m_managedDataSource.setUser(user);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String getpassword() {
        return this.m_managedDataSourceConfig.getPassword();
    }

    public synchronized void setpassword(String password) throws MBeanException {
        try {
            this.m_managedDataSourceConfig.setPassword(password);
            this.m_managedDataSource.setPassword(password);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public int getloginTimeout() throws MBeanException {
        try {
            return this.m_managedDataSource.getLoginTimeout();
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void setloginTimeout(Integer loginTimeout) throws MBeanException {
        try {
            this.m_managedDataSourceConfig.setLoginTimeout(loginTimeout);
            this.m_managedDataSource.setLoginTimeout(loginTimeout);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public boolean getmanageLocalTransactions() {
        return this.m_managedDataSource.getManageLocalTransactions();
    }

    public synchronized void setmanageLocalTransactions(Boolean manageLocalTransactions) {
        this.m_managedDataSourceConfig.setManageLocalTransactions(manageLocalTransactions);
        this.m_managedDataSource.setManageLocalTransactions(manageLocalTransactions);
    }

    public String[] getmanageSqlObjectsValues() {
        String[] values = new String[]{"basic", "all", "minimal"};
        return values;
    }

    public String getmanageSqlObjects() {
        return this.m_managedDataSource.getManageSqlObjects();
    }

    public synchronized void setmanageSqlObjects(String manageSqlObjects) throws MBeanException {
        try {
            this.m_managedDataSourceConfig.setManageSqlObjects(manageSqlObjects);
            this.m_managedDataSource.setManageSqlObjects(manageSqlObjects);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public ManagedJDBCDataSourceCallBack getCallBack() {
        return this.m_callBack;
    }

    public String getConnectionPoolName() {
        return this.m_connectionPoolName;
    }

    public DMSJDBCConnectionPoolStats getDmsConnectionPoolStats() {
        return this.m_managedDataSource.getManagedConnectionFactory().getDataSourceConnectionPool().getDMSStats();
    }

    public ManagedDataSource getManagedDataSource() {
        return this.m_managedDataSource;
    }

    public boolean getstatisticsProvider() {
        return DMSUtils.isDMSActive();
    }

    public Stats getstats() {
        return new JDBCStatsImpl(this);
    }
}

