/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.xml.XMLUtils;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.config.DataSourceBaseConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedDataSourceConfig
extends DataSourceBaseConfig {
    public static final String ROOT_NODE_NAME = "managed-data-source";
    public static final String CONNECTION_POOL_NAME_ATTRIBUTE = "connection-pool-name";
    public static final String SCHEMA_ATTRIBUTE = "schema";
    public static final String TX_LEVEL_ATTRIBUTE = "tx-level";
    public static final String MANAGE_LOCAL_TRANSACTIONS_ATTRIBUTE = "manage-local-transactions";
    public static final String TX_LEVEL_ATTRIBUTE_VALUE_LOCAL = "local";
    public static final String TX_LEVEL_ATTRIBUTE_VALUE_GLOBAL = "global";
    public static final String DEFAULT_TX_LEVEL = "global";
    public static final boolean DEFAULT_MANAGE_LOCAL_TRANSACTIONS = true;
    public static final String MANAGE_SQL_OBJECTS_ATTRIBUTE = "manage-sql-objects";
    public static final String MANAGE_SQL_OBJECTS_ATTRIBUTE_VALUE_ALL = "all";
    public static final String MANAGE_SQL_OBJECTS_ATTRIBUTE_VALUE_BASIC = "basic";
    public static final String MANAGE_SQL_OBJECTS_ATTRIBUTE_VALUE_MINIMAL = "minimal";
    public static final String DEFAULT_MANAGE_SQL_OBJECTS = "basic";
    private String m_connectionPoolName = "";
    private String m_txLevel = "global";
    private String m_databaseSchemaPath = null;
    private boolean m_manageLocalTransactions = true;
    private String m_manageSqlObjects = "basic";

    public ManagedDataSourceConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setConnectionPoolName();
        this.setTxLevel();
        this.setDatabaseSchemaPath();
        this.setManageLocalTransactions();
        this.setManageSqlObjects();
    }

    public ManagedDataSourceConfig(String user, String password, String connectionPoolName, String jndiName, String name, String txLevel, int loginTimeout, String dbSchema, boolean manageLocalTransactions) throws DataSourceConfigException {
        this(user, password, connectionPoolName, jndiName, name, txLevel, loginTimeout, dbSchema, manageLocalTransactions, "basic");
    }

    public ManagedDataSourceConfig(String user, String password, String connectionPoolName, String jndiName, String name, String txLevel, int loginTimeout, String dbSchema, boolean manageLocalTransactions, String manageSqlObjects) throws DataSourceConfigException {
        super(ROOT_NODE_NAME, user, password, jndiName, name, loginTimeout);
        this.setConnectionPoolName(connectionPoolName);
        this.setTxLevel(txLevel);
        this.setDatabaseSchemaPath(dbSchema);
        this.setManageLocalTransactions(manageLocalTransactions);
        this.setManageSqlObjects(manageSqlObjects);
    }

    public ManagedDataSourceConfig(ManagedDataSourceConfig managedDataSourceConfig) throws DataSourceConfigException {
        this(managedDataSourceConfig.getUser(), managedDataSourceConfig.getPassword(), managedDataSourceConfig.getConnectionPoolName(), managedDataSourceConfig.getJndiName(), managedDataSourceConfig.getName(), managedDataSourceConfig.getTxLevel(), managedDataSourceConfig.getLoginTimeout(), managedDataSourceConfig.getDatabaseSchemaPath(), managedDataSourceConfig.getManageLocalTransactions(), managedDataSourceConfig.getManageSqlObjects());
    }

    public String getConnectionPoolName() {
        return this.m_connectionPoolName;
    }

    public void setConnectionPoolName(String connectionPoolName) throws DataSourceConfigException {
        this.m_connectionPoolName = DataSourceConfigUtils.trimEmptyNotAllowed(connectionPoolName, "Connection pool");
    }

    private void setConnectionPoolName() throws DataSourceConfigException {
        this.setConnectionPoolName(DataSourceConfigUtils.getAttribute(this.getRootNode(), CONNECTION_POOL_NAME_ATTRIBUTE));
    }

    public String getTxLevel() {
        return this.m_txLevel;
    }

    public void setTxLevel(String txLevel) throws DataSourceConfigException {
        if (txLevel == null || txLevel.trim().length() == 0) {
            txLevel = "global";
        }
        if (!txLevel.equals("global") && !txLevel.equals(TX_LEVEL_ATTRIBUTE_VALUE_LOCAL)) {
            throw new DataSourceConfigException("Invalid transactional level: " + txLevel);
        }
        this.m_txLevel = txLevel;
    }

    private void setTxLevel() throws DataSourceConfigException {
        this.setTxLevel(DataSourceConfigUtils.getAttribute(this.getRootNode(), TX_LEVEL_ATTRIBUTE));
    }

    public String getDatabaseSchemaPath() {
        return this.m_databaseSchemaPath;
    }

    public void setDatabaseSchemaPath(String databaseSchemaPath) {
        this.m_databaseSchemaPath = databaseSchemaPath;
    }

    private void setDatabaseSchemaPath() {
        this.setDatabaseSchemaPath(XMLUtils.getNodeAttribute(this.getRootNode(), SCHEMA_ATTRIBUTE));
    }

    public boolean getManageLocalTransactions() {
        return this.m_manageLocalTransactions;
    }

    public void setManageLocalTransactions(boolean manageLocalTransactions) {
        this.m_manageLocalTransactions = manageLocalTransactions;
    }

    private void setManageLocalTransactions() {
        this.setManageLocalTransactions(DataSourceConfigUtils.getBooleanAttribute(this.getRootNode(), MANAGE_LOCAL_TRANSACTIONS_ATTRIBUTE, true));
    }

    public String getManageSqlObjects() {
        return this.m_manageSqlObjects;
    }

    public void setManageSqlObjects(String manageSqlObjects) throws DataSourceConfigException {
        if (manageSqlObjects == null || manageSqlObjects.trim().length() == 0) {
            manageSqlObjects = "basic";
        }
        if (!(manageSqlObjects.equals(MANAGE_SQL_OBJECTS_ATTRIBUTE_VALUE_ALL) || manageSqlObjects.equals("basic") || manageSqlObjects.equals(MANAGE_SQL_OBJECTS_ATTRIBUTE_VALUE_MINIMAL))) {
            throw new DataSourceConfigException("Invalid value, '" + manageSqlObjects + "' for the " + MANAGE_SQL_OBJECTS_ATTRIBUTE + " attribute.");
        }
        this.m_manageSqlObjects = manageSqlObjects;
    }

    private void setManageSqlObjects() throws DataSourceConfigException {
        this.setManageSqlObjects(DataSourceConfigUtils.getAttribute(this.getRootNode(), MANAGE_SQL_OBJECTS_ATTRIBUTE));
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        if (this.getUser() != null) {
            element.setAttribute("user", this.getUser());
        }
        if (this.getPassword() != null) {
            element.setAttribute("password", this.getPassword());
        }
        if (this.getLoginTimeout() != 0) {
            element.setAttribute("login-timeout", new Integer(this.getLoginTimeout()).toString());
        }
        element.setAttribute(CONNECTION_POOL_NAME_ATTRIBUTE, this.m_connectionPoolName);
        element.setAttribute("jndi-name", this.getJndiName());
        element.setAttribute("name", this.getName());
        if (!this.m_txLevel.equals("global")) {
            element.setAttribute(TX_LEVEL_ATTRIBUTE, this.m_txLevel);
        }
        if (this.m_databaseSchemaPath != null && this.m_databaseSchemaPath.trim().length() != 0) {
            element.setAttribute(SCHEMA_ATTRIBUTE, this.m_databaseSchemaPath);
        }
        if (!this.m_manageLocalTransactions) {
            element.setAttribute(MANAGE_LOCAL_TRANSACTIONS_ATTRIBUTE, new Boolean(this.m_manageLocalTransactions).toString());
        }
        if (!this.m_manageSqlObjects.equals("basic")) {
            element.setAttribute(MANAGE_SQL_OBJECTS_ATTRIBUTE, this.m_manageSqlObjects);
        }
        return element;
    }

    public String createXMLString() throws DataSourceConfigException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node node = this.createXML(document);
            document.appendChild(node);
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (Exception exception) {
            String msg = DataSourceMessages.severeConfigCreateXMLException(this.getRootNodeName(), exception);
            throw new DataSourceConfigException(msg, exception);
        }
    }
}

