/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import java.io.Serializable;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class ConfigObject
implements Serializable {
    private transient Node m_rootNode;
    private String m_rootNodeName;

    public ConfigObject(String rootNodeName) throws DataSourceConfigException {
        this.m_rootNodeName = DataSourceConfigUtils.trimEmptyNotAllowed(rootNodeName, "root node name");
    }

    public ConfigObject(Node rootNode) throws DataSourceConfigException {
        if (rootNode == null) {
            throw new DataSourceConfigException("The root node cannot be null.");
        }
        this.m_rootNode = rootNode;
        this.m_rootNodeName = rootNode.getNodeName();
    }

    public Node getRootNode() {
        return this.m_rootNode;
    }

    public String getRootNodeName() {
        return this.m_rootNodeName;
    }

    protected abstract Node createXML(Document var1) throws Exception;
}

