/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.BaseDataSource;

public class DriverDataSource
extends BaseDataSource {
    public static final String USER_PROPERTY_KEY = "user";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    private Driver m_driver = null;
    private Properties m_driverProperties = null;
    private String m_url = null;

    public DriverDataSource(Driver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("The driver cannot be null.");
        }
        this.m_driver = driver;
    }

    public Connection getConnection() throws SQLException {
        String user = null;
        String password = null;
        if (this.m_driverProperties != null) {
            user = (String)this.m_driverProperties.get(USER_PROPERTY_KEY);
            password = (String)this.m_driverProperties.get(PASSWORD_PROPERTY_KEY);
        }
        if (user == null) {
            user = this.getUser();
        }
        if (password == null) {
            password = this.getPassword();
        }
        return this.getConnection(user, password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.m_url == null) {
            throw new SQLException("The url may not be null.");
        }
        Properties driverProperties = null;
        driverProperties = this.m_driverProperties == null ? new Properties() : this.copyDriverProperties();
        if (username != null) {
            driverProperties.put(USER_PROPERTY_KEY, username);
        }
        if (password != null) {
            driverProperties.put(PASSWORD_PROPERTY_KEY, password);
        }
        Connection connection = null;
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugBeforeGetConnection(this.m_driver);
        }
        try {
            connection = this.m_driver.connect(this.m_url, driverProperties);
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        finally {
            if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
                DataSourceMessages.debugAfterGetConnection(this.m_driver);
            }
        }
        return connection;
    }

    protected Properties copyDriverProperties() {
        Properties properties = new Properties();
        try {
            if (this.m_driverProperties != null) {
                String key = null;
                String value = null;
                Enumeration<Object> enum5 = this.m_driverProperties.keys();
                while (enum5.hasMoreElements()) {
                    key = (String)enum5.nextElement();
                    value = this.m_driverProperties.getProperty(key);
                    if (value == null) continue;
                    properties.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            DataSourceMessages.warningDriverProperties(exception);
        }
        return properties;
    }

    public Driver getDriver() {
        return this.m_driver;
    }

    public String getDriverProperty(String key) {
        if (key == null || this.m_driverProperties == null) {
            return null;
        }
        return this.m_driverProperties.getProperty(key);
    }

    public void setDriverProperty(String key, String value) {
        if (key == null || value == null) {
            DataSourceMessages.warningSetDriverPropertyNull();
        }
        if (key != null && value != null) {
            if (this.m_driverProperties == null) {
                this.m_driverProperties = new Properties();
            }
            this.m_driverProperties.setProperty(key, value);
            DataSourceMessages.infoSetDriverProperty(key, value);
        }
    }

    public Properties getDriverProperties() {
        return this.m_driverProperties;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("The url may not be null.");
        }
        this.m_url = url;
    }
}

