/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionFactory;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;

public class DataSourceConnectionFactoryImpl
implements DataSourceConnectionFactory {
    private XADataSource m_xaDataSource = null;
    private Object m_connectionFactory = null;
    private ConnectionFactoryConfig m_connectionFactoryConfig;

    public DataSourceConnectionFactoryImpl(XADataSource xaDataSource, Object connectionFactory, ConnectionFactoryConfig connectionFactoryConfig) throws IllegalArgumentException {
        this.setXADataSource(xaDataSource);
        this.setConnectionFactory(connectionFactory);
        this.setConnectionFactoryConfig(connectionFactoryConfig);
    }

    public XADataSource getXADataSource() {
        return this.m_xaDataSource;
    }

    public void setXADataSource(XADataSource xaDataSource) throws IllegalArgumentException {
        if (xaDataSource == null) {
            throw new IllegalArgumentException("The XADataSource cannot be null");
        }
        this.m_xaDataSource = xaDataSource;
    }

    public Object getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public void setConnectionFactory(Object connectionFactory) throws IllegalArgumentException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("The connection factory cannot be null");
        }
        this.m_connectionFactory = connectionFactory;
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.m_connectionFactoryConfig;
    }

    public void setConnectionFactoryConfig(ConnectionFactoryConfig connectionFactoryConfig) throws IllegalArgumentException {
        if (connectionFactoryConfig == null) {
            throw new IllegalArgumentException("The connection factory configuraiton cannot be null");
        }
        this.m_connectionFactoryConfig = connectionFactoryConfig;
    }

    public String testConnection(String sqlStatement) {
        return this.testConnection(sqlStatement, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String testConnection(String sqlStatement, String user, String password) {
        XAConnection xaConnection = null;
        xaConnection = user == null && password == null ? this.getXADataSource().getXAConnection() : this.getXADataSource().getXAConnection(user, password);
        Connection connection = xaConnection.getConnection();
        Statement statement = connection.createStatement();
        statement.executeQuery(sqlStatement);
        Object var8_9 = null;
        if (xaConnection == null) return "Test was successful.";
        try {
            xaConnection.close();
            return "Test was successful.";
        }
        catch (SQLException sqlException) {
            DataSourceMessages.warningTestConnectionCloseXAConnection(sqlException);
        }
        return "Test was successful.";
        {
            catch (Exception exception) {
                String string = DataSourceMessages.warningTestConnectionException(exception);
                Object var8_10 = null;
                if (xaConnection == null) return string;
                try {
                    xaConnection.close();
                    return string;
                }
                catch (SQLException sqlException) {
                    DataSourceMessages.warningTestConnectionCloseXAConnection(sqlException);
                }
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (xaConnection == null) throw throwable;
            try {
                xaConnection.close();
                throw throwable;
            }
            catch (SQLException sqlException) {
                DataSourceMessages.warningTestConnectionCloseXAConnection(sqlException);
            }
            throw throwable;
        }
    }
}

