/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.server.http.deployment.ServletDescriptor;
import com.evermind.util.Base64Utils;
import com.evermind.util.ByteString;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.oc4j.security.CsiV2Support;
import oracle.security.jazn.ApplicationServerProxy;

public class ApplicationServerProxyImpl
extends ApplicationServerProxy {
    private HttpRequestHandler getHttpRequestHandler() {
        ThreadState threadState = ThreadState.getCurrentState();
        if (threadState.applicationThread != null) {
            return threadState.applicationThread.httpHandler;
        }
        return null;
    }

    private HttpApplication getHttpApplication() {
        HttpServletRequest request = ApplicationServerProxyImpl.getHttpServletRequest();
        if (request != null && request instanceof EvermindHttpServletRequest) {
            return ((EvermindHttpServletRequest)request).getApplication();
        }
        return null;
    }

    private HttpApplicationConfig getHttpApplicationConfig() {
        HttpApplication htpApp = this.getHttpApplication();
        if (htpApp != null) {
            return htpApp.getConfig();
        }
        return null;
    }

    private Application getApplication() {
        ThreadState threadState = ThreadState.getCurrentState();
        if (threadState != null && threadState.contextContainer != null) {
            try {
                return threadState.contextContainer.getApplication();
            }
            catch (NamingException ne) {
                ne.printStackTrace();
            }
        }
        return null;
    }

    private final ServletDescriptor getServletDescriptor(Servlet currentServlet) {
        ServletDescriptor descriptor = null;
        if (currentServlet.getServletConfig() != null) {
            String servletname = currentServlet.getServletConfig().getServletName();
            descriptor = this.getHttpApplicationConfig().getServletDescriptor(servletname, false);
        }
        return descriptor;
    }

    public String doGetApplicationName() {
        if (this.getHttpApplication() != null) {
            return this.getHttpApplication().getName();
        }
        if (this.getApplication() != null) {
            return this.getApplication().getName();
        }
        return null;
    }

    public HttpServletRequest doGetHttpServletRequest() {
        HttpRequestHandler handler = this.getHttpRequestHandler();
        if (handler != null) {
            return handler.request;
        }
        return null;
    }

    public HttpServletResponse doGetHttpServletResponse() {
        HttpRequestHandler handler = this.getHttpRequestHandler();
        if (handler != null) {
            return handler.response;
        }
        return null;
    }

    public HttpSession doGetHttpSession(boolean create) {
        HttpServletRequest request = this.doGetHttpServletRequest();
        if (request != null) {
            return request.getSession(create);
        }
        return null;
    }

    public String doGetRunAsRole(HttpServletRequest hreq) {
        if (!(hreq instanceof EvermindHttpServletRequest)) {
            return null;
        }
        ServletDescriptor descriptor = this.getServletDescriptor(((EvermindHttpServletRequest)hreq).currentPostFilterServlet);
        if (descriptor != null) {
            return descriptor.getRunAsRoleName();
        }
        return null;
    }

    public boolean doGetIsRegionProtected(HttpServletRequest hreq) {
        HttpApplication happ = null;
        EvermindHttpServletRequest sreq = null;
        return hreq != null && hreq instanceof EvermindHttpServletRequest && (happ = (sreq = (EvermindHttpServletRequest)hreq).getApplication()) != null && happ.getProtectedRegion(sreq.getRequestURIWithoutContext(), sreq.getMethod()) != null;
    }

    public void doInvalidateUser(HttpServletRequest request) {
        EvermindHttpServletRequest sreq = null;
        if (request != null && request instanceof EvermindHttpServletRequest) {
            sreq = (EvermindHttpServletRequest)request;
            sreq.setRemoteUser(null);
        }
    }

    public List doGetGroupsForRole(String roleName) {
        SecurityRole srole;
        HttpApplicationConfig htpAppConfig = this.getHttpApplicationConfig();
        if (htpAppConfig != null && (srole = htpAppConfig.getSecurityRole(roleName)) != null) {
            return srole.getGroups();
        }
        return null;
    }

    public void doSetCertificateAsAttribute(ServletRequest request, String attributeName) {
        if (!(request instanceof AJPHttpServletRequest)) {
            return;
        }
        try {
            ByteString sslcert = ((AJPHttpServletRequest)request).getSSLCert();
            if (sslcert == null) {
                return;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(sslcert.getBytes());
            X509Certificate[] certArray = new X509Certificate[1];
            Certificate cert = null;
            while (bais.available() > 0) {
                cert = cf.generateCertificate(bais);
                certArray[0] = (X509Certificate)cert;
            }
            request.setAttribute(attributeName, (Object)certArray);
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object doCreatePasswordCredential(String username, char[] password, String realm) {
        return CsiV2Support.createPasswordCredential(username, password, realm);
    }

    public Object doCreateGSSUPName(String name, String realm) {
        return CsiV2Support.createGSSUPName(name, realm);
    }

    public byte[] doBase64Decode(char[] chars) {
        return Base64Utils.decode(chars);
    }

    public UserManager doGetUserManager() {
        Application app = this.getApplication();
        return app != null ? app.getUserManager() : null;
    }

    public String doGetApplicationRootDirectoryPath() {
        Application app = this.getApplication();
        return app != null ? app.getapplicationRootDirectoryPath() : null;
    }
}

