/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi.tunnelling;

import com.evermind.server.rmi.Credentials;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIProtocol;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import com.evermind.util.Base64Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.RmiServerResetException;
import oracle.oc4j.rmi.tunnelling.TunnelledRmiTransport;
import oracle.oc4j.rmi.tunnelling.TunnelledServerRmiMessageHandler;
import oracle.oc4j.security.CryptoException;
import oracle.oc4j.security.ExchangingEncryptor;
import oracle.oc4j.util.NamedParameterList;

public class TunnelledRmiServlet
extends HttpServlet {
    static final String HANDLER_ATTRIBUTE = "rmi.tunnel.handler";
    static final String ENCRYPTOR_ATTRIBUTE = "rmi.tunnel.encryptor";
    private static Logger m_logger = TraceLogger.getLogger(TunnelledRmiServlet.class);
    private static int BASIC_AUTHENTICATION = 0;
    private static int KEY_EXCHANGE_AUTHENTICATION = 1;
    private int m_authenticationType = KEY_EXCHANGE_AUTHENTICATION;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String authenticationType = config.getInitParameter("authentication");
        if ("basic".equalsIgnoreCase(authenticationType)) {
            this.m_authenticationType = BASIC_AUTHENTICATION;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ServerRmiMessageHandler handler;
            m_logger.finer("Received post request");
            HttpSession session = request.getSession();
            TunnelledServerRmiMessageHandler handlerProxy = (TunnelledServerRmiMessageHandler)session.getAttribute(HANDLER_ATTRIBUTE);
            ServerRmiMessageHandler serverRmiMessageHandler = handler = null == handlerProxy ? null : handlerProxy.getHandler();
            if (handler != null) {
                ServletOutputStream os = response.getOutputStream();
                os.flush();
                handler.handleSingleRequest((InputStream)request.getInputStream(), (OutputStream)os);
            } else {
                if (handlerProxy != null) {
                    throw new RmiServerResetException("handler not initialized");
                }
                m_logger.finer("handling new connection");
                handlerProxy = TunnelledServerRmiMessageHandler.createMessageHandler(this.getDomain(request));
                handler = handlerProxy.getHandler();
                this.authenticate(request, handler);
                this.validateConnectionRequest(handler, request, response);
                session.setAttribute(HANDLER_ATTRIBUTE, (Object)handlerProxy);
            }
        }
        catch (RmiServerResetException e) {
            m_logger.log(Level.FINER, "Requesting client to reset its connection");
            response.setHeader("x-failover", "yes");
        }
        catch (UnrecognizedConnectionTypeException e) {
            m_logger.log(Level.FINER, "Unrecognized connection type", e);
            response.sendError(406, e.toString());
        }
        catch (RMILoginFailedException e) {
            m_logger.log(Level.FINER, "Login rejected", e);
            this.sendChallengeHeader(request, response);
        }
    }

    private void validateConnectionRequest(ServerRmiMessageHandler handler, HttpServletRequest request, HttpServletResponse response) throws IOException, RMILoginFailedException {
        m_logger.finer("in validateConnectionResponse");
        handler.getProtocol().writeConnectionHeader((OutputStream)response.getOutputStream());
        handler.getProtocol().readConnectionHeader((InputStream)request.getInputStream(), new RMIProtocol.ConnectionTypeValidation(){

            public void validateConnectionType(int type) {
                throw new UnrecognizedConnectionTypeException(type);
            }
        });
    }

    private void authenticate(HttpServletRequest request, ServerRmiMessageHandler handler) throws CryptoException, RMILoginFailedException, RmiServerResetException {
        m_logger.finer("checking credentials");
        String header = request.getHeader("Authorization");
        if (header == null) {
            throw new RMILoginFailedException("No authorization header");
        }
        if (this.m_authenticationType == BASIC_AUTHENTICATION) {
            handler.login(this.readBasicCredentials(header));
        } else if (this.m_authenticationType == KEY_EXCHANGE_AUTHENTICATION) {
            handler.login(this.readKeyExchangeCredentials(request, header));
        } else {
            throw new RMILoginFailedException("Unsupported authentication type: " + this.m_authenticationType);
        }
    }

    private ServletCredentials readKeyExchangeCredentials(HttpServletRequest request, String header) throws RMILoginFailedException, CryptoException, RmiServerResetException {
        if (request.getSession().getAttribute(ENCRYPTOR_ATTRIBUTE) == null) {
            throw new RmiServerResetException("Authorization header uses unknown challenge header parameters");
        }
        if (!header.toLowerCase().startsWith("keyexchange ")) {
            throw new RMILoginFailedException("Not a valid key exchange authorization header: " + header);
        }
        NamedParameterList params = NamedParameterList.parse(header);
        if (params.get("key") == null || params.get("username") == null || params.get("password") == null) {
            throw new RMILoginFailedException("key exchange authorization header not valid");
        }
        ExchangingEncryptor encryptor = this.getEncryptor(request);
        encryptor.setRemotePublicKey(params.getBase64Decoded("key"));
        String username = params.get("username");
        String password = encryptor.getDecryptedValue(params.getBase64Decoded("password"));
        ServletCredentials credentials = new ServletCredentials(username, password);
        return credentials;
    }

    private ServletCredentials readBasicCredentials(String header) throws RMILoginFailedException {
        if (!header.toLowerCase().startsWith("basic ")) {
            throw new RMILoginFailedException("Not a valid basic authorization header: " + header);
        }
        String rawCredentials = header.substring("basic".length()).trim();
        StringTokenizer st = new StringTokenizer(new String(Base64Utils.decode(rawCredentials.toCharArray())), ":");
        String username = st.nextToken();
        String password = !st.hasMoreTokens() ? null : st.nextToken();
        return new ServletCredentials(username, password);
    }

    private void sendChallengeHeader(HttpServletRequest request, HttpServletResponse response) throws CryptoException {
        response.setHeader("WWW-Authenticate", this.createChallengeHeader(request));
        response.setStatus(401);
    }

    private String createChallengeHeader(HttpServletRequest request) throws CryptoException {
        if (this.m_authenticationType == BASIC_AUTHENTICATION) {
            return "Basic realm=\"ORMI\"";
        }
        ExchangingEncryptor encryptor = this.getEncryptor(request);
        NamedParameterList parameterList = NamedParameterList.create();
        parameterList.put("realm", "ORMI");
        parameterList.put("key", encryptor.getLocalPublicKey());
        return "KeyExchange " + parameterList;
    }

    private ExchangingEncryptor getEncryptor(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ExchangingEncryptor encryptor = (ExchangingEncryptor)session.getAttribute(ENCRYPTOR_ATTRIBUTE);
        if (encryptor == null) {
            m_logger.finer("creating new HttpSession / Encryptor");
            encryptor = ExchangingEncryptor.create();
            session.setAttribute(ENCRYPTOR_ATTRIBUTE, (Object)encryptor);
        }
        return encryptor;
    }

    private String getDomain(HttpServletRequest request) {
        return TunnelledRmiTransport.getDomain(request.getServletPath());
    }

    class ServletCredentials
    implements Credentials {
        private String m_username;
        private String m_password;

        public ServletCredentials(String username, String password) {
            this.m_username = username;
            this.m_password = password;
        }

        public String getPassword() {
            return this.m_password;
        }

        public String getUsername() {
            return this.m_username;
        }
    }

    class UnrecognizedConnectionTypeException
    extends RuntimeException {
        public UnrecognizedConnectionTypeException(int type) {
            super("Unrecognized connection type " + type);
        }
    }
}

