/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.classloader.util.ArrayUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class ClassFormatter
implements ClassVisitor {
    private int access;
    private String unqualifiedClassName;
    private String packageName;
    private String superName;
    private String[] interfaces;
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private Map unqualifiedNameToPackage = new HashMap();
    private Set imports = new HashSet();
    private boolean isInterface;

    public static ClassFormatter getStringFormatter(Class c) throws IOException {
        InputStream classData = ClassFormatter.getClassData(c);
        return ClassFormatter.initFormatter(classData, new ClassFormatter());
    }

    public static ClassFormatter getStringFormatter(InputStream classData) throws IOException {
        return ClassFormatter.initFormatter(classData, new ClassFormatter());
    }

    public static ClassFormatter getHTMLFormatter(Class c) throws IOException {
        InputStream classData = ClassFormatter.getClassData(c);
        return ClassFormatter.initFormatter(classData, new HTMLClassFormatter());
    }

    public static ClassFormatter getHTMLFormatter(InputStream classData) throws IOException {
        return ClassFormatter.initFormatter(classData, new HTMLClassFormatter());
    }

    private static InputStream getClassData(Class c) {
        ClassLoader loader = c.getClassLoader();
        return loader.getResourceAsStream(c.getName().replace('.', '/') + ".class");
    }

    public static ClassFormatter initFormatter(InputStream classData, ClassFormatter formatter) throws IOException {
        byte[] bytes = ArrayUtils.read((InputStream)classData);
        ClassReader reader = new ClassReader(bytes, 0, bytes.length);
        reader.accept((ClassVisitor)formatter, false);
        return formatter;
    }

    protected ClassFormatter() {
    }

    public String toString() {
        StringWriter w;
        try {
            w = new StringWriter();
            this.write(w);
        }
        catch (Exception e) {
            return e.toString();
        }
        return ((Object)w).toString();
    }

    public void write(Writer out) throws Exception {
        if (this.packageName != null) {
            this.writeKeyword("package", out);
            out.write(32);
            out.write(this.packageName);
            out.write(59);
            this.writeEOL(out);
            this.writeEOL(out);
        }
        ArrayList theImports = new ArrayList(this.imports);
        Collections.sort(theImports);
        Iterator iterator = theImports.iterator();
        while (iterator.hasNext()) {
            String i = (String)iterator.next();
            this.writeKeyword("import", out);
            out.write(32);
            this.writeClass(null, i, out);
            out.write(59);
            this.writeEOL(out);
        }
        if (!this.imports.isEmpty()) {
            this.writeEOL(out);
        }
        this.writeKeyword(this.getClassModifiers(this.access), out);
        out.write(32);
        this.writeClass(this.unqualifiedClassName, null, out);
        if (this.superName != null && !this.superName.equals("java.lang.Object")) {
            out.write(32);
            this.writeKeyword("extends", out);
            out.write(32);
            this.writeClassName(this.superName, out);
        }
        if (this.interfaces != null && this.interfaces.length > 0) {
            out.write(32);
            this.writeKeyword("implements", out);
            out.write(32);
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (i > 0) {
                    out.write(", ");
                }
                this.writeClassName(this.interfaces[i], out);
            }
        }
        out.write(" {");
        this.writeEOL(out);
        boolean hasFields = false;
        Iterator iterator2 = this.fields.iterator();
        while (iterator2.hasNext()) {
            Field f = (Field)iterator2.next();
            this.writeIndent(out);
            f.write(out);
            this.writeEOL(out);
            hasFields = true;
        }
        if (hasFields) {
            this.writeEOL(out);
        }
        iterator2 = this.methods.iterator();
        while (iterator2.hasNext()) {
            Method m = (Method)iterator2.next();
            this.writeIndent(out);
            m.write(out);
            this.writeEOL(out);
        }
        out.write(125);
        this.writeEOL(out);
    }

    protected void writeKeyword(String keyWord, Writer out) throws Exception {
        out.write(keyWord);
    }

    protected void writeFieldName(String fieldName, Writer out) throws Exception {
        out.write(fieldName);
    }

    protected void writeIndent(Writer out) throws Exception {
        out.write("    ");
    }

    protected void writeEOL(Writer out) throws Exception {
        out.write("\n");
    }

    protected void writeClass(String unqualifiedName, String fullyQualifiedName, Writer out) throws Exception {
        if (unqualifiedName == null) {
            out.write(fullyQualifiedName);
        } else {
            out.write(unqualifiedName);
        }
    }

    private void writeType(Type type, Writer out) throws Exception {
        switch (type.getSort()) {
            case 0: {
                this.writeKeyword("void", out);
                break;
            }
            case 1: {
                this.writeKeyword("boolean", out);
                break;
            }
            case 2: {
                this.writeKeyword("char", out);
                break;
            }
            case 3: {
                this.writeKeyword("byte", out);
                break;
            }
            case 4: {
                this.writeKeyword("short", out);
                break;
            }
            case 5: {
                this.writeKeyword("int", out);
                break;
            }
            case 6: {
                this.writeKeyword("float", out);
                break;
            }
            case 7: {
                this.writeKeyword("long", out);
                break;
            }
            case 8: {
                this.writeKeyword("double", out);
                break;
            }
            case 9: {
                this.writeType(type.getElementType(), out);
                for (int i = 0; i < type.getDimensions(); ++i) {
                    out.write("[]");
                }
                break;
            }
            case 10: {
                String className = type.getClassName();
                this.writeClassName(className, out);
                break;
            }
            default: {
                out.write(type.toString());
            }
        }
    }

    private void writeClassName(String className, Writer out) throws Exception {
        String unqualifiedName = ClassFormatter.getUnqualifiedName(className);
        if (this.imports.contains(className)) {
            this.writeClass(unqualifiedName, className, out);
        } else {
            String packageName = ClassFormatter.getPackageName(className);
            if (unqualifiedName != null && packageName != null && (packageName.equals(this.packageName) || packageName.equals("java.lang"))) {
                this.writeClass(unqualifiedName, className, out);
            } else {
                this.writeClass(null, className, out);
            }
        }
    }

    private Type recordType(Type type) {
        switch (type.getSort()) {
            case 9: {
                this.recordType(type.getElementType());
                break;
            }
            case 10: {
                this.recordClass(type.getClassName());
            }
        }
        return type;
    }

    private String recordClass(String className) {
        String pkgName = ClassFormatter.getPackageName(className);
        String unqualifiedName = ClassFormatter.getUnqualifiedName(className);
        if (pkgName != null && !this.unqualifiedNameToPackage.containsKey(unqualifiedName)) {
            this.unqualifiedNameToPackage.put(unqualifiedName, pkgName);
        }
        return className;
    }

    private String toClass(String name) {
        String result = name.replace('/', '.');
        return this.recordClass(result);
    }

    private Type getReturnType(String desc) {
        Type result = Type.getReturnType((String)desc);
        return this.recordType(result);
    }

    private Type[] getArgumentTypes(String desc) {
        Type[] types = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < types.length; ++i) {
            this.recordType(types[i]);
        }
        return types;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.access = access;
        String className = this.toClass(name);
        this.unqualifiedClassName = ClassFormatter.getUnqualifiedName(className);
        this.packageName = ClassFormatter.getPackageName(className);
        this.superName = superName == null ? null : this.toClass(superName);
        this.interfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String intf;
            this.interfaces[i] = intf = this.toClass(interfaces[i]);
        }
        this.isInterface = (access & 0x200) > 0;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        Field f = new Field(access, name, desc, value, attrs);
        this.fields.add(f);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        Method m = new Method(access, name, desc, exceptions, attrs);
        this.methods.add(m);
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
        Iterator iterator = this.unqualifiedNameToPackage.keySet().iterator();
        while (iterator.hasNext()) {
            String unqualifiedName = (String)iterator.next();
            String packageName = (String)this.unqualifiedNameToPackage.get(unqualifiedName);
            if (packageName == null || packageName.equals(this.packageName) || packageName.equals("java.lang")) continue;
            this.imports.add(packageName + "." + unqualifiedName);
        }
    }

    private static String getPackageName(String fullName) {
        String result = null;
        int last = fullName.lastIndexOf(46);
        if (last > 0) {
            result = fullName.substring(0, last);
        }
        return result;
    }

    private static String getUnqualifiedName(String fullName) {
        String result = fullName;
        int last = fullName.lastIndexOf(46);
        if (last > 0) {
            result = fullName.substring(last + 1);
        }
        return result;
    }

    private static void append(String str, StringBuffer buf) {
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(str);
    }

    private String getClassModifiers(int access) {
        StringBuffer buf = new StringBuffer();
        if ((access & 1) > 0) {
            ClassFormatter.append("public", buf);
        }
        if ((access & 0x400) > 0 && (access & 0x200) == 0) {
            ClassFormatter.append("abstract", buf);
        }
        if ((access & 0x10) > 0) {
            ClassFormatter.append("final", buf);
        }
        if ((access & 0x200) > 0) {
            ClassFormatter.append("interface", buf);
        } else {
            ClassFormatter.append("class", buf);
        }
        return buf.toString();
    }

    private String getMethodModifiers(int access) {
        StringBuffer buf = new StringBuffer();
        if ((access & 1) > 0) {
            ClassFormatter.append("public", buf);
        } else if ((access & 4) > 0) {
            ClassFormatter.append("protected", buf);
        } else if ((access & 2) > 0) {
            ClassFormatter.append("private", buf);
        }
        if ((access & 8) > 0) {
            ClassFormatter.append("static", buf);
        }
        if (!this.isInterface && (access & 0x400) > 0) {
            ClassFormatter.append("abstract", buf);
        }
        if ((access & 0x10) > 0) {
            ClassFormatter.append("final", buf);
        }
        if ((access & 0x20) > 0) {
            ClassFormatter.append("synchronized", buf);
        }
        if ((access & 0x100) > 0) {
            ClassFormatter.append("native", buf);
        }
        return buf.toString();
    }

    public static class HTMLClassFormatter
    extends ClassFormatter {
        protected HTMLClassFormatter() {
        }

        protected void writeEOL(Writer out) throws Exception {
            out.write("<br>\n");
        }

        protected void writeFieldName(String fieldName, Writer out) throws Exception {
            out.write("<span class=\"field\">");
            out.write(fieldName);
            out.write("</span>");
        }

        protected void writeKeyword(String keyWord, Writer out) throws Exception {
            out.write("<span class=\"key\">");
            out.write(keyWord);
            out.write("</span>");
        }

        protected void writeIndent(Writer out) throws Exception {
            out.write("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
    }

    private class Method {
        private int access;
        private Type result;
        private String name;
        private Type[] arguments;
        private String[] exceptions;
        private Attribute attributes;
        private boolean isAbstract;

        public Method(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            this.access = access;
            this.name = name;
            this.result = ClassFormatter.this.getReturnType(desc);
            this.arguments = ClassFormatter.this.getArgumentTypes(desc);
            if (exceptions != null) {
                this.exceptions = new String[exceptions.length];
                for (int i = 0; i < exceptions.length; ++i) {
                    this.exceptions[i] = ClassFormatter.this.toClass(exceptions[i]);
                }
            }
            this.attributes = attrs;
            if (name.equals("<init>")) {
                this.name = ClassFormatter.this.unqualifiedClassName;
                this.result = null;
            } else if (name.equals("<clinit>")) {
                this.name = null;
                this.result = null;
            }
            this.isAbstract = (access & 0x400) > 0;
        }

        public void write(Writer out) throws Exception {
            boolean started;
            String mods = ClassFormatter.this.getMethodModifiers(this.access);
            ClassFormatter.this.writeKeyword(mods, out);
            boolean bl = started = mods.length() > 0;
            if (this.result != null) {
                if (started) {
                    out.write(32);
                }
                ClassFormatter.this.writeType(this.result, out);
                started = true;
            }
            if (this.name != null) {
                int i;
                if (started) {
                    out.write(32);
                }
                out.write(this.name);
                out.write("(");
                for (i = 0; i < this.arguments.length; ++i) {
                    Type arg = this.arguments[i];
                    if (i > 0) {
                        out.write(", ");
                    }
                    ClassFormatter.this.writeType(arg, out);
                }
                out.write(41);
                if (this.exceptions != null && this.exceptions.length > 0) {
                    out.write(32);
                    ClassFormatter.this.writeKeyword("throws", out);
                    out.write(32);
                    for (i = 0; i < this.exceptions.length; ++i) {
                        if (i > 0) {
                            out.write(", ");
                        }
                        ClassFormatter.this.writeClassName(this.exceptions[i], out);
                    }
                }
            }
            if (ClassFormatter.this.isInterface || this.isAbstract) {
                out.write(";");
            } else {
                out.write(" {...};");
            }
        }
    }

    private class Field {
        private int access;
        private String name;
        private Type type;
        private Object value;
        private Attribute attrs;

        public Field(int access, String name, String desc, Object value, Attribute attrs) {
            this.access = access;
            this.name = name;
            this.type = ClassFormatter.this.getReturnType(desc);
            this.value = value;
            this.attrs = attrs;
        }

        public void write(Writer out) throws Exception {
            String mods = ClassFormatter.this.getMethodModifiers(this.access);
            ClassFormatter.this.writeKeyword(mods, out);
            if (mods.length() > 0) {
                out.write(32);
            }
            ClassFormatter.this.writeType(this.type, out);
            out.write(32);
            ClassFormatter.this.writeFieldName(this.name, out);
            if (this.value != null) {
                out.write(" = ");
                if (this.type.getSort() == 10 && this.type.getClassName().equals("java.lang.String")) {
                    out.write(34);
                    out.write(this.value.toString());
                    out.write(34);
                } else if (this.type == Type.CHAR_TYPE) {
                    out.write("'");
                    out.write((char)((Integer)this.value).intValue());
                    out.write("'");
                } else {
                    out.write(this.value.toString());
                }
            }
            out.write(59);
        }
    }
}

