/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import com.evermind.server.ApplicationServer;
import com.evermind.util.ThreadPool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.classloader.query.ReportQuery;
import oracle.oc4j.query.QueryUtils;

public abstract class ThreadPoolQuery
extends ReportQuery {
    public ApplicationServer as() {
        return ApplicationServer.getInstance();
    }

    public ThreadPool sys() {
        return this.as().getThreadPool();
    }

    public ThreadPool req() {
        return this.as().getRequestThreadPool();
    }

    public ThreadPool cx() {
        return this.as().getConnectionThreadPool();
    }

    public ThreadGroup rootThreadGroup() {
        ThreadGroup rootGroup;
        ThreadGroup parent = Thread.currentThread().getThreadGroup();
        do {
            rootGroup = parent;
        } while ((parent = parent.getParent()) != null);
        return rootGroup;
    }

    public String dumpCallMethodOnObject(Object obj, String className, String methodName) throws ClassNotFoundException {
        String ret = "";
        Object retObj = this.callMethodOnObject(obj, className, methodName);
        ret = ret + className + "." + methodName + "() = ";
        ret = ret + " " + QueryUtils.dump(retObj);
        return ret;
    }

    public Object callMethodOnObject(Object obj, String className, String methodName) throws ClassNotFoundException {
        Object aObject = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = loader.loadClass(className);
            Method aMethod = cls.getMethod(methodName, null);
            aObject = aMethod.invoke(obj, null);
        }
        catch (IllegalAccessException e) {
            this.appendln(obj + " " + className + " " + methodName);
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            this.appendln(obj + " " + className + " " + methodName);
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            this.appendln(obj + " " + className + " " + methodName);
            this.appendln(QueryUtils.getStackTrace(e));
        }
        return aObject;
    }

    public Object callStaticMethodOnClass(String className, String instanceMethodName) throws ClassNotFoundException {
        Object aObject = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> aClass = loader.loadClass(className);
            Method aMethod = aClass.getMethod(instanceMethodName, null);
            aObject = aMethod.invoke(null, null);
        }
        catch (IllegalAccessException e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
        return aObject;
    }
}

