/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Properties;
import oracle.classloader.query.ReportQuery;
import oracle.oc4j.query.VMStat;

public class QueryUtils {
    private static Properties envs = null;
    public static final String javaHome = System.getProperty("java.home");
    public static final String osName = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String pathSep = System.getProperty("path.separator");
    public static final boolean isDos = pathSep.equals(";") && osName.indexOf("netware") <= -1;
    public static final String EOL = System.getProperty("line.separator");

    public static Properties getEnvProperties() throws Exception {
        if (envs == null) {
            envs = QueryUtils.getEnvs();
        }
        return envs;
    }

    private static Properties getEnvs() throws Exception {
        String tempFilePath = VMStat.tmpDirName + File.separator + "temp.env";
        Properties envProps = new Properties();
        Runtime r = Runtime.getRuntime();
        Process p = null;
        p = isDos ? r.exec("cmd /c set>" + tempFilePath) : r.exec("/bin/sh -c env>" + tempFilePath);
        Thread.sleep(500L);
        FileInputStream in = new FileInputStream(tempFilePath);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            int index = -1;
            index = line.indexOf("=");
            if (index > -1) {
                String key = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                envProps.setProperty(key, value);
                continue;
            }
            envProps.setProperty(line, "");
        }
        in.close();
        new File(tempFilePath).delete();
        return envProps;
    }

    public static void hexDumpAt(PrintStream out, byte[] data, int off, int len, int base) {
        int loc;
        int end;
        if (off >= data.length) {
            off = data.length;
        }
        if ((end = off + len) >= data.length) {
            end = data.length;
        }
        if ((len = end - off) <= 0) {
            return;
        }
        int i = loc = off / 16 * 16;
        while (i < end) {
            int ch;
            int d;
            int j;
            int v = base + loc;
            for (j = 28; j >= 0; j -= 4) {
                d = v >>> j & 0xF;
                d = d < 10 ? d + 48 : d - 10 + 65;
                out.print((char)d);
            }
            out.print("  ");
            j = 0;
            while (i + j < off) {
                out.print(".. ");
                ++j;
            }
            while (j < 16 && i + j < end) {
                if (j == 8) {
                    out.print(' ');
                }
                d = (d = (ch = data[i + j] & 0xFF) >>> 4) < 10 ? d + 48 : d - 10 + 65;
                out.print((char)d);
                d = ch & 0xF;
                d = d < 10 ? d + 48 : d - 10 + 65;
                out.print((char)d);
                out.print(' ');
                ++j;
            }
            while (j < 16) {
                if (j == 8) {
                    out.print(' ');
                }
                out.print(".. ");
                ++j;
            }
            out.print(" |");
            j = 0;
            while (i + j < off) {
                out.print(' ');
                ++j;
            }
            while (j < 16 && i + j < end) {
                ch = data[i + j] & 0xFF;
                if (ch < 32 || ch >= 127 && ch < 160 || ch > 255) {
                    ch = 46;
                }
                out.print((char)ch);
                ++j;
            }
            while (j < 16) {
                out.print(' ');
                ++j;
            }
            out.println("|");
            i += 16;
            loc += 16;
        }
    }

    public static void hexDump(PrintStream out, byte[] data, int off, int len) {
        if (out == null) {
            return;
        }
        if (data == null) {
            out.println("Null");
            return;
        }
        QueryUtils.hexDumpAt(out, data, off, len, 0);
        out.flush();
    }

    public static File normalize(String path) {
        return new File(path);
    }

    public static final String pad(String in, int length) {
        if (in == null) {
            in = " ";
        }
        if (length == 0) {
            return "";
        }
        int len = in.length();
        if (len < length) {
            for (int i = 0; i < length - len; ++i) {
                in = in + " ";
            }
        } else if (in.length() > length) {
            in = in.substring(0, length);
        }
        return in;
    }

    public static final String pad(long in, int length) {
        return QueryUtils.pad(String.valueOf(in), length);
    }

    public static final String pad(int in, int length) {
        return QueryUtils.pad(String.valueOf(in), length);
    }

    public static final String pad(boolean in, int length) {
        return QueryUtils.pad(String.valueOf(in), length);
    }

    public static String pad(Object in, int length) {
        return QueryUtils.pad(String.valueOf(in), length);
    }

    public static final String underline(String in, char c) {
        String line = QueryUtils.sep(c, in.length());
        return in + ReportQuery.EOL + line;
    }

    public static final String pad(int length) {
        return QueryUtils.pad(" +----------------------------", length);
    }

    public static final String sep(char in, int length) {
        String out = "";
        for (int i = 0; i < length; ++i) {
            out = out + in;
        }
        return out;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String dump(Object o) {
        return QueryUtils.dump(o, 1, false);
    }

    public static String dump(Object o, int ident, boolean recurse) {
        StringBuffer buffer;
        block12: {
            buffer = new StringBuffer();
            try {
                Class<?> oClass;
                if (oClass.isPrimitive() || oClass.isInstance(String.class)) {
                    buffer.append(QueryUtils.pad(ident) + String.valueOf(o) + ReportQuery.EOL);
                    break block12;
                }
                if (oClass.isArray()) {
                    buffer.append(QueryUtils.pad(ident) + "[");
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        if (i > 0) {
                            buffer.append(",");
                        } else {
                            buffer.append(QueryUtils.pad(ident));
                        }
                        Object value = Array.get(o, i);
                        buffer.append(value.getClass().isArray() ? QueryUtils.dump(value, ident++, recurse) : value);
                    }
                    buffer.append(QueryUtils.pad(ident) + "]");
                    break block12;
                }
                buffer.append(QueryUtils.pad(ident) + oClass.getName() + " {" + ReportQuery.EOL);
                for (oClass = o.getClass(); oClass != null; oClass = oClass.getSuperclass()) {
                    Field[] fields = oClass.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        fields[i].setAccessible(true);
                        String fieldvalue = null;
                        try {
                            Object value = fields[i].get(o);
                            if (value != null) {
                                fieldvalue = value.getClass().isArray() ? QueryUtils.dump(value, ident++, recurse) : (recurse ? QueryUtils.dump(value, ident++, recurse) : String.valueOf(value));
                            }
                        }
                        catch (IllegalAccessException e) {
                            buffer.append(QueryUtils.getStackTrace(e) + ReportQuery.EOL);
                        }
                        buffer.append(QueryUtils.pad(ident) + QueryUtils.pad(fields[i].getName(), 30) + " " + fieldvalue + ReportQuery.EOL);
                    }
                }
                buffer.append(QueryUtils.pad(ident) + "}");
            }
            catch (Exception e) {
                buffer.append(QueryUtils.getStackTrace(e) + ReportQuery.EOL);
            }
        }
        return buffer.toString();
    }
}

