/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.util.ArrayList;
import java.util.List;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.ClassQuery;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;

public class Callers
extends ClassQuery
implements ClassVisitor,
CodeVisitor {
    private List origSigs = new ArrayList();
    private Signature[] signatures;
    private int methodsCount;
    private String currentMethodName;
    private String currentMethodDesc;

    public String getDescription() {
        return "List all classes that call the specified method(s).\n\nArgs: <signature> ... [loaderName]\n\nWhere <signature> is:\n\n    <class-type>.<method-name>([parameter-type]*)<return-type>\n\nMultiple parameter-types must be ';' separated. Types must be either fully qualified class names or primitive names. For void return types, the <return-type> may be omitted. For example, to find calls to System.load(String), pass:\n\n    java.lang.System.load(java.lang.String)\n\nTo find calls to either version of Class.forName(), pass both:\n\n    java.lang.Class.forName(java.lang.String)java.lang.Class\n    java.lang.Class.forName(java.lang.String;boolean;java.lang.ClassLoader)java.lang.Class\n\nUse '<init>' to specify a constructor. For example, to find calls to java.util.Date(), pass:\n\n    java.util.Date.<init>()\n\nIf loader name is specified, all classes visible from that loader will be checked. If not specified, checks all classes visible to all loaders from the 'api' downwards.";
    }

    protected void buildReport() {
        this.appendln();
        this.append("Search report for calls to");
        if (this.signatures.length == 1) {
            this.append(' ');
            this.append(this.signatures[0]);
            this.appendln('.');
        } else {
            this.appendln(':');
            this.appendln();
            for (int i = 0; i < this.signatures.length; ++i) {
                this.indent();
                this.append('M');
                this.append(i);
                this.append(": ");
                this.appendln(this.signatures[i]);
            }
        }
        this.appendln();
        this.append("Calling methods found: ");
        this.appendln(this.hits.size());
        this.append(" Code-sources checked: ");
        this.appendln(this.codeSourcesCount);
        this.append("      Classes checked: ");
        this.appendln(this.classesCount);
        this.append("   Average class size: ");
        this.appendln(this.classesCount > 0 ? this.totalClassSize / this.classesCount : 48);
        this.append("   Maximum class size: ");
        this.append(this.maxClassSize);
        this.append(" (");
        this.append(this.maxClassName);
        this.appendln(')');
        this.append("      Methods checked: ");
        this.appendln(this.methodsCount);
        this.append("          Search time: ");
        this.getReportBuffer().append(System.currentTimeMillis() - this.startTime);
        this.appendln(" ms");
        this.appendln();
        if (this.hits.isEmpty()) {
            this.appendln("No calls found.");
        } else {
            this.appendln("Calling methods:");
            this.appendln();
            this.appendNumberedList(this.hits);
        }
        this.appendln();
        if (!this.errors.isEmpty()) {
            this.appendln("Errors:");
            this.appendln();
            this.appendNumberedList(this.errors);
        }
    }

    protected boolean shouldVisitClass(String className) {
        return true;
    }

    protected void visitClass(String className, byte[] classData, int classSize) {
        ClassReader reader = new ClassReader(classData, 0, classSize);
        reader.accept((ClassVisitor)this, false);
    }

    protected void visitArgument(String arg) {
        this.origSigs.add(new Signature(arg));
    }

    protected void prepare() {
        this.signatures = new Signature[this.origSigs.size()];
        this.origSigs.toArray(this.signatures);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        ++this.methodsCount;
        this.currentMethodName = name;
        this.currentMethodDesc = desc;
        return this;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }

    public void visitInsn(int opcode) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    public void visitVarInsn(int opcode, int var) {
    }

    public void visitTypeInsn(int opcode, String desc) {
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        for (int i = 0; i < this.signatures.length; ++i) {
            Signature signature = this.signatures[i];
            if (!signature.matches(owner, name, desc)) continue;
            StringBuffer buf = new StringBuffer();
            buf.append(this.currentClassName);
            buf.append('.');
            buf.append(this.currentMethodName);
            buf.append(this.currentMethodDesc);
            if (this.signatures.length > 1) {
                buf.append(" (M");
                buf.append(i);
                buf.append(')');
            }
            buf.append(" in ");
            buf.append(Callers.getDisplayPath((SharedCodeSource)this.currentSource));
            buf.append(".");
            this.hits.add(buf.toString());
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
    }

    public void visitLabel(Label label) {
    }

    public void visitLdcInsn(Object cst) {
    }

    public void visitIincInsn(int var, int increment) {
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public static class Signature {
        private String orig;
        private String className;
        private String methodName;
        private String methodDescriptor;

        public Signature(String sig) {
            int comma;
            this.orig = sig;
            int openParen = sig.indexOf(40);
            int closeParen = sig.indexOf(41);
            if (openParen <= 1 || closeParen < openParen) {
                throw new RuntimeException("Invalid signature: " + sig);
            }
            String classNMethod = sig.substring(0, openParen);
            int lastDot = classNMethod.lastIndexOf(46);
            if (lastDot <= 0) {
                throw new RuntimeException("Invalid signature: " + sig);
            }
            this.className = classNMethod.substring(0, lastDot).replace('.', '/');
            this.methodName = classNMethod.substring(lastDot + 1);
            String params = sig.substring(openParen + 1, closeParen);
            StringBuffer desc = new StringBuffer(128);
            desc.append('(');
            int start = 0;
            while ((comma = params.indexOf(59, start)) > 0) {
                this.appendType(desc, params.substring(start, comma));
                start = comma + 1;
            }
            this.appendType(desc, params.substring(start));
            desc.append(')');
            if (sig.length() > closeParen + 1) {
                this.appendType(desc, sig.substring(closeParen + 1));
            } else {
                desc.append('V');
            }
            this.methodDescriptor = desc.toString();
        }

        public String toString() {
            return this.orig;
        }

        public boolean matches(String classDesc, String methodName, String methodDescriptor) {
            return this.className.equals(classDesc) && this.methodName.equals(methodName) && this.methodDescriptor.equals(methodDescriptor);
        }

        private void appendType(StringBuffer desc, String name) {
            if ((name = name.trim()).length() > 0) {
                int openBracket = name.indexOf(91);
                if (openBracket >= 0) {
                    int closeBracket = name.indexOf(93, openBracket);
                    int dimensions = closeBracket - openBracket;
                    while (dimensions-- > 0) {
                        desc.append('[');
                    }
                    name = name.substring(0, openBracket);
                }
                if (name.equals("byte")) {
                    desc.append('B');
                } else if (name.equals("char")) {
                    desc.append('C');
                } else if (name.equals("double")) {
                    desc.append('D');
                } else if (name.equals("float")) {
                    desc.append('F');
                } else if (name.equals("int")) {
                    desc.append('I');
                } else if (name.equals("long")) {
                    desc.append('J');
                } else if (name.equals("short")) {
                    desc.append('S');
                } else if (name.equals("boolean")) {
                    desc.append('Z');
                } else {
                    desc.append('L');
                    desc.append(name.replace('.', '/'));
                    desc.append(';');
                }
            }
        }
    }
}

