/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadLogger;
import oracle.oc4j.peek.Peek;

public abstract class PeekHandler {
    protected static final Pattern LINE_TERM1 = Pattern.compile("\\n");
    protected static final Pattern LINE_TERM2 = Pattern.compile("\\r");
    protected static final Pattern LINE_TERM3 = Pattern.compile("\\r\\n");
    protected static final Pattern LESS_THAN = Pattern.compile("<");
    protected static final Pattern GREATER_THAN = Pattern.compile(">");
    protected static final Pattern DOUBLE_SPACES = Pattern.compile("\\x20\\x20");
    protected static final String PROPERTIES = "peekfiles/peek.properties";
    protected static final String TWO_NB_SPACES = "&nbsp;&nbsp;";
    protected static final String BR = "<br />\n";
    protected static final String LOADER_PARAM = "l";
    protected static final Properties properties = PeekHandler.getProperties();
    private static final int COOKIE_EXPIRES_SECONDS = 31536000;

    private static Properties getProperties() {
        Properties result = null;
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES);
            if (in != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Throwable t) {
            ClassLoadLogger.logException((String)"", (Throwable)t, (boolean)true);
        }
        return result;
    }

    protected PeekHandler() {
        Peek.registerHandler(this.getURISuffix(), this);
    }

    public abstract String getURISuffix();

    public abstract void handleRequest(String var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    protected static List getLoaderNames() {
        List loaders = ClassLoaderQuery.getAllLoaders();
        ArrayList<String> names = new ArrayList<String>(loaders.size());
        Iterator iterator = loaders.iterator();
        while (iterator.hasNext()) {
            PolicyClassLoader loader = (PolicyClassLoader)iterator.next();
            names.add(loader.getDisplayName());
        }
        Collections.sort(names);
        return names;
    }

    protected static String cleanText(String string) {
        string = LESS_THAN.matcher(string).replaceAll("&lt;");
        string = GREATER_THAN.matcher(string).replaceAll("&gt;");
        string = DOUBLE_SPACES.matcher(string).replaceAll(TWO_NB_SPACES);
        string = LINE_TERM1.matcher(string).replaceAll(BR);
        string = LINE_TERM2.matcher(string).replaceAll(BR);
        string = LINE_TERM3.matcher(string).replaceAll(BR);
        return string;
    }

    protected static String getSuffix(String path) {
        String suffix = null;
        int lastIndex = path.lastIndexOf(46);
        if (lastIndex >= 0) {
            suffix = path.substring(lastIndex);
        }
        return suffix;
    }

    protected static String getContentType(String suffix) {
        String result = null;
        if (suffix.equals(".xsd")) {
            result = "text/xml";
        } else {
            result = Peek.getContext().getMimeType(suffix);
            if (result == null) {
                result = "text/plain";
            }
        }
        return result;
    }

    public static String getLogFilePath() {
        if (properties != null) {
            return properties.getProperty("log.file");
        }
        return null;
    }

    protected static String getContactAddress(PolicyClassLoader loader) {
        if (properties != null) {
            return properties.getProperty(loader.getDisplayName() + ".contact");
        }
        return null;
    }

    protected static String getDescription(PolicyClassLoader loader) {
        if (properties != null) {
            return properties.getProperty(loader.getDisplayName() + ".about");
        }
        return null;
    }

    protected static String getHelpLink() {
        if (properties != null) {
            return properties.getProperty("help.link");
        }
        return null;
    }

    protected static String getRegistrationLink() {
        String link;
        if (properties != null && (link = properties.getProperty("registration.link")) != null) {
            StringBuffer buf = new StringBuffer(256);
            buf.append("<a href=\"");
            buf.append(link);
            buf.append("\">");
            buf.append("register</a>");
            return buf.toString();
        }
        return null;
    }

    protected static String getContactLinkFor(PolicyClassLoader loader) {
        String address = PeekHandler.getContactAddress(loader);
        if (address == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("<a href=\"mailto:");
        buf.append(address);
        buf.append("?subject=");
        buf.append("Question about shared-library ");
        buf.append(loader.getDisplayName());
        buf.append("\">");
        String name = address.substring(0, address.indexOf(64));
        StringTokenizer t = new StringTokenizer(name, ".");
        boolean started = false;
        while (t.hasMoreTokens()) {
            String full;
            if (started) {
                buf.append(' ');
            }
            if ((full = t.nextToken()).length() <= 0) continue;
            buf.append(Character.toUpperCase(full.charAt(0)));
            if (full.length() > 1) {
                buf.append(full.substring(1));
            }
            started = true;
        }
        buf.append("</a>");
        return buf.toString();
    }

    protected static String getCookieValue(String cookieName, String defaultValue, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return defaultValue;
    }

    protected static void setCookie(String cookieName, String cookieValue, HttpServletResponse response) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setMaxAge(31536000);
        cookie.setPath(Peek.getContextRoot());
        response.addCookie(cookie);
    }

    static String filterQueryString(String query) {
        if (query == null || query.length() == 0) {
            return query;
        }
        if (query.indexOf("<") >= 0) {
            query = query.replaceAll("<", "&lt;");
        }
        if (query.indexOf(">") >= 0) {
            query = query.replaceAll(">", "&gt;");
        }
        if (query.indexOf("\"") >= 0) {
            query = query.replaceAll("\"", "&quot;");
        }
        if (query.indexOf("'") >= 0) {
            query = query.replaceAll("'", "&apos;");
        }
        if (query.indexOf("<SCRIPT") >= 0) {
            query = query.replaceAll("<SCRIPT", "&lt;SCRIPT");
        }
        if (query.indexOf("<script") >= 0) {
            query = query.replaceAll("<script", "&lt;script");
        }
        if (query.indexOf("/SCRIPT>") >= 0) {
            query = query.replaceAll("/SCRIPT>", "/SCRIPT&gt;");
        }
        if (query.indexOf("/script>") >= 0) {
            query = query.replaceAll("/script>", "/script&gt;");
        }
        if (query.indexOf("text/javascript") >= 0) {
            query = query.replaceAll("text/javascript", "");
        }
        if (query.indexOf("eval()") >= 0) {
            query = query.replaceAll("eval()", "");
        }
        return query;
    }
}

