/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.oc4j.peek.CodeSourceHandler;
import oracle.oc4j.peek.LoaderTreeHandler;
import oracle.oc4j.peek.PageHandler;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.ResourceHandler;

public class LoaderHandler
extends PageHandler {
    private static final String BEGIN = "<div class=\"tree\">\n";
    private static final String END = "</div>\n";
    private static final String REGISTER_BEGIN = "<p><i><b>Note:</b> This shared-library does not have a registered contact&#151;if you are responsible for this library, please ";
    private static final String REGISTER_END = " it.</i></p>";

    public String getURISuffix() {
        return "loader";
    }

    public static String getLinkTo(PolicyClassLoader loader) {
        return LoaderHandler.getLinkTo(loader, null);
    }

    public static String getLinkTo(PolicyClassLoader loader, String title) {
        if (loader == null) {
            return "none";
        }
        String loaderName = loader.getDisplayName();
        StringBuffer buf = new StringBuffer(256);
        if (title != null) {
            buf.append("<a title=\"");
            buf.append(title);
            buf.append("\" href=\"");
        } else {
            buf.append("<a href=\"");
        }
        buf.append(Peek.getContextRoot());
        buf.append("loader/");
        buf.append(loaderName);
        buf.append("\">");
        buf.append(loaderName);
        buf.append("</a>");
        return buf.toString();
    }

    protected static PolicyClassLoader getLoader(HttpServletRequest request) {
        String loaderName = request.getParameter("l");
        if (loaderName == null) {
            return null;
        }
        PolicyClassLoader loader = ClassLoaderQuery.findLoader((String)loaderName);
        if (loader == null) {
            throw new Error("Unknown loader: " + loader);
        }
        return loader;
    }

    protected void pageBody(String loaderName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        PolicyClassLoader loader = ClassLoaderQuery.findLoader((String)loaderName);
        if (loader == null) {
            ((Writer)out).write("Unknown loader: ");
            ((Writer)out).write(loaderName);
        } else {
            List classes;
            PolicyClassLoader[] imports;
            PolicyClassLoader[] importedBy;
            String link;
            ((Writer)out).write(BEGIN);
            LoaderHandler.writeHeading3(LoaderTreeHandler.getTitle(loader), out);
            String about = LoaderHandler.getDescription(loader);
            if (about != null) {
                String contact;
                ((Writer)out).write("<p>");
                if (!about.equals("?")) {
                    ((Writer)out).write(about);
                    if (!about.endsWith(".")) {
                        ((Writer)out).write(". ");
                    } else {
                        ((Writer)out).write(32);
                    }
                }
                if ((contact = LoaderHandler.getContactLinkFor(loader)) != null) {
                    ((Writer)out).write("For questions, contact ");
                    ((Writer)out).write(contact);
                    ((Writer)out).write(46);
                }
                ((Writer)out).write("</p>");
            } else if (loader.isSharedLoader() && (link = LoaderHandler.getRegistrationLink()) != null) {
                ((Writer)out).write(REGISTER_BEGIN);
                ((Writer)out).write(link);
                ((Writer)out).write(REGISTER_END);
            }
            LoaderHandler.beginTable(out);
            int c1ClassIndex = 0;
            String parentLink = LoaderHandler.getLinkTo(loader.parent());
            c1ClassIndex = LoaderHandler.writeTableRow("Parent", parentLink, C1_CLASSES, c1ClassIndex, out);
            c1ClassIndex = LoaderHandler.writeTableRow("Search Policy", loader.getSearchPolicy(), C1_CLASSES, c1ClassIndex, out);
            if (loader.isSharedLoader() && (importedBy = loader.getSubscribers().getSubscribers()) != null && importedBy.length > 0) {
                c1ClassIndex = LoaderHandler.writeLoaders("Imported By", importedBy, c1ClassIndex, out);
            }
            if ((imports = loader.getImports()) != null && imports.length > 0) {
                c1ClassIndex = LoaderHandler.writeLoaders("Imports", imports, c1ClassIndex, out);
            }
            SharedCodeSource[] sources = loader.getCodeSources(true);
            c1ClassIndex = LoaderHandler.writeCodeSources(sources, false, loader, c1ClassIndex, out);
            sources = loader.getNativeCodeSources();
            if (sources != null) {
                c1ClassIndex = LoaderHandler.writeCodeSources(sources, true, loader, c1ClassIndex, out);
            }
            if (!(classes = ClassLoaderQuery.getLoadedClasses((ClassLoader)loader)).isEmpty()) {
                c1ClassIndex = LoaderHandler.writeLoadedClasses(classes, loader, c1ClassIndex, out);
            }
            LoaderHandler.endTable(out);
            ((Writer)out).write(END);
        }
    }

    private static int writeCodeSources(SharedCodeSource[] sources, boolean nativeSources, PolicyClassLoader loader, int c1ClassIndex, Writer out) throws Exception {
        c1ClassIndex = nativeSources ? LoaderHandler.beginTableRow("Native Code Sources", C1_CLASSES, c1ClassIndex, out) : LoaderHandler.beginTableRow("Code Sources", C1_CLASSES, c1ClassIndex, out);
        for (int i = 0; i < sources.length; ++i) {
            SharedCodeSource source = sources[i];
            if (source == null) continue;
            out.write(Integer.toString(i + 1));
            out.write(". ");
            out.write(CodeSourceHandler.getLinkTo(source, loader));
            out.write("<br />\n");
        }
        LoaderHandler.endTableRow(out);
        return c1ClassIndex;
    }

    private static int writeLoadedClasses(List classes, PolicyClassLoader loader, int c1ClassIndex, Writer out) throws Exception {
        c1ClassIndex = LoaderHandler.beginTableRow("Loaded Classes", C1_CLASSES, c1ClassIndex, out);
        int lineNum = 1;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class clz = (Class)iterator.next();
            if (clz == null) continue;
            out.write(Integer.toString(lineNum++));
            out.write(". ");
            String resPath = clz.getName().replace('.', '/') + ".class";
            out.write(ResourceHandler.getLinkTo(resPath, loader, null));
            out.write("<br />\n");
        }
        LoaderHandler.endTableRow(out);
        return c1ClassIndex;
    }

    private static int writeLoaders(String label, PolicyClassLoader[] importedBy, int c1ClassIndex, Writer out) throws Exception {
        c1ClassIndex = LoaderHandler.beginTableRow(label, C1_CLASSES, c1ClassIndex, out);
        for (int i = 0; i < importedBy.length; ++i) {
            PolicyClassLoader importer = importedBy[i];
            if (importer == null) continue;
            out.write(Integer.toString(i + 1));
            out.write(". ");
            out.write(LoaderHandler.getLinkTo(importer));
            out.write("<br />\n");
        }
        LoaderHandler.endTableRow(out);
        return c1ClassIndex;
    }
}

