/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.config.xml;

import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.oc4j.configuration.XMLSerializable;
import oracle.oc4j.loader.config.SharedLibraryType;
import oracle.oc4j.loader.config.xml.CodeSourceElement;
import oracle.oc4j.loader.config.xml.ComparisonUtils;
import oracle.oc4j.loader.config.xml.ImportSharedLibraryElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharedLibraryElement
implements SharedLibraryType,
XMLSerializable {
    private String name;
    private String version;
    private String parentName;
    private String parentVersion;
    private List codeSources = new ArrayList();
    private List imports = new ArrayList();
    private boolean libraryCompatible;
    private boolean instantiated;
    private boolean includeClassPath;

    public SharedLibraryElement() {
    }

    public SharedLibraryElement(String name, String version, String parentName, String parentVersion) {
        this.name = name;
        this.version = version;
        this.parentName = parentName;
        this.parentVersion = parentVersion;
    }

    public boolean equals(Object other) {
        try {
            SharedLibraryElement it = (SharedLibraryElement)other;
            if (!ComparisonUtils.equal(this.name, it.name)) {
                return false;
            }
            if (!ComparisonUtils.equal(this.version, it.version)) {
                return false;
            }
            if (!ComparisonUtils.equal(this.parentName, it.parentName)) {
                return false;
            }
            if (!ComparisonUtils.equal(this.parentVersion, it.parentVersion)) {
                return false;
            }
            if (!ComparisonUtils.equal(this.codeSources, it.codeSources)) {
                return false;
            }
            return ComparisonUtils.equal(this.imports, it.imports);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.instantiated = false;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.instantiated = false;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String name) {
        this.parentName = name;
        this.instantiated = false;
    }

    public String getParentVersion() {
        return this.parentVersion;
    }

    public void setParentVersion(String version) {
        this.parentVersion = version;
        this.instantiated = false;
    }

    public List getCodeSources() {
        return this.codeSources;
    }

    public void addCodeSource(CodeSourceElement codeSource) {
        this.removeCodeSource(codeSource.getPath());
        this.codeSources.add(codeSource);
        this.instantiated = false;
    }

    public void removeCodeSource(String path) {
        for (int n = 0; n < this.codeSources.size(); ++n) {
            CodeSourceElement codeSource = (CodeSourceElement)this.codeSources.get(n);
            if (!codeSource.getPath().equals(path)) continue;
            this.codeSources.remove(n);
        }
        this.instantiated = false;
    }

    public List getImports() {
        return this.imports;
    }

    public void addImport(ImportSharedLibraryElement importSharedLibrary) {
        this.removeImport(importSharedLibrary.getName());
        this.imports.add(importSharedLibrary);
        this.instantiated = false;
    }

    public void removeImport(String name) {
        for (int n = 0; n < this.imports.size(); ++n) {
            ImportSharedLibraryElement importSharedLibrary = (ImportSharedLibraryElement)this.imports.get(n);
            if (!importSharedLibrary.getName().equals(name)) continue;
            this.imports.remove(n);
        }
        this.instantiated = false;
    }

    public void read(Node node) throws DOMException {
        this.name = XMLUtils.getNodeAttribute(node, "name");
        this.version = XMLUtils.getNodeAttribute(node, "version");
        this.parentName = XMLUtils.getNodeAttribute(node, "parent-name");
        this.parentVersion = XMLUtils.getNodeAttribute(node, "parent-version");
        this.libraryCompatible = XMLUtils.getBooleanNodeAttribute(node, "library-compatible") == 1;
        this.includeClassPath = XMLUtils.getBooleanNodeAttribute(node, "include-class-path") == 1;
        NodeList list = node.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                XMLSerializable e;
                Node child = list.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.startsWith("#")) continue;
                if (nodeName.equals("code-source")) {
                    e = new CodeSourceElement();
                    ((CodeSourceElement)e).read(child);
                    this.codeSources.add(e);
                    continue;
                }
                if (!nodeName.equals("import-shared-library")) continue;
                e = new ImportSharedLibraryElement();
                ((ImportSharedLibraryElement)e).read(child);
                this.imports.add(e);
            }
        }
        this.instantiated = false;
    }

    public void write(PrintWriter out, String indent) throws IOException {
        out.print(indent);
        out.print("<shared-library name=\"" + this.name + "\"");
        out.print(" version=\"" + this.version + "\"");
        if (this.parentName != null) {
            out.print(" parent-name=\"" + this.parentName + "\"");
        }
        if (this.parentVersion != null) {
            out.print(" parent-version=\"" + this.parentVersion.toString() + "\"");
        }
        if (this.libraryCompatible) {
            out.print(" library-compatible=\"true\"");
        }
        if (this.includeClassPath) {
            out.print(" include-class-path=\"true\"");
        }
        out.println(">");
        String subIndent = indent + "\t";
        Iterator iterator = this.codeSources.iterator();
        while (iterator.hasNext()) {
            CodeSourceElement cs = (CodeSourceElement)iterator.next();
            cs.write(out, subIndent);
        }
        iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            ImportSharedLibraryElement imp = (ImportSharedLibraryElement)iterator.next();
            imp.write(out, subIndent);
        }
        out.print(indent);
        out.println("</shared-library>");
    }

    public boolean isLibraryCompatible() {
        return this.libraryCompatible;
    }

    public void setLibraryCompatible(boolean compatible) {
        this.libraryCompatible = compatible;
        this.instantiated = false;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public void setInstantiated(boolean instantiated) {
        this.instantiated = instantiated;
    }

    public boolean includeManifestClassPath() {
        return this.includeClassPath;
    }

    public void setIncludeManifestClassPath(boolean includeClassPath) {
        this.includeClassPath = includeClassPath;
    }
}

