/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.config;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.classloader.util.LocalizedText;
import oracle.oc4j.loader.config.ConfigurationText;

public class ConfigurationException
extends InstantiationException {
    static final LocalizedText TEXT = ConfigurationException.createLocalizedText();

    private static LocalizedText createLocalizedText() {
        String bundleName = ConfigurationText.class.getName();
        Locale currentLocale = Locale.getDefault();
        ClassLoader loader = ConfigurationException.class.getClassLoader();
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, currentLocale, loader);
        return new LocalizedText(bundleName, bundle);
    }

    public ConfigurationException(String message) {
        super(message);
    }

    public ConfigurationException(Throwable cause) {
        super(cause.getMessage());
        this.initCause(cause);
    }

    public static ConfigurationException create(String key) {
        String message = TEXT.getText(key);
        return new ConfigurationException(message);
    }

    public static ConfigurationException create(String key, Object sub0) {
        String message = TEXT.getText(key, sub0);
        return new ConfigurationException(message);
    }

    public static ConfigurationException create(String key, Object sub0, Object sub1) {
        String message = TEXT.getText(key, sub0, sub1);
        return new ConfigurationException(message);
    }

    public static ConfigurationException create(String key, Object sub0, Object sub1, Object sub2) {
        String message = TEXT.getText(key, sub0, sub1, sub2);
        return new ConfigurationException(message);
    }

    public static ConfigurationException create(String key, Object sub0, Object sub1, Object sub2, Object sub3) {
        String message = TEXT.getText(key, sub0, sub1, sub2, sub3);
        return new ConfigurationException(message);
    }
}

