/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import com.evermind.server.ApplicationContextClassLoader;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.logging.EJBIiopMessages;
import java.rmi.Remote;
import java.security.AccessController;
import javax.rmi.CORBA.Tie;
import oracle.j2ee.util.SetContextClassLoaderAction;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.POAPolicyCreationStrategy;
import oracle.oc4j.corba.ServerOrbManager;
import oracle.oc4j.corba.transport.BaseServantLocator;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;

abstract class AbstractReferenceGenerator {
    private ThreadLocal m_contextContainer = new ThreadLocal();

    AbstractReferenceGenerator() {
    }

    protected final void setEjbContextContainerForThread(CorbaEJBHome homeContainer) {
        ThreadState state = this.getThreadState();
        if (state != null) {
            this.m_contextContainer.set(state.contextContainer);
            state.contextContainer = homeContainer;
            this.setContextClassLoader();
        }
    }

    private void setContextClassLoader() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof ApplicationServerThread) && !(thread.getContextClassLoader() instanceof ApplicationContextClassLoader)) {
            AccessController.doPrivileged(new SetContextClassLoaderAction(thread, new ApplicationContextClassLoader()));
        }
    }

    private ThreadState getThreadState() {
        CommonThreadState state = CommonThreadState.getCurrent();
        if (state instanceof ThreadState) {
            return (ThreadState)state;
        }
        return null;
    }

    protected final void unsetEjbContextContainerForThread() {
        ThreadState state = this.getThreadState();
        if (state != null) {
            state.contextContainer = (ContextContainer)this.m_contextContainer.get();
            this.m_contextContainer.set(null);
        }
    }

    protected final boolean equivalentCORBAObjects(java.lang.Object left, java.lang.Object right) {
        return ((Object)left)._is_equivalent((Object)right);
    }

    protected final Policy[] createPOAPolicies(CorbaEJBHome home, POA rootPoa, POAPolicyCreationStrategy policyStrategy) throws ORBConfigurationException {
        return policyStrategy.createPoaPolicies(ServerOrbManager.getDefaultPoaPolicies(rootPoa, home), rootPoa, ServerOrbManager.getOrb());
    }

    protected final POA createPOA(String poaName, POA rootPoa, Policy[] policies) throws ORBInitializationException {
        try {
            return rootPoa.create_POA(poaName, rootPoa.the_POAManager(), policies);
        }
        catch (InvalidPolicy e) {
            EJBIiopMessages.severeUnableToCreatePoa((Exception)((java.lang.Object)e));
            throw new ORBInitializationException(e.getMessage());
        }
        catch (AdapterAlreadyExists e) {
            EJBIiopMessages.severeUnableToCreatePoa((Exception)((java.lang.Object)e));
            throw new ORBInitializationException(e.getMessage());
        }
    }

    protected final void setServantLocator(POA poa, BaseServantLocator locator) throws ORBInitializationException {
        try {
            poa.set_servant_manager((ServantManager)locator);
        }
        catch (WrongPolicy wpe) {
            EJBIiopMessages.severeUnableToSetServantLocator((Exception)((java.lang.Object)wpe));
            throw new ORBInitializationException("Could not set servant locator on POA");
        }
    }

    protected final String getRepositoryID(Servant servant) {
        return servant._all_interfaces(null, null)[0];
    }

    protected final Servant createServantForWrapper(java.lang.Object obj) throws ORBInitializationException {
        if (!(obj instanceof Remote)) {
            throw new ORBInitializationException("Wrapper object does not implement Remote");
        }
        try {
            Tie tie = ServerOrbManager.getTieForWrapper(obj);
            tie.setTarget((Remote)obj);
            tie.orb(ServerOrbManager.getOrb());
            return (Servant)tie;
        }
        catch (Exception e) {
            EJBIiopMessages.severeUnableToCreateServant(e);
            throw new ORBInitializationException("Could not create Servant: " + e);
        }
    }
}

