/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.oracle.corba.ee.impl.orb.ORBManagerImpl;
import com.sun.corba.ee.org.omg.CSI.CompleteEstablishContext;
import com.sun.corba.ee.org.omg.CSI.ContextError;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.iiop.security.AnonCredential;
import oracle.oc4j.corba.iiop.security.ClientSecurityService;
import oracle.oc4j.corba.iiop.security.Counter;
import oracle.oc4j.corba.iiop.security.Csiv2Manager;
import oracle.oc4j.corba.iiop.security.GSSUPName;
import oracle.oc4j.corba.iiop.security.GSSUPToken;
import oracle.oc4j.corba.iiop.security.GSSUtils;
import oracle.oc4j.corba.iiop.security.SecClientRequestInterceptor;
import oracle.oc4j.corba.iiop.security.SecurityContext;
import oracle.oc4j.corba.iiop.security.ServerSecurityService;
import oracle.oc4j.corba.iiop.security.SvcContextUtils;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;
import oracle.oc4j.corba.security.auth.login.X509CertificateCredential;
import oracle.oc4j.corba.util.LocalStringManagerImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class SecServerRequestInterceptor
extends SecClientRequestInterceptor
implements ServerRequestInterceptor,
ClientRequestInterceptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);
    private InheritableThreadLocal counterForCalls = new InheritableThreadLocal();
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final int INVALID_MECHANISM_MAJOR = 2;
    private static final int INVALID_MECHANISM_MINOR = 1;
    private static final boolean NO_REPLACE = false;
    private ORB orb;
    ClientSecurityService secsvc = null;

    public SecServerRequestInterceptor(String name, Codec codec) {
        super(name, codec);
    }

    private SASContextBody createContextError(int status) {
        CSIV2Messages.finestMsg("Creating ContextError message: minor code= " + status);
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, 1, status, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createContextError(int major, int minor) {
        CSIV2Messages.finestMsg("Creating ContextError message: major code = " + major + "minor code= " + minor);
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, major, minor, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createCompleteEstablishContext(int status) {
        CSIV2Messages.finestMsg("Creating CompleteEstablishContext message");
        byte[] final_context_token = new byte[]{};
        CompleteEstablishContext cec = new CompleteEstablishContext(0L, false, final_context_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.complete_msg(cec);
        return sasctxtbody;
    }

    private ServiceContext createSvcContext(SASContextBody sasctxtbody) {
        ServiceContext sc = null;
        Any a = this.orb.create_any();
        SASContextBodyHelper.insert((Any)a, (SASContextBody)sasctxtbody);
        byte[] cdr_encoded_saselm = new byte[]{};
        try {
            cdr_encoded_saselm = this.codec.encode_value(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        return sc;
    }

    protected ClientSecurityService getSecurityService() {
        return Csiv2Manager.getServerSecurityService();
    }

    private void createIdCred(SecurityContext sc, IdentityToken idtok) throws Exception {
        switch (idtok.discriminator()) {
            case 0: {
                CSIV2Messages.finerMsg("Identity token type is Absent");
                sc.identcls = null;
                break;
            }
            case 1: {
                CSIV2Messages.finerMsg("Identity token type is Anonymous");
                CSIV2Messages.finerMsg("Adding AnonyCredential to subject's PublicCredentials");
                sc.subject.getPublicCredentials().add(new AnonCredential());
                sc.identcls = AnonCredential.class;
                break;
            }
            case 8: {
                CSIV2Messages.finerMsg("Identity token type is X500 Distinguished Name");
                Any any = this.codec.decode_value(idtok.dn(), X501DistinguishedNameHelper.type());
                byte[] derenc = X501DistinguishedNameHelper.extract((Any)any);
                CSIV2Messages.fineMsg("Create an X500Name object from identity token");
                X500Name name = new X500Name(derenc);
                CSIV2Messages.fineMsg("Identity to be asserted is " + name.toString());
                CSIV2Messages.fineMsg("Adding X500Name to subject's PublicCredentials");
                sc.subject.getPublicCredentials().add(name);
                sc.identcls = X500Name.class;
                break;
            }
            case 4: {
                CSIV2Messages.fineMsg("Identity token type is a X509 Certificate Chain");
                Any any = this.codec.decode_value(idtok.certificate_chain(), X509CertificateChainHelper.type());
                byte[] derenc = X509CertificateChainHelper.extract((Any)any);
                DerInputStream din = new DerInputStream(derenc);
                DerValue[] derval = din.getSequence(1);
                X509Certificate[] certchain = new X509CertImpl[derval.length];
                CSIV2Messages.fineMsg("Contents of X509 Certificate chain:");
                for (int i = 0; i < certchain.length; ++i) {
                    certchain[i] = new X509CertImpl(derval[i]);
                    CSIV2Messages.fineMsg("    " + certchain[i].getSubjectDN().getName());
                }
                CSIV2Messages.fineMsg("Creating a X509CertificateCredential object from certchain");
                X509CertificateCredential cred = new X509CertificateCredential(certchain, ((X509Certificate)certchain[0]).getSubjectDN().getName(), "default");
                CSIV2Messages.fineMsg("Adding X509CertificateCredential to subject's PublicCredentials");
                sc.subject.getPublicCredentials().add(certchain);
                sc.identcls = X509CertificateCredential.class;
                break;
            }
            case 2: {
                CSIV2Messages.fineMsg("Identity token type is GSS Exported Name");
                Any any = this.codec.decode_value(idtok.principal_name(), GSS_NT_ExportedNameHelper.type());
                byte[] expname = GSS_NT_ExportedNameHelper.extract((Any)any);
                if (!GSSUtils.verifyMechOID(GSSUtils.GSSUP_MECH_OID, expname)) {
                    throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
                }
                GSSUPName gssname = new GSSUPName(expname);
                sc.subject.getPublicCredentials().add(gssname);
                sc.identcls = GSSUPName.class;
                CSIV2Messages.fineMsg("Adding GSSUPName credential to subject");
                break;
            }
            default: {
                CSIV2Messages.severeMsg("Unknown identity assertion type");
                throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
            }
        }
    }

    private void createAuthCred(SecurityContext sc, byte[] authtok) throws Exception {
        CSIV2Messages.fineMsg("Constructing a PasswordCredential from client authentication token");
        GSSUPToken tok = new GSSUPToken(this.orb, this.codec, authtok);
        final PasswordCredential pwdcred = tok.getPwdcred();
        final SecurityContext fsc = sc;
        CSIV2Messages.fineMsg("Password credential = " + pwdcred.toString());
        CSIV2Messages.fineMsg("Adding PasswordCredential to subject's PrivateCredentials");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fsc.subject.getPrivateCredentials().add(pwdcred);
                return null;
            }
        });
        sc = fsc;
        sc.authcls = PasswordCredential.class;
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        SecurityContext seccontext = null;
        ServiceContext sc = null;
        int status = 0;
        CSIV2Messages.finestMsg(this.prname + "receive_request_service_contexts");
        this.secsvc = Csiv2Manager.getServerSecurityService();
        try {
            this.orb = ORBManagerImpl.getORBManager().getORBReference();
        }
        catch (ORBConfigurationException e) {
            throw new RuntimeException(e.toString());
        }
        try {
            sc = ri.get_request_service_context(15);
        }
        catch (BAD_PARAM e) {
            CSIV2Messages.fineMsg("No SAS context element found in service context list");
            int secStatus = this.secsvc.setSecurityContext(null, ri.object_id(), ri.operation());
            if (secStatus == 1) {
                SASContextBody sasctxbody = this.createContextError(2, 1);
                sc = this.createSvcContext(sasctxbody);
                ri.add_reply_service_context(sc, false);
                throw new NO_PERMISSION();
            }
            return;
        }
        CSIV2Messages.fineMsg("Received a non null SAS context element");
        Any SasAny = this.orb.create_any();
        try {
            SasAny = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            e.printStackTrace();
            CSIV2Messages.severeMsg("CDR Decoding error for SAS context element.");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        CSIV2Messages.fineMsg("Successfully decoded CDR encoded SAS context element.");
        SASContextBody sasctxbody = SASContextBodyHelper.extract((Any)SasAny);
        short sasdiscr = sasctxbody.discriminator();
        CSIV2Messages.fineMsg("SAS context element is a/an " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        if (sasdiscr == 5) {
            sasctxbody = this.createContextError(4);
            sc = this.createSvcContext(sasctxbody);
            CSIV2Messages.fineMsg("Adding ContextError message to service context list");
            ri.add_reply_service_context(sc, false);
            CSIV2Messages.fineMsg("SecurityContext set to null");
            throw new NO_PERMISSION();
        }
        if (sasdiscr != 0) {
            CSIV2Messages.severeMsg(this.prname + "Received Message not an EstablishContext message.");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_not_ec_msg", "Received message not an EstablishContext message."));
        }
        EstablishContext ec = sasctxbody.establish_msg();
        seccontext = new SecurityContext();
        seccontext.subject = new Subject();
        try {
            if (ec.client_authentication_token.length != 0) {
                CSIV2Messages.fineMsg("Message contains Client Authentication Token");
                this.createAuthCred(seccontext, ec.client_authentication_token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CSIV2Messages.severeMsg("Error while creating a JAAS subject credential.");
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        try {
            if (ec.identity_token != null) {
                CSIV2Messages.fineMsg("Message contains an Identity Token");
                this.createIdCred(seccontext, ec.identity_token);
            }
        }
        catch (SecurityException secex) {
            CSIV2Messages.finerThrowableNoMsg(secex);
            sasctxbody = this.createContextError(2, 1);
            sc = this.createSvcContext(sasctxbody);
            ri.add_reply_service_context(sc, false);
            throw new NO_PERMISSION();
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            CSIV2Messages.fineMsg("Error while creating a JAAS subject credential.");
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        CSIV2Messages.fineMsg("Invoking setSecurityContext() to set security context");
        status = this.secsvc.setSecurityContext(seccontext, ri.object_id(), ri.operation());
        CSIV2Messages.fineMsg("setSecurityContext() returned status code " + status);
        if (status == 1) {
            CSIV2Messages.fineMsg("setSecurityContext() returned STATUS_FAILED");
            sasctxbody = this.createContextError(status);
            sc = this.createSvcContext(sasctxbody);
            CSIV2Messages.fineMsg("Adding ContextError message to service context list");
            ri.add_reply_service_context(sc, false);
            throw new NO_PERMISSION();
        }
        CSIV2Messages.fineMsg("setSecurityContext() returned SUCCESS");
        sasctxbody = this.createCompleteEstablishContext(status);
        sc = this.createSvcContext(sasctxbody);
        CSIV2Messages.fineMsg("Adding CompleteEstablisContext message to service context list");
        ri.add_reply_service_context(sc, false);
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        Counter cntr = (Counter)this.counterForCalls.get();
        if (cntr == null) {
            cntr = new Counter();
            this.counterForCalls.set(cntr);
        }
        if (cntr.count == 0) {
            ServerSecurityService secsvc = Csiv2Manager.getServerSecurityService();
            secsvc.unsetSecurityContext();
        }
        cntr.increment();
    }

    public void send_reply(ServerRequestInfo ri) {
        this.unsetSecurityContext();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void destroy() {
    }

    private void unsetSecurityContext() {
        Counter cntr = (Counter)this.counterForCalls.get();
        if (cntr == null) {
            cntr = new Counter(1);
        }
        cntr.decrement();
        if (cntr.count == 0) {
            ServerSecurityService secsvc = Csiv2Manager.getServerSecurityService();
            secsvc.unsetSecurityContext();
        }
    }
}

