/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import java.util.StringTokenizer;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.iiop.security.GSSUtils;

public class GSSUPName {
    public static final char AT_CHAR = '@';
    public static final String AT_STRING = "@";
    public static final char ESCAPE_CHAR = '\\';
    public static final String ESCAPE_STRING = "\\";
    private String username;
    private String realm;

    public GSSUPName(String username, String realm) {
        this.username = username;
        this.realm = realm;
    }

    public GSSUPName(byte[] GSSExportedName) {
        StringBuffer strbuf = new StringBuffer("");
        int realm_index = 0;
        int user_index = -1;
        String expname = "";
        String name_value = "";
        String name_scope = "";
        byte[] exportedname = new byte[]{};
        CSIV2Messages.fineMsg("Attempting to create a mechanism specific name from the exported name.");
        try {
            exportedname = GSSUtils.importName(GSSUtils.GSSUP_MECH_OID, GSSExportedName);
            expname = new String(exportedname, "UTF8");
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
        }
        CSIV2Messages.fineMsg("Mechanism specific name: " + expname);
        int at_index = expname.indexOf(64);
        int esc_index = expname.indexOf(92);
        if (at_index == -1) {
            name_value = expname;
        } else if (esc_index == -1) {
            if (at_index != 0) {
                name_value = expname.substring(0, at_index);
            }
            name_scope = expname.substring(at_index + 1);
        } else {
            user_index = 0;
            realm_index = 0;
            int i = 0;
            while ((i = expname.indexOf(64, i)) != -1) {
                if (expname.charAt(i - 1) != '\\') {
                    realm_index = i;
                    break;
                }
                ++i;
            }
            name_value = expname.substring(user_index, realm_index);
            name_scope = expname.substring(realm_index + 1);
        }
        CSIV2Messages.fineMsg("name_value: " + name_value + " ;  name_scope: " + name_scope);
        if (name_value.length() > 0 && at_index != -1) {
            strbuf = new StringBuffer("");
            int starti = 0;
            int endi = 0;
            while ((endi = name_value.indexOf(92, starti)) != -1) {
                strbuf.append(name_value.substring(starti, endi));
                starti = endi + 1;
            }
            strbuf.append(name_value.substring(starti));
            name_value = strbuf.toString();
        }
        this.username = name_value;
        this.realm = name_scope;
        CSIV2Messages.fineMsg("Constructed GSSUPName ( " + this.toString() + " )");
    }

    protected byte[] getExportedName() {
        byte[] expname = new byte[]{};
        byte[] expname_utf8 = new byte[]{};
        CSIV2Messages.fineMsg("Going to create exported name for:" + this.toString());
        StringBuffer strbuf = new StringBuffer("");
        int at_index = this.username.indexOf(64);
        int esc_index = this.username.indexOf(92);
        if (at_index == -1 && esc_index == -1) {
            strbuf = new StringBuffer(this.username);
        } else {
            StringTokenizer strtok;
            if (esc_index != -1) {
                strtok = new StringTokenizer(this.username, ESCAPE_STRING);
                while (strtok.hasMoreTokens()) {
                    strbuf.append(strtok.nextToken());
                    strbuf.append('\\').append('\\');
                }
            }
            if (at_index != -1) {
                strtok = new StringTokenizer(this.username, AT_STRING);
                while (strtok.hasMoreTokens()) {
                    strbuf.append(strtok.nextToken());
                    strbuf.append('\\').append('@');
                }
            }
        }
        CSIV2Messages.fineMsg("username after processing for @ and \\ : " + strbuf);
        if (this.realm.length() > 0) {
            strbuf.append('@');
            strbuf.append(this.realm);
        }
        CSIV2Messages.fineMsg("username and realm name : " + strbuf);
        try {
            expname_utf8 = strbuf.toString().getBytes("UTF8");
            expname = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, expname_utf8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CSIV2Messages.fineMsg("GSSUPName in exported format = " + GSSUtils.dumpHex(expname));
        return expname;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUser() {
        return this.username;
    }

    public boolean equals(Object o) {
        GSSUPName nm;
        return o instanceof GSSUPName && (nm = (GSSUPName)o).getUser().equals(this.username) && nm.getRealm().equals(this.realm);
    }

    public int hashCode() {
        return this.username.hashCode() + this.realm.hashCode();
    }

    public String toString() {
        String s = "Username = " + this.username;
        s = s + " Realm = " + this.realm;
        return s;
    }

    private static void testGSSUP(String user, String realm) {
        System.out.println("Running unit test for TestGSSUPName.");
        System.out.println("Creating a GSSUPName instance");
        GSSUPName gssname = new GSSUPName(user, realm);
        System.out.println("GSSUPName : " + gssname.toString());
        System.out.println("Obtaining an exported name form");
        byte[] expname = gssname.getExportedName();
        System.out.println("Creating a GSSUPName instance from exported name");
        GSSUPName gssname1 = new GSSUPName(expname);
        System.out.println("GSSUPName created from exported name: " + gssname1.toString());
    }

    public static void main(String[] args) {
        GSSUPName.testGSSUP("sekhar@vajjha@la@", "sun.com");
        GSSUPName.testGSSUP("sekhar", "sun.com");
        GSSUPName.testGSSUP("sekhar", "");
        GSSUPName.testGSSUP("", "sun.com");
    }
}

