/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.configuration;

import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.PersistenceContextReference;
import com.evermind.server.ejb.deployment.PersistenceUnitReference;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.j2ee.deployment.DeploymentMessages;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.oc4j.configuration.J2EEContextDescriptor;
import org.w3c.dom.Node;

public class J2EEContextConfigDelegate
implements J2EEContextDescriptor {
    private AbstractDescribable m_describable;
    private List m_environmentEntries;
    private List m_ejbReferences;
    private List m_resourceReferences;
    private List m_resourceEnvironmentReferences;
    private List m_destinationReferences;
    private List m_serviceReferences;
    private List m_persistenceUnitReferences;
    private List m_persistenceContextReferences;

    public J2EEContextConfigDelegate(AbstractDescribable describable) {
        this.m_describable = describable;
    }

    public synchronized void addEnvironmentEntry(EnvironmentEntry entry) {
        if (this.m_environmentEntries == null) {
            this.m_environmentEntries = new ArrayList();
        }
        this.m_environmentEntries.add(entry);
        this.m_describable.firePropertyChangeEvent("environmentEntries", null, entry);
    }

    public synchronized void removeEnvironmentEntry(int pos) {
        this.m_describable.firePropertyChangeEvent("environmentEntries", this.m_environmentEntries.remove(pos), null);
    }

    public synchronized void removeEnvironmentEntry(EnvironmentEntry reference) {
        if (this.m_environmentEntries == null) {
            return;
        }
        this.m_environmentEntries.remove(reference);
        this.m_describable.firePropertyChangeEvent("environmentEntries", reference, null);
    }

    public synchronized List getEnvironmentEntries() {
        if (this.m_environmentEntries == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_environmentEntries;
    }

    public synchronized EnvironmentEntry getEnvironmentEntry(String name) {
        if (this.m_environmentEntries == null) {
            return null;
        }
        Iterator iterator = this.m_environmentEntries.iterator();
        while (iterator.hasNext()) {
            EnvironmentEntry entry = (EnvironmentEntry)iterator.next();
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public synchronized void addEJBReference(EJBReference reference) {
        if (this.m_ejbReferences == null) {
            this.m_ejbReferences = new ArrayList();
        }
        this.m_ejbReferences.add(reference);
        this.m_describable.firePropertyChangeEvent("ejbReferences", null, reference);
    }

    public synchronized void removeEJBReference(EJBReference reference) {
        if (this.m_ejbReferences == null) {
            return;
        }
        if (this.m_ejbReferences.remove(reference)) {
            this.m_describable.firePropertyChangeEvent("ejbReferences", reference, null);
        }
    }

    public synchronized List getEJBReferences() {
        if (this.m_ejbReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_ejbReferences;
    }

    public synchronized EJBReference getEJBReference(String name) {
        if (this.m_ejbReferences == null) {
            return null;
        }
        Iterator iterator = this.m_ejbReferences.iterator();
        while (iterator.hasNext()) {
            EJBReference reference = (EJBReference)iterator.next();
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    public synchronized void addResourceReference(ResourceReference resourceReference) {
        if (this.m_resourceReferences == null) {
            this.m_resourceReferences = new ArrayList();
        }
        this.m_resourceReferences.add(resourceReference);
        this.m_describable.firePropertyChangeEvent("resourceReferences", null, resourceReference);
    }

    public synchronized void removeResourceReference(ResourceReference reference) {
        if (this.m_resourceReferences == null) {
            return;
        }
        this.m_resourceReferences.remove(reference);
        this.m_describable.firePropertyChangeEvent("resourceReferences", reference, null);
    }

    public synchronized List getResourceReferences() {
        if (this.m_resourceReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_resourceReferences;
    }

    public synchronized ResourceReference getResourceReference(String name) {
        if (this.m_resourceReferences == null) {
            return null;
        }
        Iterator iterator = this.m_resourceReferences.iterator();
        while (iterator.hasNext()) {
            ResourceReference reference = (ResourceReference)iterator.next();
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    public synchronized void addResourceEnvironmentReference(ResourceEnvironmentReference resourceEnvironmentReference) {
        if (this.m_resourceEnvironmentReferences == null) {
            this.m_resourceEnvironmentReferences = new ArrayList();
        }
        this.m_resourceEnvironmentReferences.add(resourceEnvironmentReference);
        this.m_describable.firePropertyChangeEvent("resourceEnvironmentReferences", null, resourceEnvironmentReference);
    }

    public synchronized void removeResourceEnvironmentReference(ResourceEnvironmentReference reference) {
        if (this.m_resourceEnvironmentReferences == null) {
            return;
        }
        this.m_resourceEnvironmentReferences.remove(reference);
        this.m_describable.firePropertyChangeEvent("resourceEnvironmentReferences", reference, null);
    }

    public synchronized List getResourceEnvironmentReferences() {
        if (this.m_resourceEnvironmentReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_resourceEnvironmentReferences;
    }

    public synchronized ResourceEnvironmentReference getResourceEnvironmentReference(String name) {
        if (this.m_resourceEnvironmentReferences == null) {
            return null;
        }
        Iterator iterator = this.m_resourceEnvironmentReferences.iterator();
        while (iterator.hasNext()) {
            ResourceEnvironmentReference reference = (ResourceEnvironmentReference)iterator.next();
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    public synchronized void addDestinationReference(DestinationReference destinationReference) {
        if (this.m_destinationReferences == null) {
            this.m_destinationReferences = new ArrayList();
        }
        this.m_destinationReferences.add(destinationReference);
        this.m_describable.firePropertyChangeEvent("destinationReferences", null, destinationReference);
    }

    public synchronized void removeDestinationReference(DestinationReference reference) {
        if (this.m_destinationReferences == null) {
            return;
        }
        this.m_destinationReferences.remove(reference);
        this.m_describable.firePropertyChangeEvent("destinationReferences", reference, null);
    }

    public synchronized List getDestinationReferences() {
        if (this.m_destinationReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_destinationReferences;
    }

    public synchronized DestinationReference getDestinationReference(String name) {
        if (this.m_destinationReferences == null) {
            return null;
        }
        Iterator iterator = this.m_destinationReferences.iterator();
        while (iterator.hasNext()) {
            DestinationReference reference = (DestinationReference)iterator.next();
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    public synchronized void addServiceReference(ServiceReferenceDescriptor serviceReference) {
        if (this.m_serviceReferences == null) {
            this.m_serviceReferences = new ArrayList();
        }
        this.m_serviceReferences.add(serviceReference);
        this.m_describable.firePropertyChangeEvent("serviceReferences", null, serviceReference);
    }

    public synchronized void removeServiceReference(ServiceReferenceDescriptor reference) {
        if (this.m_serviceReferences == null) {
            return;
        }
        this.m_serviceReferences.remove(reference);
        this.m_describable.firePropertyChangeEvent("serviceReferences", reference, null);
    }

    public synchronized List getServiceReferences() {
        if (this.m_serviceReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_serviceReferences;
    }

    public synchronized ServiceReferenceDescriptor getServiceReference(String name) {
        if (this.m_serviceReferences == null) {
            return null;
        }
        Iterator iterator = this.m_serviceReferences.iterator();
        while (iterator.hasNext()) {
            ServiceReferenceDescriptor reference = (ServiceReferenceDescriptor)iterator.next();
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    public synchronized void addPersistenceUnitReference(PersistenceUnitReference entry) {
        if (this.m_persistenceUnitReferences == null) {
            this.m_persistenceUnitReferences = new ArrayList();
        }
        this.m_persistenceUnitReferences.add(entry);
    }

    public synchronized void removePersistenceUnitReference(PersistenceUnitReference reference) {
        if (this.m_persistenceUnitReferences == null) {
            return;
        }
        this.m_persistenceUnitReferences.remove(reference);
    }

    public synchronized List getPersistenceUnitReferences() {
        if (this.m_persistenceUnitReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_persistenceUnitReferences;
    }

    public synchronized PersistenceUnitReference getPersistenceUnitReference(String name) {
        if (this.m_persistenceUnitReferences == null) {
            return null;
        }
        Iterator iterator = this.m_persistenceUnitReferences.iterator();
        while (iterator.hasNext()) {
            PersistenceUnitReference entry = (PersistenceUnitReference)iterator.next();
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public synchronized void addPersistenceContextReference(PersistenceContextReference entry) {
        if (this.m_persistenceContextReferences == null) {
            this.m_persistenceContextReferences = new ArrayList();
        }
        this.m_persistenceContextReferences.add(entry);
    }

    public synchronized void removePersistenceContextReference(PersistenceContextReference reference) {
        if (this.m_persistenceContextReferences == null) {
            return;
        }
        this.m_persistenceContextReferences.remove(reference);
    }

    public synchronized List getPersistenceContextReferences() {
        if (this.m_persistenceContextReferences == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_persistenceContextReferences;
    }

    public synchronized PersistenceContextReference getPersistenceContextReference(String name) {
        if (this.m_persistenceContextReferences == null) {
            return null;
        }
        Iterator iterator = this.m_persistenceContextReferences.iterator();
        while (iterator.hasNext()) {
            PersistenceContextReference entry = (PersistenceContextReference)iterator.next();
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public boolean parseNode(Node node) throws InstantiationException {
        boolean recognized = true;
        String name = node.getNodeName();
        if (name.equals("display-name")) {
            this.m_describable.setDisplayName(XMLUtils.getStringValue(node));
        } else if (name.equals("description")) {
            this.m_describable.setDescription(XMLUtils.getStringValue(node));
        } else if (name.equals("env-entry")) {
            this.addOrOverrideEnvironmentEntry(node);
        } else if (name.equals("ejb-ref")) {
            this.addOrOverrideEJBReference(node, false);
        } else if (name.equals("ejb-local-ref")) {
            this.addOrOverrideEJBReference(node, true);
        } else if (name.equals("resource-ref")) {
            this.addOrOverrideResourceReference(node);
        } else if (name.equals("resource-env-ref")) {
            this.addOrOverrideResourceEnvironmentReference(node);
        } else if (name.equals("message-destination-ref")) {
            this.addOrOverrideDestinationReference(node);
        } else if (name.equals("service-ref")) {
            this.addOrOverrideServiceReferenceDescriptor(node);
        } else if (name.equals("persistence-unit-ref")) {
            this.addOrOverridePersistenceUnitReference(node);
        } else if (name.equals("persistence-context-ref")) {
            this.addOrOverridePersistenceContextReference(node);
        } else {
            recognized = false;
        }
        return recognized;
    }

    private void addOrOverridePersistenceContextReference(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "persistence-context-ref-name");
        PersistenceContextReference contextRef = null;
        if (name != null) {
            contextRef = this.getPersistenceContextReference(name);
        }
        if (contextRef == null) {
            this.addPersistenceContextReference(new PersistenceContextReference(node));
        } else {
            contextRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void addOrOverridePersistenceUnitReference(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "persistence-unit-ref-name");
        PersistenceUnitReference unitRef = null;
        if (name != null) {
            unitRef = this.getPersistenceUnitReference(name);
        }
        if (unitRef == null) {
            this.addPersistenceUnitReference(new PersistenceUnitReference(node));
        } else {
            unitRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void addOrOverrideResourceReference(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "res-ref-name");
        ResourceReference resRef = null;
        if (name != null) {
            resRef = this.getResourceReference(name);
        }
        if (resRef == null) {
            this.addResourceReference(new ResourceReference(node));
        } else {
            resRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void addOrOverrideEJBReference(Node node, boolean isLocal) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "ejb-ref-name");
        EJBReference ejbRef = null;
        if (name != null) {
            ejbRef = this.getEJBReference(name);
        }
        if (ejbRef == null) {
            this.addEJBReference(new EJBReference(node, isLocal));
        } else {
            ejbRef.parseXML(node, isLocal);
            this.logMessage(name);
        }
    }

    private void addOrOverrideEnvironmentEntry(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "env-entry-name");
        EnvironmentEntry envRef = null;
        if (name != null) {
            envRef = this.getEnvironmentEntry(name);
        }
        if (envRef == null) {
            this.addEnvironmentEntry(new EnvironmentEntry(node));
        } else {
            envRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void addOrOverrideResourceEnvironmentReference(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "resource-env-ref-name");
        ResourceEnvironmentReference resEnvRef = null;
        if (name != null) {
            resEnvRef = this.getResourceEnvironmentReference(name);
        }
        if (resEnvRef == null) {
            this.addResourceEnvironmentReference(new ResourceEnvironmentReference(node));
        } else {
            resEnvRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void addOrOverrideDestinationReference(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "message-destination-ref-name");
        DestinationReference desRef = null;
        if (name != null) {
            desRef = this.getDestinationReference(name);
        }
        if (desRef == null) {
            this.addDestinationReference(new DestinationReference(node));
        } else {
            desRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void addOrOverrideServiceReferenceDescriptor(Node node) throws InstantiationException {
        String name = XMLUtils.getSubnodeValue(node, "service-ref-name");
        ServiceReferenceDescriptor serviceRef = null;
        if (name != null) {
            serviceRef = this.getServiceReference(name);
        }
        if (serviceRef == null) {
            this.addServiceReference(new ServiceReferenceDescriptor(node));
        } else {
            serviceRef.parseXML(node);
            this.logMessage(name);
        }
    }

    private void logMessage(String name) {
        DeploymentMessages.fineOverrideReference(name);
    }

    public void clear() {
        this.m_environmentEntries = null;
        this.m_ejbReferences = null;
        this.m_resourceReferences = null;
        this.m_resourceEnvironmentReferences = null;
        this.m_destinationReferences = null;
        this.m_persistenceUnitReferences = null;
        this.m_persistenceContextReferences = null;
    }

    public String getDisplayName() {
        return this.m_describable.getDisplayName();
    }

    public boolean isEmpty() {
        return this.getDestinationReferences().isEmpty() && this.getEJBReferences().isEmpty() && this.getEnvironmentEntries().isEmpty() && this.getPersistenceContextReferences().isEmpty() && this.getPersistenceUnitReferences().isEmpty() && this.getResourceEnvironmentReferences().isEmpty() && this.getResourceReferences().isEmpty() && this.getServiceReferences().isEmpty();
    }

    public synchronized void addReferences(J2EEContextConfigDelegate config) {
        Iterator iter = config.getDestinationReferences().iterator();
        while (iter.hasNext()) {
            this.addDestinationReference((DestinationReference)iter.next());
        }
        iter = config.getEJBReferences().iterator();
        while (iter.hasNext()) {
            this.addEJBReference((EJBReference)iter.next());
        }
        iter = config.getEnvironmentEntries().iterator();
        while (iter.hasNext()) {
            this.addEnvironmentEntry((EnvironmentEntry)iter.next());
        }
        iter = config.getPersistenceContextReferences().iterator();
        while (iter.hasNext()) {
            this.addPersistenceContextReference((PersistenceContextReference)iter.next());
        }
        iter = config.getPersistenceUnitReferences().iterator();
        while (iter.hasNext()) {
            this.addPersistenceUnitReference((PersistenceUnitReference)iter.next());
        }
        iter = config.getResourceEnvironmentReferences().iterator();
        while (iter.hasNext()) {
            this.addResourceEnvironmentReference((ResourceEnvironmentReference)iter.next());
        }
        iter = config.getResourceReferences().iterator();
        while (iter.hasNext()) {
            this.addResourceReference((ResourceReference)iter.next());
        }
        iter = config.getServiceReferences().iterator();
        while (iter.hasNext()) {
            this.addServiceReference((ServiceReferenceDescriptor)iter.next());
        }
    }
}

