/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.appclient;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.appclient.AppClientLauncher;
import oracle.oc4j.appclient.AppClientLauncherFactory;

public class AppClientContainer {
    private static Logger m_logger = TraceLogger.getLogger(AppClientContainer.class);
    private static ApplicationClientShutdownHandler shutdownHandler = new DefaultShutdownHandler();

    public static void main(String[] args) throws Exception {
        if (!AppClientContainer.validateArgs(args)) {
            AppClientContainer.showUsageAndExit();
        } else {
            AppClientLauncher appClientLauncher = AppClientLauncherFactory.getLauncher();
            appClientLauncher.init(args[0]);
            appClientLauncher.initServices();
            appClientLauncher.injectDependencies();
            appClientLauncher.preLaunch();
            appClientLauncher.launch(AppClientContainer.parseClientInput(args));
            appClientLauncher.postLaunch();
        }
    }

    static String[] parseClientInput(String[] args) {
        String[] clientArgs = new String[]{};
        if (args.length > 1) {
            clientArgs = new String[args.length - 1];
            System.arraycopy(args, 1, clientArgs, 0, args.length - 1);
        }
        return clientArgs;
    }

    static boolean validateArgs(String[] args) {
        if (args == null) {
            return false;
        }
        if (args.length < 1) {
            return false;
        }
        return args[0].indexOf("http://") == -1;
    }

    static void setShutdownHandler(ApplicationClientShutdownHandler handler) {
        shutdownHandler = handler;
    }

    static void resetState() {
        shutdownHandler = new DefaultShutdownHandler();
    }

    private static void showUsageAndExit() {
        StringBuffer sb = new StringBuffer();
        sb.append("Wrong argument to oc4jclient.jar. The usage is as below:\n\n");
        sb.append("java -jar oc4jclient.jar <path to application client jar>");
        sb.append("\n");
        m_logger.log(Level.SEVERE, sb.toString());
        AppClientContainer.exit();
    }

    private static void exit() {
        shutdownHandler.shutdownContainer();
    }

    private static class DefaultShutdownHandler
    implements ApplicationClientShutdownHandler {
        private DefaultShutdownHandler() {
        }

        public void shutdownContainer() {
            System.exit(0);
        }
    }

    static interface ApplicationClientShutdownHandler {
        public void shutdownContainer();
    }
}

