/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.deployment.EnterpriseArchive;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.SecurityProviderManagerMBean;
import oracle.oc4j.security.SecurityUtil;
import oracle.security.jazn.jmx.SecurityProviderCallbackIf;
import oracle.security.jazn.oc4j.JAZNUserManager;
import oracle.security.jazn.util.Env;

public class SecurityProviderManager
extends J2EEManagedObjectBase
implements SecurityProviderManagerMBean,
NotificationListener {
    private String _appName;
    private SecurityProviderCallbackIf _callback;
    private Application _application = null;
    private static String _resourceBundleLocation = "oracle.security.jazn.jmx.SecurityProviderResources";

    public SecurityProviderManager(String appName, SecurityProviderCallbackIf callback) {
        this._appName = appName;
        this._callback = callback;
        this.setBaseObjectName(":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + this._appName + ",J2EEServer=standalone");
        this.init(Locale.getDefault());
    }

    public SecurityProviderManager(String appName, SecurityProviderCallbackIf callback, Application application) {
        this(appName, callback);
        this._application = application;
    }

    public SecurityProviderManager(Locale locale) {
        super(locale);
        this.init(locale);
    }

    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        try {
            if (Boolean.FALSE.equals(this.isConfigDirty())) {
                return;
            }
            UserManager usrmngr = this._application.getConfig().getUserManager();
            if (usrmngr == null) {
                System.out.println("Unable to configure security provider MBean for " + this._application.getName());
                System.out.println("User Manager not defined for this application");
                return;
            }
            if (!SecurityUtil.isJAZN(usrmngr)) {
                System.out.println("Unable to configure security provider MBean for " + this._application.getName());
                System.out.println("User Manager not of required type for this application");
                return;
            }
            usrmngr = SecurityUtil.toJAZN(usrmngr);
            Class<?> securityProviderClass = Class.forName(((JAZNUserManager)usrmngr).getJAZNConfig().getSecurityProviderClassName(), true, this._application.getParentClassLoader());
            Constructor<?> objCtr = securityProviderClass.getConstructor(JAZNUserManager.class);
            this._callback = (SecurityProviderCallbackIf)objCtr.newInstance(usrmngr);
        }
        catch (Throwable t) {
            System.out.println("Error while configuring security provider MBean for application " + this._application.getName());
            t.printStackTrace();
        }
    }

    public void preDeregister() throws Exception {
        ObjectName appObjectName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + this._appName + ",J2EEServer=" + "standalone");
        try {
            this.getMBeanServer().removeNotificationListener(appObjectName, this);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private void init(Locale locale) {
        ResourceBundle rsrcBndl = ResourceBundle.getBundle(_resourceBundleLocation, locale);
        HashMap<String, String> persistenceDescriptor = new HashMap<String, String>();
        persistenceDescriptor.put("persistPolicy", "OnUpdate");
        HashMap<String, String> persistenceRestartDescriptor = new HashMap<String, String>();
        persistenceRestartDescriptor.put("persistPolicy", "OnUpdate");
        persistenceRestartDescriptor.put("requireRestart", "applicationRestart");
        HashMap<String, String> oc4jRestartDescriptor = new HashMap<String, String>();
        oc4jRestartDescriptor.put("requireRestart", "oc4jRestart");
        HashMap<String, String> oc4jPersistenceRestartDescriptor = new HashMap<String, String>();
        oc4jPersistenceRestartDescriptor.put("requireRestart", "oc4jRestart");
        oc4jPersistenceRestartDescriptor.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("properties", "java.util.Properties", rsrcBndl.getString("securityprovidermanager_properties"), true, true, false), persistenceRestartDescriptor);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("securityProvider", "java.lang.String", rsrcBndl.getString("securityprovidermanager_securityProvider"), true, false, false));
        MBeanParameterInfo[] params = null;
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("applicationName", "java.lang.String", "The name of the application")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSecurityProvider", rsrcBndl.getString("securityprovidermanager_getSecurityProvider"), params, "javax.management.ObjectName", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getAvailableSecurityProviders", rsrcBndl.getString("securityprovidermanager_getAvailableSecurityProviders"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", "The property key name"), new MBeanParameterInfo("value", "java.lang.String", "The property value")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setProperty", rsrcBndl.getString("securityprovidermanager_setProperty"), params, "void", 1), persistenceRestartDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", "The property key name")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getProperty", rsrcBndl.getString("securityprovidermanager_getProperty"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", "The property key name")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeProperty", rsrcBndl.getString("securityprovidermanager_removeProperty"), params, "void", 1), persistenceRestartDescriptor);
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listUsers", rsrcBndl.getString("securityprovidermanager_listUsers"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realm", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listUsers", rsrcBndl.getString("securityprovidermanager_listUsers_realm"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listUserswRole", rsrcBndl.getString("securityprovidermanager_listUserswRole"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The arguments of the permission class")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listUserswPerm", rsrcBndl.getString("securityprovidermanager_listUserswPerm"), params, "java.util.ArrayList", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listRoles", rsrcBndl.getString("securityprovidermanager_listRoles"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listRoles", rsrcBndl.getString("securityprovidermanager_listRoles_realm"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("direct_grant", "java.lang.Boolean", "Retrieve only direct granted roles")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listRoles", rsrcBndl.getString("securityprovidermanager_listRoles_realm_user"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("direct_grant", "java.lang.Boolean", "Retrieve only direct granted roles")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listUserRoles", rsrcBndl.getString("securityprovidermanager_listUserRoles"), params, "java.util.HashMap", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("direct_grant", "java.lang.Boolean", "Retrieve only direct granted roles")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listRoleRoles", rsrcBndl.getString("securityprovidermanager_listRoleRoles"), params, "java.util.ArrayList", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listRealms", rsrcBndl.getString("securityprovidermanager_listRealms"), params, "java.util.ArrayList", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listLoginModules", rsrcBndl.getString("securityprovidermanager_listLoginModules"), params, "java.util.HashMap", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("application_name", "java.lang.String", "The name of the application")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listLoginModules", rsrcBndl.getString("securityprovidermanager_listLoginModules_application"), params, "java.util.Vector", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("application_name", "java.lang.String", "The name of the application"), new MBeanParameterInfo("loginmodule_name", "java.lang.String", "The name of the login module")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listLoginModule", rsrcBndl.getString("securityprovidermanager_listLoginModule"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("passwd", "java.lang.String", "The password of the user"), new MBeanParameterInfo("realm", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addUser", rsrcBndl.getString("securityprovidermanager_addUser"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addRole", rsrcBndl.getString("securityprovidermanager_addRole"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("adminname", "java.lang.String", "The name of the admin user"), new MBeanParameterInfo("adminpasswd", "java.lang.String", "The password of the admin user"), new MBeanParameterInfo("adminrole", "java.lang.String", "The name of the admin role")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addRealm", rsrcBndl.getString("securityprovidermanager_addRealm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("applicationName", "java.lang.String", "The name of the application"), new MBeanParameterInfo("loginModuleClass", "java.lang.String", "The name of the login module"), new MBeanParameterInfo("controlFlag", "java.lang.String", "The value of the control flag"), new MBeanParameterInfo("options", "java.util.Map", "The map of options")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setLoginModule", rsrcBndl.getString("securityprovidermanager_setLoginModule"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("user", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realm", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("remUser", rsrcBndl.getString("securityprovidermanager_remUser"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("remRole", rsrcBndl.getString("securityprovidermanager_remRole"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realm", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("remRealm", rsrcBndl.getString("securityprovidermanager_remRealm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("applicationName", "java.lang.String", "The name of the application"), new MBeanParameterInfo("loginModuleClass", "java.lang.String", "The name of the login module")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("remLoginModule", rsrcBndl.getString("securityprovidermanager_remLoginModule"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listUserPerms", rsrcBndl.getString("securityprovidermanager_listUserPerms"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listRolePerms", rsrcBndl.getString("securityprovidermanager_listRolePerms"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("prncplclass", "java.lang.String", "The name of the principal class"), new MBeanParameterInfo("prncplparam", "java.lang.String", "The principal parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listPrncplPerms", rsrcBndl.getString("securityprovidermanager_listPrncplPerms"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The permission parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("grantUserPerm", rsrcBndl.getString("securityprovidermanager_grantUserPerm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The permission parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("grantRolePerm", rsrcBndl.getString("securityprovidermanager_grantRolePerm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("prncplclass", "java.lang.String", "The name of the principal class"), new MBeanParameterInfo("prncplparam", "java.lang.String", "The principal parameters"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The permission parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("grantPrncplPerm", rsrcBndl.getString("securityprovidermanager_grantPrncplPerm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("grantUserRole", rsrcBndl.getString("securityprovidermanager_grantUserRole"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("roles", "java.util.ArrayList", "The names of the roles"), new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("grantUserRoles", rsrcBndl.getString("securityprovidermanager_grantUserRoles"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("torolename", "java.lang.String", "The name of the role to which grant is done"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("grantRoleRole", rsrcBndl.getString("securityprovidermanager_grantRoleRole"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("revokeUserRole", rsrcBndl.getString("securityprovidermanager_revokeUserRole"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("roles", "java.util.ArrayList", "The names of the roles"), new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("revokeUserRoles", rsrcBndl.getString("securityprovidermanager_revokeUserRoles"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("fromrolename", "java.lang.String", "The name of the role from which revoke is done"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("revokeRoleRole", rsrcBndl.getString("securityprovidermanager_revokeRoleRole"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The permission parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("revokeUserPerm", rsrcBndl.getString("securityprovidermanager_revokeUserPerm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("rolename", "java.lang.String", "The name of the role"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The permission parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("revokeRolePerm", rsrcBndl.getString("securityprovidermanager_revokeRolePerm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("prncplclass", "java.lang.String", "The name of the principal class"), new MBeanParameterInfo("prncplparam", "java.lang.String", "The principal parameters"), new MBeanParameterInfo("permclass", "java.lang.String", "The name of the permission class"), new MBeanParameterInfo("permargs", "[Ljava.lang.String;", "The permission parameters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("revokePrncplPerm", rsrcBndl.getString("securityprovidermanager_revokePrncplPerm"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("oldpwd", "java.lang.String", "The old password of the user"), new MBeanParameterInfo("newpwd", "java.lang.String", "The new password of the user")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setPasswd", rsrcBndl.getString("securityprovidermanager_setPasswd"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("password", "java.lang.String", "The password of the user")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("checkPwd", rsrcBndl.getString("securityprovidermanager_checkPwd"), params, "java.lang.Boolean", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("file", "java.lang.String", "The content of the file"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("parseOrionXML", rsrcBndl.getString("securityprovidermanager_parseOrionXML"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getRealmRoleCount", rsrcBndl.getString("securityprovidermanager_getRealmRoleCount"), params, "int", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getRealmUserCount", rsrcBndl.getString("securityprovidermanager_getRealmUserCount"), params, "int", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getRealmsRoleCount", rsrcBndl.getString("securityprovidermanager_getRealmsRoleCount"), params, "java.util.Map", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getRealmsUserCount", rsrcBndl.getString("securityprovidermanager_getRealmsUserCount"), params, "java.util.Map", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getRolesUserCount", rsrcBndl.getString("securityprovidermanager_getRolesUserCount"), params, "java.util.Map", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getJaznDataDescriptor", rsrcBndl.getString("securityprovidermanager_getJaznDataDescriptor"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("providerType", "java.lang.String", "The type of the security provider"), new MBeanParameterInfo("properties", "java.util.Properties", "The properties of the security provider")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setSecurityProvider", rsrcBndl.getString("securityprovidermanager_setSecurityProvider"), params, "void", 1), persistenceRestartDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("serverType", "java.lang.String", "The type of the LDAP server")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLDAPLoginModuleDefaultOptions", rsrcBndl.getString("securityprovidermanager_getLDAPLoginModuleDefaultOptions"), params, "java.util.Map", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLDAPLoginModuleOptions", rsrcBndl.getString("securityprovidermanager_getLDAPLoginModuleOptions"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("options", "java.util.Map", "The map of options")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("validateLDAPLoginModuleOptions", rsrcBndl.getString("securityprovidermanager_validateLDAPLoginModuleOptions"), params, "void", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLoginModuleControlFlagTypes", rsrcBndl.getString("securityprovidermanager_getLoginModuleControlFlagTypes"), params, "[Ljava.lang.String;", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("passwd", "java.lang.String", "The password of the user")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addIndirectUser", rsrcBndl.getString("securityprovidermanager_addIndirectUser"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("params", "java.util.Hashtable", "OID connect paramters")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("associateOC4JWithOID", rsrcBndl.getString("securityprovidermanager_associateOC4JWithOID"), params, "void", 1), oc4jRestartDescriptor);
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("isOC4JAssociatedWithOID", rsrcBndl.getString("securityprovidermanager_isOC4JAssociatedWithOID"), params, "java.lang.Boolean", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listOIDRealms", rsrcBndl.getString("securityprovidermanager_listOIDRealms"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("listOIDRoles", rsrcBndl.getString("securityprovidermanager_listOIDRoles_realm"), params, "java.util.ArrayList", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOIDDefaultRealm", rsrcBndl.getString("securityprovidermanager_getOIDDefaultRealm"), params, "java.lang.String", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOIDHost", rsrcBndl.getString("securityprovidermanager_getOIDHost"), params, "java.lang.String", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOC4JInstanceXMLDefaultRealm", rsrcBndl.getString("securityprovidermanager_getOC4JInstanceXMLDefaultRealm"), params, "java.lang.String", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOC4JInstanceXMLLocationPath", rsrcBndl.getString("securityprovidermanager_getOC4JInstanceXMLLocationPath"), params, "java.lang.String", 0));
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOIDPort", rsrcBndl.getString("securityprovidermanager_getOIDPort"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("issuername", "java.lang.String", "SAML Assertion Issuer Name "), new MBeanParameterInfo("issueralias", "java.lang.String", "SAML Assertion Issuer Root Cert Alias "), new MBeanParameterInfo("issuerkspath", "java.lang.String", "SAML Assertion Issuer Keystore Path "), new MBeanParameterInfo("issuerkspwd", "java.lang.String", "SAML Assertion Issuer Keystore Password "), new MBeanParameterInfo("issuerkstype", "java.lang.String", "SAML Assertion Issuer Keystore Type ")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setAssertionIssuerConfig", rsrcBndl.getString("securityprovidermanager_setAssertionIssuerConfig"), params, "void", 1), persistenceDescriptor);
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getAssertionIssuerConfig", rsrcBndl.getString("securityprovidermanager_getAssertionIssuerConfig"), params, "java.util.ArrayList", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("issuername", "java.lang.String", "SAML Assertion Issuer Name ")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeAssertionIssuerConfig", rsrcBndl.getString("securityprovidermanager_removeAssertionIssuerConfig"), params, "void", 1), persistenceDescriptor);
        params = null;
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("isConfigDirty", rsrcBndl.getString("securityprovidermanager_isConfigDirty"), params, "java.lang.Boolean", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("isUserDeactivated", rsrcBndl.getString("securityprovidermanager_isUserDeactivated"), params, "java.lang.Boolean", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("username", "java.lang.String", "The name of the user"), new MBeanParameterInfo("realmname", "java.lang.String", "The name of the realm"), new MBeanParameterInfo("deactivate", "java.lang.Boolean", "Set activation status.")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setUserDeactivation", rsrcBndl.getString("securityprovidermanager_setUserDeactivation"), params, "void", 1), persistenceDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("algorithm", "java.lang.String", "The encryption algorithm to be used.")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("generateKey", rsrcBndl.getString("securityprovidermanager_generateKey"), params, "java.lang.String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", "The property key name"), new MBeanParameterInfo("value", "java.lang.String", "The property value")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setInstanceProperty", rsrcBndl.getString("securityprovidermanager_setInstanceProperty"), params, "void", 1), oc4jPersistenceRestartDescriptor);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", "The property key name")};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getInstanceProperty", rsrcBndl.getString("securityprovidermanager_getInstanceProperty"), params, "java.lang.String", 0));
    }

    public ObjectName getSecurityProvider(String applicationName) {
        String objectName = this.getDomain() + ":j2eeType=SecurityProvider,name=" + applicationName + ",J2EEServer=standalone";
        try {
            return new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public ArrayList getAvailableSecurityProviders() {
        ArrayList<String> providers = new ArrayList<String>();
        providers.add(Env.PROVIDER_TYPE_XML);
        providers.add(Env.PROVIDER_TYPE_LDAP);
        providers.add(Env.CUSTOM_LDAP_PROVIDER);
        providers.add(Env.CUSTOM_LOGINMODULE_PROVIDER);
        return providers;
    }

    public void setProperty(String key, String value) throws Exception {
        this._callback.setProperty(key, value);
    }

    public String getProperty(String key) throws Exception {
        return this._callback.getProperty(key);
    }

    public void removeProperty(String key) throws Exception {
        this._callback.removeProperty(key);
    }

    public void setproperties(Properties props) throws Exception {
        this._callback.setProperties(props);
    }

    public Properties getproperties() throws Exception {
        return this._callback.getProperties();
    }

    public ArrayList listRealms() throws Exception {
        return this._callback.listRealms();
    }

    public ArrayList listUsers() throws Exception {
        return this._callback.listUsers();
    }

    public ArrayList listUsers(String realm) throws Exception {
        return this._callback.listUsers(realm);
    }

    public ArrayList listUserswRole(String realmname, String rolename) throws Exception {
        return this._callback.listUserswRole(realmname, rolename);
    }

    public String listUserswPerm(String realmname, String permclass, String[] permargs) throws Exception {
        return this._callback.listUserswPerm(realmname, permclass, permargs);
    }

    public ArrayList listRoles() throws Exception {
        return this._callback.listRoles();
    }

    public ArrayList listRoles(String realmname) throws Exception {
        return this._callback.listRoles(realmname);
    }

    public ArrayList listRoles(String username, String realmname, Boolean direct_grant) throws Exception {
        return this._callback.listRoles(username, realmname, direct_grant.booleanValue());
    }

    public ArrayList listRoleRoles(String rolename, String realmname, Boolean direct_grant) throws Exception {
        return this._callback.listRoleRoles(rolename, realmname, direct_grant.booleanValue());
    }

    public HashMap listLoginModules() throws Exception {
        return this._callback.listLoginModules();
    }

    public void addRealm(String realmname, String adminname, String adminpasswd, String adminrole) throws Exception {
        this._callback.addRealm(realmname, adminname, adminpasswd, adminrole);
    }

    public Vector listLoginModules(String application_name) throws Exception {
        return this._callback.listLoginModules(application_name);
    }

    public String listLoginModule(String application_name, String loginmodule_name) throws Exception {
        return this._callback.listLoginModule(application_name, loginmodule_name);
    }

    public void addUser(String username, String passwd, String realm) throws Exception {
        this._callback.addUser(username, passwd, realm);
    }

    public void addRole(String rolename, String realmname) throws Exception {
        this._callback.addRole(rolename, realmname);
    }

    public void setLoginModule(String applicationName, String loginModuleClass, String controlFlag, Map options) throws Exception {
        this._callback.setLoginModule(applicationName, loginModuleClass, controlFlag, options);
    }

    public void remRealm(String realmname) throws Exception {
        this._callback.remRealm(realmname);
    }

    public void remUser(String user, String realm) throws Exception {
        this._callback.remUser(user, realm);
    }

    public void remRole(String rolename, String realmname) throws Exception {
        this._callback.remRole(rolename, realmname);
    }

    public void remLoginModule(String applicationName, String loginModuleClass) throws Exception {
        this._callback.remLoginModule(applicationName, loginModuleClass);
    }

    public ArrayList listUserPerms(String username, String realmname) throws Exception {
        return this._callback.listUserPerms(username, realmname);
    }

    public ArrayList listRolePerms(String rolename, String realmname) throws Exception {
        return this._callback.listRolePerms(rolename, realmname);
    }

    public ArrayList listPrncplPerms(String prncplclass, String prncplparam) throws Exception {
        return this._callback.listPrncplPerms(prncplclass, prncplparam);
    }

    public void grantUserPerm(String username, String realmname, String permclass, String[] permargs) throws Exception {
        this._callback.grantUserPerm(username, realmname, permclass, permargs);
    }

    public void grantRolePerm(String rolename, String realmname, String permclass, String[] permargs) throws Exception {
        this._callback.grantRolePerm(rolename, realmname, permclass, permargs);
    }

    public void grantPrncplPerm(String prncplclass, String prncplparam, String permclass, String[] permargs) throws Exception {
        this._callback.grantPrncplPerm(prncplclass, prncplparam, permclass, permargs);
    }

    public void grantUserRole(String rolename, String username, String realmname) throws Exception {
        this._callback.grantUserRole(rolename, username, realmname);
    }

    public void grantUserRoles(ArrayList roles, String username, String realmname) throws Exception {
        this._callback.grantUserRoles(roles, username, realmname);
    }

    public void grantRoleRole(String rolename, String torolename, String realmname) throws Exception {
        this._callback.grantRoleRole(rolename, torolename, realmname);
    }

    public void revokeUserRole(String rolename, String username, String realmname) throws Exception {
        this._callback.revokeUserRole(rolename, username, realmname);
    }

    public void revokeUserRoles(ArrayList roles, String username, String realmname) throws Exception {
        this._callback.revokeUserRoles(roles, username, realmname);
    }

    public void revokeRoleRole(String rolename, String fromrolename, String realmname) throws Exception {
        this._callback.revokeRoleRole(rolename, fromrolename, realmname);
    }

    public void revokeUserPerm(String username, String realmname, String permclass, String[] permargs) throws Exception {
        this._callback.revokeUserPerm(username, realmname, permclass, permargs);
    }

    public void revokeRolePerm(String rolename, String realmname, String permclass, String[] permargs) throws Exception {
        this._callback.revokeRolePerm(rolename, realmname, permclass, permargs);
    }

    public void revokePrncplPerm(String prncplclass, String prncplparam, String permclass, String[] permargs) throws Exception {
        this._callback.revokePrncplPerm(prncplclass, prncplparam, permclass, permargs);
    }

    public void setPasswd(String realmname, String username, String oldpwd, String newpwd) throws Exception {
        this._callback.setPasswd(realmname, username, oldpwd, newpwd);
    }

    public Boolean checkPwd(String username, String realmname, String password) throws Exception {
        return this._callback.checkPwd(username, realmname, password);
    }

    public void parseOrionXML(String file, String realmname) throws Exception {
        this._callback.parseOrionXML(file, realmname);
    }

    public int getRealmRoleCount(String realmname) throws Exception {
        return this._callback.getRealmRoleCount(realmname);
    }

    public int getRealmUserCount(String realmname) throws Exception {
        return this._callback.getRealmUserCount(realmname);
    }

    public Map getRealmsRoleCount() throws Exception {
        return this._callback.getRealmsRoleCount();
    }

    public Map getRealmsUserCount() throws Exception {
        return this._callback.getRealmsUserCount();
    }

    public Map getRolesUserCount(String realmname) throws Exception {
        return this._callback.getRolesUserCount(realmname);
    }

    public HashMap listUserRoles(String realmname, Boolean direct_grant) throws Exception {
        return this._callback.listUserRoles(realmname, direct_grant.booleanValue());
    }

    public String getJaznDataDescriptor() throws Exception {
        return this._callback.getJaznDataDescriptor();
    }

    public void setSecurityProvider(String providerType, Properties props) throws Exception {
        this._callback.setSecurityProvider(providerType, props);
    }

    public String getsecurityProvider() throws Exception {
        return this._callback.getSecurityProvider();
    }

    public Map getLDAPLoginModuleDefaultOptions(String serverType) throws Exception {
        return this._callback.getLDAPLoginModuleDefaultOptions(serverType);
    }

    public String[] getLDAPLoginModuleOptions() throws Exception {
        return this._callback.getLDAPLoginModuleOptions();
    }

    public void validateLDAPLoginModuleOptions(Map options) throws Exception {
        this._callback.validateLDAPLoginModuleOptions(options);
    }

    public String[] getLoginModuleControlFlagTypes() throws Exception {
        return this._callback.getLoginModuleControlFlagTypes();
    }

    public void addIndirectUser(String username, String passwd) throws Exception {
        this._callback.addIndirectUser(username, passwd);
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            if (this._callback.isConfigDirty()) {
                ((EnterpriseArchive)this._application.getConfig()).storeDeployment();
            }
            this._callback.store();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void associateOC4JWithOID(Hashtable params) throws Exception {
        this._callback.associateOC4JWithOID(params);
    }

    public Boolean isOC4JAssociatedWithOID() throws Exception {
        return new Boolean(this._callback.isOC4JAssociatedWithOID());
    }

    public ArrayList listOIDRealms() throws Exception {
        return this._callback.listOIDRealms();
    }

    public ArrayList listOIDRoles(String realmname) throws Exception {
        return this._callback.listOIDRoles(realmname);
    }

    public String getOIDDefaultRealm() throws Exception {
        return this._callback.getOIDDefaultRealm();
    }

    public String getOIDHost() throws Exception {
        return this._callback.getOIDHost();
    }

    public String getOC4JInstanceXMLDefaultRealm() throws Exception {
        return this._callback.getOC4JInstanceXMLDefaultRealm();
    }

    public String getOC4JInstanceXMLLocationPath() throws Exception {
        return this._callback.getOC4JInstanceXMLLocationPath();
    }

    public String getOIDPort() throws Exception {
        return this._callback.getOIDPort();
    }

    public void setAssertionIssuerConfig(String issuername, String issueralias, String kspath, String kspwd, String kstype) throws Exception {
        this._callback.setAssertionIssuerConfig(issuername, issueralias, kspath, kspwd, kstype);
    }

    public ArrayList getAssertionIssuerConfig() throws Exception {
        return this._callback.getAssertionIssuerConfig();
    }

    public void removeAssertionIssuerConfig(String issuername) throws Exception {
        this._callback.removeAssertionIssuerConfig(issuername);
    }

    public Boolean isConfigDirty() throws Exception {
        return new Boolean(this._callback.isConfigDirty());
    }

    public Boolean isUserDeactivated(String username, String realmname) throws Exception {
        return new Boolean(this._callback.isUserDeactivated(username, realmname));
    }

    public void setUserDeactivation(String username, String realmname, Boolean deactivate) throws Exception {
        this._callback.setUserDeactivation(username, realmname, deactivate.booleanValue());
    }

    public String generateKey(String algorithm) throws Exception {
        return this._callback.generateKey(algorithm);
    }

    public void setInstanceProperty(String key, String value) throws Exception {
        this._callback.setInstanceProperty(key, value);
    }

    public String getInstanceProperty(String key) throws Exception {
        return this._callback.getInstanceProperty(key);
    }
}

