/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.JMSPersistenceCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JMSPersistenceMBean;

public class JMSPersistence
extends J2EEServerDependentObjectBase
implements JMSPersistenceMBean {
    private JMSPersistenceCallBackIf m_callback;
    private String m_file;
    private String m_dest;

    public JMSPersistence(JMSPersistenceCallBackIf callback, String id, String pFile, String dest, String destId) {
        this.m_callback = callback;
        this.m_file = pFile;
        if (destId != null) {
            this.m_dest = dest;
        }
        this.setBaseObjectName(":j2eeType=JMSPersistenceResource,name=" + ObjectNameUtil.quote((String)id) + (destId != null ? ",JMSDestinationResource=" + ObjectNameUtil.quote((String)destId) : "") + ",JMSResource=" + ObjectNameUtil.quote((String)"JMS") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JMSPersistence(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("destination", "java.lang.String", this.getLocalizedMessage("jmspersistence_destination"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("persistenceFile", "java.lang.String", this.getLocalizedMessage("jmspersistence_persistencefile"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("lastUsed", "long", this.getLocalizedMessage("jmspersistence_lastused"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("usedPages", "int", this.getLocalizedMessage("jmspersistence_usedpagecount"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("holePages", "int", this.getLocalizedMessage("jmspersistence_holepagecount"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("isOpen", "boolean", this.getLocalizedMessage("jmspersistence_isopen"), true, false, false));
    }

    public String getdestination() {
        return this.m_dest;
    }

    public String getpersistenceFile() {
        return this.m_file;
    }

    public long getlastUsed() {
        return this.m_callback.getLastUsed();
    }

    public int getusedPages() {
        return this.m_callback.usedPageCount();
    }

    public int getholePages() {
        return this.m_callback.holePageCount();
    }

    public boolean getisOpen() {
        return this.m_callback.isOpen();
    }
}

